/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap;

import at.grid.gui.SimpleGeometry;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.RenderingHints;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Geotools {
    public static Geometry reproject(String fromEPSG, String toEPSG, Geometry g) throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints);
        CoordinateReferenceSystem crs1 = factory.createCoordinateReferenceSystem("EPSG:" + fromEPSG);
        CoordinateReferenceSystem crs2 = factory.createCoordinateReferenceSystem("EPSG:" + toEPSG);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs1, (CoordinateReferenceSystem)crs2, (boolean)true);
        return JTS.transform((Geometry)g, (MathTransform)transform);
    }

    public static boolean checkEPSG(String epsg) {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints);
        try {
            factory.createCoordinateReferenceSystem("EPSG:" + epsg);
            return true;
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) throws FactoryException, NoSuchAuthorityCodeException, MismatchedDimensionException, TransformException {
        SimpleGeometry g = new SimpleGeometry(1);
        g.add(50699.0, 242340.0);
        Geometry g2 = Geotools.reproject("31254", "32632", g.toJTS());
        System.out.println(g2.toString());
    }
}

