/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.servlet;

import at.grid.util.db.ConnectionPool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseServlet
extends HttpServlet {
    public abstract String getDbDriver();

    public abstract String getDbUri();

    public abstract String getDbUser();

    protected abstract String getPoolCode();

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public synchronized Connection getConnection() throws SQLException {
        return ((ConnectionPool)this.getServletContext().getAttribute(this.getPoolCode())).getConnection();
    }

    public synchronized void freeConnection(Connection conn) throws SQLException {
        ((ConnectionPool)this.getServletContext().getAttribute(this.getPoolCode())).free(conn);
    }

    public synchronized void init() {
        try {
            if (this.getServletContext().getAttribute(this.getPoolCode()) == null) {
                this.getServletContext().setAttribute(this.getPoolCode(), (Object)new ConnectionPool(this.getDbDriver(), this.getDbUri(), this.getDbUser(), null, 1, 20, true));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    protected void verifyAndProcessRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.verifyAndProcessRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.verifyAndProcessRequest(request, response);
    }
}

