/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.servlet;

import at.grid.gridmap.util.MapExtent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class MapServlet
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mapsize = this.getMapsize();
        String mode = "map";
        String layers = this.getLayers();
        String mapext = null;
        String scalebar = this.hasScalebar() ? "status+on" : "status+off";
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration paramnames = request.getParameterNames();
        while (paramnames.hasMoreElements()) {
            String paramname = (String)paramnames.nextElement();
            if ("mapsize".equalsIgnoreCase(paramname)) {
                mapsize = request.getParameter(paramname);
                continue;
            }
            if ("layers".equalsIgnoreCase(paramname)) {
                layers = request.getParameter(paramname);
                continue;
            }
            if ("mapext".equalsIgnoreCase(paramname)) {
                mapext = request.getParameter(paramname);
                continue;
            }
            if ("scalebar".equalsIgnoreCase(paramname)) {
                scalebar = "status+" + request.getParameter(paramname);
                continue;
            }
            if ("map".equalsIgnoreCase(paramname)) continue;
            if ("mode".equalsIgnoreCase(paramname)) {
                mode = request.getParameter(paramname);
                continue;
            }
            this.processParameters(params, request, paramname);
        }
        if (mapext == null) {
            try {
                StringTokenizer tok = new StringTokenizer(mapsize, "+");
                double width = Double.parseDouble(tok.nextToken());
                double height = Double.parseDouble(tok.nextToken());
                tok = new StringTokenizer(this.getFullext(), "+");
                double fullext_xmin = Double.parseDouble(tok.nextToken());
                double fullext_ymin = Double.parseDouble(tok.nextToken());
                double fullext_xmax = Double.parseDouble(tok.nextToken());
                MapExtent me = new MapExtent(fullext_xmin, fullext_ymin, fullext_xmax, width, height);
                mapext = me.toCGI();
            }
            catch (Exception tok) {
                // empty catch block
            }
        }
        String[] ext = mapext.split(" ");
        double dx = Double.parseDouble(ext[2]) - Double.parseDouble(ext[0]);
        double dy = Double.parseDouble(ext[3]) - Double.parseDouble(ext[1]);
        String[] ms = mapsize.split(" ");
        double pix = 3.1358024691358023E-4;
        double dxmap = pix * Double.parseDouble(ms[0]);
        double dymap = pix * Double.parseDouble(ms[1]);
        double scale = dx / dxmap;
        String mapfile = this.getMapfile(scale);
        StringBuffer urls = new StringBuffer(this.getServerCGI());
        urls.append("?mode=" + mode);
        urls.append("&map=" + mapfile);
        urls.append("&layers=" + layers);
        urls.append("&mapext=" + mapext);
        urls.append("&mapsize=" + mapsize);
        urls.append("&map.scalebar=" + scalebar);
        for (String k : params.keySet()) {
            urls.append("&" + k + "=" + params.get(k));
        }
        URL mapserver = new URL(urls.toString().replace(" ", "%20"));
        if (request.getParameter("showurl") != null) {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(urls.toString());
            out.close();
        } else {
            BufferedImage bI = ImageIO.read(mapserver);
            response.setContentType("image/" + this.getImageFormat());
            response.setHeader("age-value", "0");
            ImageIO.write((RenderedImage)bI, this.getImageFormat(), (OutputStream)response.getOutputStream());
        }
    }

    protected void processParameters(HashMap<String, String> params, HttpServletRequest request, String paramname) {
        params.put(paramname, request.getParameter(paramname));
    }

    protected abstract String getServerCGI();

    protected abstract String getMapfile(double var1);

    protected abstract String getFullext();

    protected abstract String getLayers();

    protected abstract String getMapsize();

    protected abstract boolean hasScalebar();

    protected abstract String getImageFormat();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

