/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.servlet;

import at.grid.gridmap.servlet.BaseServlet;
import at.grid.gridmap.util.MapExtent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class OverlayServlet
extends BaseServlet {
    protected MapExtent mapext = null;
    protected double scale = -1.0;
    protected boolean debug = false;

    public String getServletInfo() {
        return "Overlay service";
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String service = request.getParameter("service");
        String xmin = request.getParameter("xmin");
        String xmax = request.getParameter("xmax");
        String ymin = request.getParameter("ymin");
        String ymax = request.getParameter("ymax");
        this.mapext = null;
        if (xmax != null && xmin != null && ymax != null && ymin != null) {
            this.mapext = new MapExtent(xmin, xmax, ymin, ymax);
            if (!this.mapext.isValid()) {
                this.mapext = null;
            }
        }
        String scaleStr = request.getParameter("scale");
        this.scale = -1.0;
        if (scaleStr != null) {
            try {
                this.scale = Double.parseDouble(scaleStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (request.getParameter("debug") != null) {
            this.debug = true;
        }
        Document result = service == null ? this.showError("no service name provided") : this.processService(service, request, response);
        PrintWriter out = response.getWriter();
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat().setTextMode(Format.TextMode.PRESERVE));
        output.output(result, (Writer)out);
        out.close();
    }

    protected abstract Document createDocument();

    protected abstract Document processService(String var1, HttpServletRequest var2, HttpServletResponse var3);

    protected synchronized Document showError(String msg) {
        Document doc = this.createDocument();
        doc.getRootElement().addContent((Content)new Element("error").setText(msg));
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, msg);
        return doc;
    }

    protected synchronized ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs = null;
        SQLException exception = null;
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement();
                rs = stmt.executeQuery(sql.toString());
                stmt.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "SQL error using: " + sql.toString(), ex);
                exception = ex;
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "SQL connection error", ex);
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        return rs;
    }

    protected synchronized int executeUpdate(String sql) throws SQLException {
        int count = -1;
        SQLException exception = null;
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement();
                count = stmt.executeUpdate(sql.toString());
                stmt.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "SQL error using: " + sql.toString(), ex);
                exception = ex;
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "SQL connection error", ex);
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        return count;
    }
}

