/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.util;

public class MapExtent {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private boolean valid;

    public MapExtent(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.valid = this.checkValidity();
    }

    public MapExtent(String xmin, String xmax, String ymin, String ymax) {
        try {
            this.xmin = Double.parseDouble(xmin);
            this.xmax = Double.parseDouble(xmax);
            this.ymin = Double.parseDouble(ymin);
            this.ymax = Double.parseDouble(ymax);
            this.valid = this.checkValidity();
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public MapExtent(double xmin, double xmax, double ymin, double width, double height) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = this.ymin + height / width * (this.xmax - this.xmin);
        this.valid = this.checkValidity();
    }

    private boolean checkValidity() {
        if (this.xmin > this.xmax) {
            return false;
        }
        return !(this.ymin > this.ymax);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toSqlBbox(int srid) {
        return "GeometryFromText('Linestring(" + this.xmin + " " + this.ymin + "," + this.xmax + " " + this.ymax + ")','" + srid + "')";
    }

    public String toCGI() {
        return this.xmin + "+" + this.xmax + "+" + this.ymin + "+" + this.ymax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }
}

