/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class Mapfile {
    public static String version = "1.0, 19.10.2007";
    private File fCSV;
    private Vector<String> out;
    private File dir;
    private HashMap<String, Vector<String>> mapOut;
    private String dbName;
    private String dbHost;

    public Mapfile() {
        this(new File("."), "teleatlas", "localhost");
    }

    public Mapfile(File f, String db, String host) {
        this.dir = f;
        this.dbName = db;
        this.dbHost = host;
    }

    public void readExternalFile(String fn, Vector<String> out) throws IllegalArgumentException, IOException {
        String ln;
        File f = new File(this.dir, fn);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("'" + fn + "' does not exist or is not a file");
        }
        BufferedReader fr = new BufferedReader(new FileReader(f));
        while ((ln = fr.readLine()) != null) {
            out.add(ln);
        }
        fr.close();
    }

    private void readCSVfile(String head, String foot, String csv, String fnOut) throws IllegalArgumentException, IOException {
        int ii;
        Vector v = new Vector();
        File f = new File(this.dir, csv);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("'" + csv + "' does not exist or is not a file");
        }
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String[] ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' is empty");
        }
        int size = ln.length - 2;
        String[] layers = new String[size];
        for (ii = 0; ii < size; ++ii) {
            layers[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] groups = new String[size];
        for (ii = 0; ii < size; ++ii) {
            groups[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] connectiontype = new String[size];
        for (ii = 0; ii < size; ++ii) {
            connectiontype[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] processing = new String[size];
        for (ii = 0; ii < size; ++ii) {
            processing[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] data = new String[size];
        for (ii = 0; ii < size; ++ii) {
            data[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] filter = new String[size];
        for (ii = 0; ii < size; ++ii) {
            filter[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] type = new String[size];
        for (ii = 0; ii < size; ++ii) {
            type[ii] = new String(ln[ii + 2]);
        }
        ln = reader.readLine().split(";");
        if (ln == null) {
            throw new IOException("'" + csv + "' has insufficient length");
        }
        if (ln.length != size + 2) {
            throw new IOException("'" + csv + "' has irregular line lengths");
        }
        String[] labelitem = new String[size];
        for (ii = 0; ii < size; ++ii) {
            labelitem[ii] = new String(ln[ii + 2]);
        }
        int counter = 1;
        while ((ln = reader.readLine().split(";")) != null) {
            if (ln.length != size + 2) {
                throw new IOException("'" + csv + "' has irregular line lengths");
            }
            this.out = new Vector();
            String minScale = ln[0].replace("'", "");
            String maxScale = ln[1].replace("'", "");
            String scaleKey = "";
            if (minScale.length() > 0) {
                scaleKey = scaleKey + minScale;
            }
            scaleKey = scaleKey + "-";
            if (maxScale.length() > 0) {
                scaleKey = scaleKey + maxScale;
            }
            this.out.add("# SCALE RANGE " + minScale + " - " + maxScale);
            this.readExternalFile(head, this.out);
            int layercounter = 0;
            for (int ii2 = 0; ii2 < size; ++ii2) {
                String style = ln[ii2 + 2];
                if (style.length() <= 0) continue;
                this.out.add("");
                this.out.add("# -------------");
                this.out.add("");
                this.out.add("# Nr. " + layercounter);
                this.out.add("LAYER");
                this.out.add("GROUP " + groups[ii2]);
                this.out.add("NAME " + layers[ii2]);
                if ("postgis".equalsIgnoreCase(connectiontype[ii2])) {
                    this.out.add("CONNECTION 'user=hk host=" + this.dbHost + " dbname=" + this.dbName + "'");
                    this.out.add("CONNECTIONTYPE postgis");
                    this.out.add("PROCESSING '" + processing[ii2] + "'");
                }
                if ("raster".equalsIgnoreCase(type[ii2])) {
                    this.out.add("TYPE RASTER");
                    this.out.add(style);
                } else {
                    this.out.add("DATA '" + data[ii2] + "'");
                    if (filter[ii2].length() > 0) {
                        this.out.add("FILTER \"" + filter[ii2] + "\"");
                    }
                    this.out.add("    TYPE " + type[ii2]);
                    if (labelitem[ii2].length() > 0) {
                        this.out.add("LABELITEM '" + labelitem[ii2] + "'");
                    }
                    if (style.indexOf("CLASS") < 0) {
                        this.out.add("CLASS");
                    }
                    this.out.add(style);
                    if (style.indexOf("CLASS") < 0) {
                        this.out.add("END");
                    }
                }
                this.out.add("END");
                ++layercounter;
            }
            this.readExternalFile(foot, this.out);
            String filename = fnOut + (counter < 10 ? "0" : "") + counter + ".map";
            this.save(filename, this.out);
            ++counter;
        }
        reader.close();
    }

    public void save(String fn, Vector<String> out) throws IllegalArgumentException, IOException {
        File f = new File(this.dir, fn);
        FileWriter fw = new FileWriter(f);
        for (String ln : out) {
            fw.write(ln + "\n");
        }
        fw.close();
        System.out.println("saved '" + fn + "'");
    }

    public static void main(String[] args) throws Exception {
        boolean showHelp = false;
        String dbname = "teleatlas";
        String prefix = "";
        String host = "localshost";
        for (String a : args) {
            String[] s = a.split("=");
            if (s.length == 1) {
                showHelp = true;
                continue;
            }
            if ("db".equals(s[0])) {
                dbname = s[1];
                continue;
            }
            if ("host".equals(s[0])) {
                host = s[1];
                continue;
            }
            if ("prefix".equals(s[0])) {
                prefix = s[1];
                continue;
            }
            System.out.println("Unknown flag '" + s[0] + "'");
            showHelp = true;
        }
        if (showHelp) {
            System.out.println("Mapfile DB=database_name [PREFIX=fileprefix]" + version);
            System.exit(0);
        }
        File dir = new File(".");
        String fn_map = "";
        if (!"".equals(prefix)) {
            fn_map = prefix + "_";
        }
        String fn_csv = "data.csv";
        String fn_head = "header.map";
        String fn_foot = "footer.map";
        Mapfile m = new Mapfile(dir, dbname, host);
        m.readCSVfile(fn_head, fn_foot, fn_csv, fn_map);
    }
}

