/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.util;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.imageio.ImageIO;

public class Performance {
    public static Date t0;
    public static Date t1;
    public static URL url;

    public static long getImage(String address) throws MalformedURLException, IOException {
        url = new URL(address);
        t0 = new Date();
        BufferedImage img = ImageIO.read(url);
        t1 = new Date();
        return t1.getTime() - t0.getTime();
    }

    public static long getText(String address) throws MalformedURLException, IOException {
        url = new URL(address);
        t0 = new Date();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        while (in.readLine() != null) {
        }
        in.close();
        t1 = new Date();
        return t1.getTime() - t0.getTime();
    }

    public static long getData(String address) throws MalformedURLException, IOException {
        url = new URL(address);
        t0 = new Date();
        InputStreamReader in = new InputStreamReader(url.openStream());
        while (in.read() >= 0) {
        }
        in.close();
        t1 = new Date();
        return t1.getTime() - t0.getTime();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: PERFORMANCE count url");
            System.out.println("This program reads HTML data or images and measures");
            System.out.println("the time required to read both.");
            System.out.println("COUNT defines the length of the loop of repeated reading.");
            System.out.println("URL is the URL to be read.");
            System.exit(0);
        }
        int c = Integer.parseInt(args[0]);
        String u = args[1];
        long t = 0L;
        long t_sum = 0L;
        long t_max = 0L;
        long t_min = 9999999L;
        for (int ii = 0; ii < c; ++ii) {
            t = Performance.getData(u);
            t_sum += t;
            if (t > t_max) {
                t_max = t;
            }
            if (t < t_min) {
                t_min = t;
            }
            System.out.print(".");
        }
        System.out.println(" done");
        System.out.println("count " + c);
        System.out.println("Result:");
        System.out.println("  ave   " + t_sum / (long)c);
        System.out.println("  min   " + t_min);
        System.out.println("  max   " + t_max);
    }
}

