/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gridmap.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class PerformanceTester {
    public static String version = "Version 1.0.0, 23.1.2008";
    private int[] scales = new int[]{5270000, 1823000, 618300, 22750, 7870};
    private int mapsize = 1000;
    private int dpi = 82;
    private int xmin = 3614140;
    private int ymin = 2248070;
    private int xmax = 4651377;
    private int ymax = 2763062;
    private String layers = "administration landcover road cities parking";
    private String out = "/home/hk/maptest/";
    private int counter = 0;

    public int[] getScales() {
        return this.scales;
    }

    private int extentSize(int scale) {
        double screenSize = (double)this.mapsize * 0.0254 / (double)this.dpi;
        return (int)(screenSize * (double)scale);
    }

    private int[] getUpperLeftCorner(int scale) {
        int[] result = new int[2];
        int extSize = this.extentSize(scale);
        int rangex = this.xmax - this.xmin - extSize;
        int rangey = this.ymax - this.ymin - extSize;
        result[0] = (int)((double)this.xmin + Math.random() * (double)rangex);
        result[1] = (int)((double)this.ymin + Math.random() * (double)rangey);
        return result;
    }

    private String getExtent(int scale) {
        int[] corner = this.getUpperLeftCorner(scale);
        String result = corner[0] + " " + corner[1] + " " + (corner[0] + this.extentSize(scale)) + " " + (corner[1] + this.extentSize(scale));
        return result;
    }

    private String getMapfile(int scale) {
        if (scale <= 6000) {
            return "/var/wwwdata/gpsserver/ticom_12.map";
        }
        if (scale <= 12000) {
            return "/var/wwwdata/gpsserver/ticom_11.map";
        }
        if (scale <= 25000) {
            return "/var/wwwdata/gpsserver/ticom_10.map";
        }
        if (scale <= 50000) {
            return "/var/wwwdata/gpsserver/ticom_09.map";
        }
        if (scale <= 100000) {
            return "/var/wwwdata/gpsserver/ticom_08.map";
        }
        if (scale <= 200000) {
            return "/var/wwwdata/gpsserver/ticom_07.map";
        }
        if (scale <= 400000) {
            return "/var/wwwdata/gpsserver/ticom_06.map";
        }
        if (scale <= 1000000) {
            return "/var/wwwdata/gpsserver/ticom_05.map";
        }
        if (scale <= 2000000) {
            return "/var/wwwdata/gpsserver/ticom_04.map";
        }
        if (scale <= 3000000) {
            return "/var/wwwdata/gpsserver/ticom_03.map";
        }
        if (scale <= 10000000) {
            return "/var/wwwdata/gpsserver/ticom_02.map";
        }
        return "/var/wwwdata/gpsserver/ticom_01.map";
    }

    public String createCommand(int scale) {
        StringBuffer sb = new StringBuffer("/usr/bin/shp2img");
        sb.append(" -m " + this.getMapfile(scale));
        sb.append(" -o " + this.out + "image" + scale + "_" + this.counter + ".jpg");
        sb.append(" -l \"" + this.layers + "\"");
        sb.append(" -e " + this.getExtent(scale));
        sb.append(" -s " + this.mapsize + " " + this.mapsize);
        sb.append(" -map_debug 3");
        ++this.counter;
        return sb.toString();
    }

    protected void executeCommand(String cmd) {
        try {
            String ln;
            System.out.println(cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((ln = in.readLine()) != null) {
                System.out.println("..." + ln);
            }
            System.out.println("---------------");
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public long executeRead(int scale, String url) {
        StringBuffer urls = new StringBuffer(url);
        urls.append("?mode=map&map=" + this.getMapfile(scale));
        urls.append("&layers=" + this.layers);
        urls.append("&mapext=" + this.getExtent(scale));
        long result = -1L;
        result = this.readHttp(urls.toString());
        return result;
    }

    private long getData(String address) throws MalformedURLException, IOException {
        URL url = new URL(address);
        Date t0 = new Date();
        InputStream is = url.openStream();
        InputStreamReader in = new InputStreamReader(is);
        while (in.read() >= 0) {
        }
        in.close();
        Date t1 = new Date();
        return t1.getTime() - t0.getTime();
    }

    private long readHttp(String address) {
        return 0L;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: PERFORMANCE layer count scale");
            System.out.println("       PERFORMANCE map count scale url");
            System.out.println("       PERFORMANCE data count url");
            System.out.println("This program reads HTML data or images and measures");
            System.out.println("the time required to read both.");
            System.out.println("COUNT defines the length of the loop of repeated reading.");
            System.out.println("URL is the URL to be read.");
            System.exit(0);
        }
        String type = args[0];
        int count = Integer.parseInt(args[1]);
        PerformanceTester pt = new PerformanceTester();
        int scale = 0;
        if ("map".equalsIgnoreCase(type)) {
            scale = Integer.parseInt(args[2]);
            String u = args[3];
            long t = 0L;
            long t_sum = 0L;
            long t_max = 0L;
            long t_min = 9999999L;
            for (int ii = 0; ii < count; ++ii) {
                t = pt.executeRead(scale, u);
                t_sum += t;
                if (t > t_max) {
                    t_max = t;
                }
                if (t < t_min) {
                    t_min = t;
                }
                System.out.print(".");
            }
            System.out.println(" done");
            System.out.println("count " + count);
            System.out.println("Result:");
            System.out.println("  ave   " + t_sum / (long)count);
            System.out.println("  min   " + t_min);
            System.out.println("  max   " + t_max);
        } else if ("layer".equalsIgnoreCase(type)) {
            System.out.println("echo \"SCALE (1:" + scale + ")\" > /home/hk/maptest/out.txt");
            for (int ii = 0; ii < 50; ++ii) {
                System.out.println(pt.createCommand(scale) + " 2>> /home/hk/maptest/out.txt");
            }
            System.out.println("# =====================");
        } else {
            System.out.println("not yet supported");
        }
    }
}

