/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import at.grid.data.Box2D;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.Point;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;

public class BasicGeometry {
    public static final int UNKNOWN = 0;
    public static final int POINT = 1;
    public static final int LINE = 2;
    public static final int POLYGON = 3;
    public static final int ARROW = 4;
    public static final int CIRCLE = 5;
    public static final int CLOUD = 6;
    public static final int STAR = 7;
    public static final int POLYGONFILL = 8;
    public static final int STATUS_ON = 1;
    public static final int STATUS_OFF = 2;
    public static final int STATUS_SEL = 3;
    ArrayList<Point> points;
    double snapdistance = 1.0;
    public int type;
    private Object reference;
    private String label = null;
    private Point labelpoint = null;
    private Point labeloffset = null;
    int status;
    boolean selectable;
    private long id;
    private static long nextid = 0L;
    private boolean showverteces;
    private float fill = 0.0f;
    private float sizeFactor = 1.0f;
    private boolean moveIconWithLabel = false;
    private Point iconPositionDelta = new Point(0.0, 0.0);

    public BasicGeometry(int type, boolean selectable) {
        this.points = new ArrayList();
        this.type = type;
        this.status = 1;
        this.selectable = selectable;
        this.setNextId();
    }

    public BasicGeometry(int type) {
        this(type, true);
    }

    public BasicGeometry(BasicGeometry geo, boolean clone) {
        this.type = geo.getType();
        this.selectable = geo.isSelectable();
        this.status = geo.getStatus();
        this.label = geo.getLabel();
        this.points = new ArrayList();
        for (Point p : geo.points) {
            this.points.add(new Point(p.x, p.y));
        }
        this.sizeFactor = geo.getSizeFactor();
        if (!clone) {
            this.setNextId();
        } else {
            this.id = geo.getId();
        }
        this.moveIconWithLabel = geo.moveIconWithLabel;
        this.labeloffset = geo.labeloffset;
        this.labelpoint = geo.labelpoint;
    }

    public BasicGeometry(Geometry g, int type) {
        this(type);
        for (Coordinate c : g.getCoordinates()) {
            this.points.add(new Point(c.x, c.y));
        }
    }

    public BasicGeometry(ArrayList<Point> points, int type) {
        this(type);
        this.points = points;
    }

    public final synchronized void setNextId() {
        this.id = nextid++;
    }

    public void setId(long newId) {
        this.id = newId;
    }

    public long getId() {
        return this.id;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isOfType(int checktype) {
        return this.type == checktype;
    }

    public boolean isPoint() {
        return this.points.size() == 1;
    }

    public int getType() {
        return this.type;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasLabel() {
        return this.label != null && !"".equals(this.label);
    }

    public Point getLabelpoint() {
        return this.labelpoint;
    }

    public void setLabelpoint(Point labelpoint) {
        this.labelpoint = labelpoint;
    }

    public boolean hasLabelpoint() {
        return this.labelpoint != null;
    }

    public void setLabelOffset(double dx, double dy) {
        this.labeloffset = new Point(dx, dy);
    }

    public boolean hasLabelOffset() {
        return this.labeloffset != null;
    }

    public Point getLabelOffset() {
        return this.labeloffset;
    }

    public void setMoveIconWithLabel(boolean setting) {
        this.moveIconWithLabel = setting;
    }

    public boolean doMoveIconWithLabel() {
        return this.moveIconWithLabel;
    }

    public boolean isSelected() {
        return this.getStatus() == 3;
    }

    public void setSelected() {
        this.setStatus(3);
    }

    public boolean setSelected(boolean sel) {
        int s = this.getStatus();
        boolean changed = s == 3 && !sel || s != 3 && sel;
        this.setStatus(sel ? 3 : 1);
        return changed;
    }

    public boolean isOff() {
        return this.getStatus() == 2;
    }

    public void setShowVerteces(boolean show) {
        this.showverteces = show;
    }

    public boolean doShowVerteces() {
        return this.showverteces;
    }

    public float getFill() {
        return this.fill;
    }

    public void setFill(float fill) {
        this.fill = fill;
    }

    public float getSizeFactor() {
        return this.sizeFactor;
    }

    public void setSizeFactor(float sizeFactor) {
        this.sizeFactor = sizeFactor;
    }

    public void updatePoints(BasicGeometry g) {
        this.points = g.getPoints();
    }

    public Box2D getBox() {
        double xmin = Double.NaN;
        double xmax = Double.NaN;
        double ymin = Double.NaN;
        double ymax = Double.NaN;
        for (Point pt : this.points) {
            if (Double.isNaN(xmin) || xmin > pt.x) {
                xmin = pt.x;
            }
            if (Double.isNaN(xmax) || xmax < pt.x) {
                xmax = pt.x;
            }
            if (Double.isNaN(ymin) || ymin > pt.y) {
                ymin = pt.y;
            }
            if (!Double.isNaN(ymax) && !(ymax < pt.y)) continue;
            ymax = pt.y;
        }
        return new Box2D(xmin, ymax, xmax, ymin);
    }

    public Geometry toJTS() {
        GeometryFactory fac = new GeometryFactory();
        LineString newgeo = null;
        if (this.getPoints().isEmpty()) {
            return null;
        }
        int counter = 0;
        int countPoints = this.size();
        if (this.isOfType(3) || this.isOfType(8)) {
            ++countPoints;
        }
        Coordinate[] coordinates = new Coordinate[countPoints];
        for (Point p : this.getPoints()) {
            coordinates[counter] = new Coordinate(p.x, p.y);
            ++counter;
        }
        if (this.isOfType(1)) {
            newgeo = fac.createPoint(new Coordinate(this.points.get((int)0).x, this.points.get((int)0).y));
        } else if (this.isOfType(2) || this.isOfType(4) || this.isOfType(6) || this.isOfType(7) || this.isOfType(5)) {
            newgeo = fac.createLineString(coordinates);
        } else if (this.isOfType(3) || this.isOfType(8)) {
            coordinates[coordinates.length - 1] = new Coordinate(coordinates[0].x, coordinates[0].y);
            newgeo = fac.createPolygon(fac.createLinearRing(coordinates), null);
        }
        return newgeo;
    }

    public void setReference(Object o) {
        this.reference = o;
    }

    public Object getReference() {
        return this.reference;
    }

    public BasicGeometry move(double dx, double dy) {
        for (Point p : this.points) {
            p.translate(dx, dy);
        }
        return this;
    }

    public BasicGeometry add(Point newpoint) {
        return this.add(newpoint, false);
    }

    public BasicGeometry add(Point newpoint, boolean snap) {
        Point addpoint = new Point(newpoint);
        for (Point p : this.points) {
            if (!(p.distance(addpoint) < this.snapdistance)) continue;
            addpoint.x = p.x;
            addpoint.y = p.y;
        }
        if (this.type == 1) {
            this.points.clear();
        }
        this.points.add(addpoint);
        return this;
    }

    public BasicGeometry add(double x, double y) {
        this.add(new Point(x, y));
        return this;
    }

    public BasicGeometry add(String newpoint) {
        String[] xy = null;
        if (newpoint.contains(" ")) {
            xy = newpoint.split(" ");
        } else if (newpoint.contains(",")) {
            xy = newpoint.split(",");
        }
        if (xy != null) {
            this.add(Double.parseDouble(xy[0]), Double.parseDouble(xy[1]));
        }
        return this;
    }

    public Point getCenterPoint() {
        double xmin = Double.NaN;
        double xmax = Double.NaN;
        double ymin = Double.NaN;
        double ymax = Double.NaN;
        for (Point p : this.points) {
            if (Double.isNaN(xmin) || xmin > p.x) {
                xmin = p.x;
            }
            if (Double.isNaN(xmax) || xmax < p.x) {
                xmax = p.x;
            }
            if (Double.isNaN(ymin) || ymin > p.y) {
                ymin = p.y;
            }
            if (!Double.isNaN(ymax) && !(ymax < p.y)) continue;
            ymax = p.y;
        }
        return new Point((xmax + xmin) / 2.0, (ymax + ymin) / 2.0);
    }

    public int size() {
        return this.points.size();
    }

    public void clear() {
        this.points.clear();
        this.label = null;
    }

    public void removeLast() {
        if (this.points.size() > 0) {
            this.points.remove(this.points.size() - 1);
        }
    }

    public void setSnapdistance(double snapdistance) {
        this.snapdistance = snapdistance;
    }

    public Point getPoint() {
        if (this.size() == 0) {
            return null;
        }
        return this.points.get(0);
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public double getLength() {
        if (this.points.size() > 1) {
            return this.toJTS().getLength();
        }
        return 0.0;
    }

    public String toWKT() {
        return this.toWKT(null);
    }

    public String toWKT(GridGeometry geometry) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        ArrayList<Point> coords = this.getPoints();
        if (this.type == 1) {
            sb.append("POINT");
            if (this.size() > 0) {
                sb.append("(").append(coords.get((int)0).x).append(" ").append(coords.get((int)0).y).append(")");
            } else {
                sb.append(" EMPTY");
            }
        } else if (this.type == 2 || this.type == 4 || this.type == 5 || this.type == 7 || this.type == 6) {
            sb.append("LINESTRING");
            if (this.size() > 0) {
                sb.append("(");
                for (Point p : coords) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(p.x).append(" ").append(p.y);
                    first = false;
                }
                sb.append(")");
            } else {
                sb.append(" EMPTY");
            }
        } else if (this.type == 3 || this.type == 8) {
            sb.append("POLYGON");
            if (this.size() > 0) {
                sb.append("((");
                for (Point p : coords) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(p.x).append(" ").append(p.y);
                    first = false;
                }
                sb.append(",");
                sb.append(coords.get((int)0).x).append(" ").append(coords.get((int)0).y);
                sb.append("))");
            } else {
                sb.append(" EMPTY");
            }
        }
        return sb.toString();
    }

    public static BasicGeometry fromWKT(String wkt) {
        BasicGeometry g = new BasicGeometry(1);
        BasicGeometry.fromWKT(g, wkt);
        return g;
    }

    public static BasicGeometry fromWKT(BasicGeometry g, String wkt) {
        if ("null".equals(wkt) || wkt == null) {
            g.add(0.0, 0.0);
            return g;
        }
        if (wkt.toLowerCase().trim().startsWith("linestring")) {
            g.setType(2);
        } else if (wkt.toLowerCase().trim().startsWith("polygon")) {
            g.setType(3);
        }
        int idx1 = wkt.lastIndexOf("(") + 1;
        int idx2 = wkt.indexOf(")");
        if (idx1 == 0 || idx2 < 0) {
            throw new IllegalArgumentException("Illegal WKT, format error");
        }
        String coordinates = wkt.substring(idx1, idx2);
        for (String coords : coordinates.split(",")) {
            g.add(coords);
        }
        return g;
    }

    public BasicGeometry transform(int imgheight, GridGeometry geo) {
        BasicGeometry g;
        if (geo != null) {
            if (imgheight == 0) {
                imgheight = geo.getHeight();
            }
            int geoheight = geo.getHeight();
            ArrayList<Point> newpoints = new ArrayList<Point>();
            for (Point p : this.points) {
                double cy = geo.getCorner().y;
                double sy = geo.getCellSizeY();
                double y = cy + ((double)imgheight - p.y) * sy;
                newpoints.add(new Point(geo.getCorner().x + p.x * geo.getCellSizeX(), geo.getCorner().y + ((double)imgheight - p.y) * geo.getCellSizeY()));
            }
            g = new BasicGeometry(newpoints, this.type);
        } else {
            g = new BasicGeometry(this, true);
        }
        this.transform(g, imgheight, geo);
        return g;
    }

    public void transform(BasicGeometry g, int imgheight, GridGeometry geo) {
        if (geo != null) {
            g.id = this.getId();
            g.setStatus(this.getStatus());
            g.setSelectable(this.isSelectable());
            g.setLabel(this.getLabel());
        }
    }

    public BasicGeometry retransform(int imgheight, GridGeometry geo) {
        BasicGeometry g = new BasicGeometry(this, true);
        this.retransform(g, imgheight, geo);
        return g;
    }

    public void retransform(BasicGeometry g, int imgheight, GridGeometry geo) {
        if (geo != null) {
            imgheight = geo.getHeight();
            ArrayList<Point> newpoints = new ArrayList<Point>();
            for (Point p : this.points) {
                newpoints.add(new Point((p.x - geo.getCorner().x) / geo.getCellSizeX(), (double)imgheight - (p.y - geo.getCorner().y) / geo.getCellSizeY()));
            }
            g.points = newpoints;
            if (this.labelpoint != null) {
                g.labelpoint = new Point((this.labelpoint.x - geo.getCorner().x) / geo.getCellSizeX(), (double)imgheight - (this.labelpoint.y - geo.getCorner().y) / geo.getCellSizeY());
            }
        }
    }

    public Point getFirstPoint() {
        return this.getPoint();
    }

    public Point getLastPoint() {
        if (this.points.isEmpty()) {
            return null;
        }
        return this.points.get(this.points.size() - 1);
    }

    public Point getPointOnLine(double dist) {
        return this.getPointOnLine(dist, 0.0);
    }

    public Point getPointOnLine(double dist, double offset) {
        double distcount = 0.0;
        Point lastpoint = null;
        int counter = 0;
        for (Point p : this.points) {
            double lastdistance;
            if (lastpoint != null && (dist <= (distcount += (lastdistance = p.distance(lastpoint))) || counter == this.points.size() - 1)) {
                double dx = lastpoint.x - p.x;
                double dy = lastpoint.y - p.y;
                Point result = new Point(p);
                result.translate((distcount - dist) * dx / lastdistance, (distcount - dist) * dy / lastdistance);
                if (offset > 0.0) {
                    result.translate(-offset * dy / lastdistance, offset * dx / lastdistance);
                }
                return result;
            }
            lastpoint = new Point(p.x, p.y);
            ++counter;
        }
        return null;
    }

    public String toString() {
        String id = " [" + this.getId() + "]";
        switch (this.type) {
            case 2: {
                return "LINESTRING" + id + ", " + this.points.size() + " points";
            }
            case 5: {
                return "CIRCLE" + id + ", " + this.points.size() + " points";
            }
            case 6: {
                return "CLOUD" + id + ", " + this.points.size() + " points";
            }
            case 7: {
                return "STAR" + id + ", " + this.points.size() + " points";
            }
            case 4: {
                return "ARROW" + id + ", " + this.points.size() + " points";
            }
            case 3: {
                return "POLYGON" + id + ", " + this.points.size() + " points";
            }
            case 8: {
                return "POLYGONFILL" + id + ", " + this.points.size() + " points";
            }
            case 1: {
                return "POINT" + id + " " + this.getPoint().toString();
            }
        }
        return "undefined";
    }

    public void rotate(double x, double y, double angle) {
        for (Point p : this.points) {
            double dx = p.x - x;
            double dy = p.y - y;
            double r = Math.sqrt(dx * dx + dy * dy);
            double alpha = Math.atan2(dx, dy);
            p.setX(x + r * Math.cos(alpha + angle));
            p.setY(y + r * Math.sin(alpha + angle));
        }
    }

    public void translate(double dx, double dy) {
        for (Point p : this.points) {
            p.setX(p.getX() + dx);
            p.setY(p.getY() + dy);
        }
    }

    public BasicGeometry scale(double factor) {
        for (Point p : this.points) {
            p.setX(p.getX() * factor);
            p.setY(p.getY() * factor);
        }
        return this;
    }
}

