/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileChooser
extends JPanel {
    public static int APPROVE_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    public static int DIRECTORIES_ONLY = 1;
    public static int FILES_ONLY = 0;
    public static int FILES_AND_DIRECTORIES = 2;
    private File currentFolder;
    private int mode = FILES_AND_DIRECTORIES;
    private String dialogtitle = "Dateiauswahl";
    private JButton btnDisk;
    private JComboBox fldDisk;
    private JTextField fldSelect;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane scrollpane;

    public FileChooser() {
        this(new File(""), FILES_AND_DIRECTORIES);
    }

    public FileChooser(File initialFolder) {
        this(initialFolder, FILES_AND_DIRECTORIES);
    }

    public FileChooser(int mode) {
        this(new File(""), mode);
    }

    public FileChooser(File initialFolder, int mode) {
        File[] roots;
        String initialFolderName = initialFolder.getAbsolutePath();
        this.currentFolder = new File(initialFolderName);
        this.initComponents();
        for (File f : roots = File.listRoots()) {
            this.fldDisk.addItem(f.getAbsolutePath());
        }
        File baseFolder = roots[0];
        JTree tree = new JTree(this.addNodes(null, baseFolder, initialFolder));
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                System.out.println("You selected " + node);
            }
        });
        this.scrollpane.getViewport().add(tree);
        this.add("Center", this.scrollpane);
        this.currentFolder = new File(initialFolderName);
        this.mode = mode;
        if (mode == DIRECTORIES_ONLY) {
            this.fldSelect.setVisible(false);
            this.jLabel2.setVisible(false);
        }
    }

    DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, File currentDir, File selectedDir) {
        String absPath = currentDir.getAbsolutePath();
        File dir = new File(absPath);
        String curPath = dir.getPath();
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(curPath);
        if (curTop != null) {
            curTop.add(curDir);
        }
        Vector<String> ol = new Vector<String>();
        String[] tmp = dir.list();
        for (int i = 0; i < tmp.length; ++i) {
            ol.addElement(tmp[i]);
        }
        Collections.sort(ol, String.CASE_INSENSITIVE_ORDER);
        Vector<String> files = new Vector<String>();
        for (int i = 0; i < ol.size(); ++i) {
            String thisObject = (String)ol.elementAt(i);
            String newPath = curPath.equals(".") ? thisObject : curPath + File.separator + thisObject;
            File f = new File(newPath);
            if (f.isDirectory()) {
                this.addNodes(curDir, f, selectedDir);
                continue;
            }
            files.addElement(thisObject);
        }
        for (int fnum = 0; fnum < files.size(); ++fnum) {
            curDir.add(new DefaultMutableTreeNode(files.elementAt(fnum)));
        }
        return curDir;
    }

    public File getSelection() {
        if (this.mode == DIRECTORIES_ONLY) {
            return this.currentFolder;
        }
        if ("".equals(this.fldSelect.getText())) {
            if (this.mode == FILES_AND_DIRECTORIES) {
                return this.currentFolder;
            }
            return null;
        }
        File f = new File(this.currentFolder, this.fldSelect.getText());
        return f;
    }

    public File getSelectedFile() {
        return this.getSelection();
    }

    public void setDialogTitle(String t) {
        this.dialogtitle = t;
    }

    public void setFileSelectionMode(int type) {
        this.mode = type;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.fldSelect.requestFocus();
    }

    public int showDialog(Component parent, String okbutton) {
        JFrame frame = new JFrame("FileTree");
        frame.setForeground(Color.black);
        frame.setBackground(Color.lightGray);
        Container cp = frame.getContentPane();
        cp.add(this);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
        return 0;
    }

    public int showSaveDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    public int showOpenDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    public void setCurrentDirectory(File f) {
        String path = f.getAbsolutePath();
        if (path.endsWith("/.") || path.endsWith("\\.")) {
            path = path.substring(0, path.length() - 2);
        }
        this.currentFolder = new File(path);
    }

    public File getCurrentDirectory() {
        return this.currentFolder;
    }

    public void setSelectedFile(File f) {
        if (f.isDirectory()) {
            this.setCurrentDirectory(f);
        } else if (f.getParentFile().exists()) {
            this.setCurrentDirectory(f.getParentFile());
            this.fldSelect.setText(f.getName());
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.btnDisk = new JButton();
        this.jLabel2 = new JLabel();
        this.fldSelect = new JTextField();
        this.fldDisk = new JComboBox();
        this.scrollpane = new JScrollPane();
        this.jLabel1.setText("Laufwerk");
        ResourceBundle bundle = ResourceBundle.getBundle("at/grid/gui/Bundle");
        this.btnDisk.setLabel(bundle.getString("FileChooser.btnDisk.label"));
        this.btnDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooser.this.btnDiskActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Datei");
        this.fldSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooser.this.fldSelectActionPerformed(evt);
            }
        });
        this.fldDisk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FileChooser.this.fldDiskItemStateChanged(evt);
            }
        });
        this.fldDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooser.this.fldDiskActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollpane, -1, 553, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldDisk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDisk)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldSelect, -1, 524, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fldDisk, -2, -1, -2).addComponent(this.btnDisk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollpane, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldSelect, -2, 22, -2).addComponent(this.jLabel2)).addContainerGap()));
    }

    private void btnDiskActionPerformed(ActionEvent evt) {
    }

    private void fldSelectActionPerformed(ActionEvent evt) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getName().indexOf(name) >= 0;
            }
        };
    }

    private void fldDiskItemStateChanged(ItemEvent evt) {
    }

    private void fldDiskActionPerformed(ActionEvent evt) {
    }
}

