/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import at.grid.gui.SimpleGeometry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;

public class GeometryDisplay {
    public static final int NONE = 0;
    public static final int X = 1;
    public static final int PLUS = 2;
    public static final int RECT = 3;
    public static final int CIRCLE = 4;
    public static final int LINE_SOLID = 5;
    public static final int LINE_DASH = 6;
    public static final int LINE_DOT = 7;
    public Image pointmarker = null;
    public int size = 10;
    public float fontsize = 12.0f;
    public int linewidth = 5;
    public Color color = Color.RED;
    public Color labelcolor = new Color(51, 105, 255);
    public Color labeltextcolor = Color.WHITE;
    public Color fillcolor = Color.RED;
    public int type = 4;
    public int linetype = 5;
    public boolean visible = true;
    public boolean labelwithbackground = true;
    private SimpleGeometry geom = null;

    public GeometryDisplay(int type) {
        this.type = type;
    }

    public GeometryDisplay(int type, SimpleGeometry g) {
        this.type = type;
        this.geom = g;
    }

    public GeometryDisplay setDisplay(GeometryDisplay disp) {
        this.pointmarker = disp.pointmarker;
        this.size = disp.size;
        this.fontsize = disp.fontsize;
        this.linewidth = disp.linewidth;
        this.color = new Color(disp.color.getRGB());
        this.labelcolor = new Color(disp.labelcolor.getRGB());
        this.labeltextcolor = new Color(disp.labeltextcolor.getRGB());
        this.fillcolor = new Color(disp.fillcolor.getRGB());
        this.type = disp.type;
        this.linetype = disp.linetype;
        this.visible = disp.visible;
        this.labelwithbackground = disp.labelwithbackground;
        return this;
    }

    public GeometryDisplay setDisplay(int type, int size, Color c) {
        return this.setDisplay(type, size, c, false);
    }

    public GeometryDisplay setDisplay(int type, int size, Color c, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setDisplay(type, size, c);
            this.geom.getDisplayStandard().setDisplay(type, size, c);
            this.geom.getDisplayOff().setDisplay(type, size, c);
        } else {
            this.size = size;
            this.type = type;
            this.color = c;
        }
        return this;
    }

    public GeometryDisplay setType(int t) {
        this.type = t;
        return this;
    }

    public GeometryDisplay setColor(Color c) {
        return this.setColor(c, false);
    }

    public GeometryDisplay setColor(Color c, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setColor(c);
            this.geom.getDisplayStandard().setColor(c);
            this.geom.getDisplayOff().setColor(c);
        } else {
            this.color = c;
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public GeometryDisplay setColor(Integer cc, boolean all) {
        if (cc == null) {
            return this;
        }
        Color c = new Color(cc);
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setColor(c);
            this.geom.getDisplayStandard().setColor(c);
            this.geom.getDisplayOff().setColor(c);
        } else {
            this.color = c;
        }
        return this;
    }

    public GeometryDisplay setLabelWithBackground(boolean f) {
        return this.setLabelWithBackground(f, false);
    }

    public GeometryDisplay setLabelWithBackground(boolean f, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setLabelWithBackground(f);
            this.geom.getDisplayStandard().setLabelWithBackground(f);
            this.geom.getDisplayOff().setLabelWithBackground(f);
        } else {
            this.labelwithbackground = f;
        }
        return this;
    }

    public boolean getLabelWithBackground() {
        return this.labelwithbackground;
    }

    public GeometryDisplay setLabelColor(Color c) {
        return this.setLabelColor(c, false);
    }

    public GeometryDisplay setLabelColor(Color c, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setLabelColor(c);
            this.geom.getDisplayStandard().setLabelColor(c);
            this.geom.getDisplayOff().setLabelColor(c);
        } else {
            this.labelcolor = c;
        }
        return this;
    }

    public GeometryDisplay setLabelTextColor(Color c) {
        return this.setLabelTextColor(c, false);
    }

    public GeometryDisplay setLabelTextColor(Color c, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setLabelTextColor(c);
            this.geom.getDisplayStandard().setLabelTextColor(c);
            this.geom.getDisplayOff().setLabelTextColor(c);
        } else {
            this.labeltextcolor = c;
        }
        return this;
    }

    public GeometryDisplay setLinewidth(int w) {
        return this.setLinewidth(w, false);
    }

    public GeometryDisplay setLinewidth(Integer w, boolean all) {
        if (w == null) {
            return this;
        }
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setLinewidth(w);
            this.geom.getDisplayStandard().setLinewidth(w);
            this.geom.getDisplayOff().setLinewidth(w);
        } else {
            this.linewidth = w;
        }
        return this;
    }

    public int getLinewidth() {
        return this.linewidth;
    }

    public void setLinetype(int linetype) {
        this.setLinetype(linetype, false);
    }

    public void setLinetype(int linetype, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setLinewidth(linetype);
            this.geom.getDisplayStandard().setLinewidth(linetype);
            this.geom.getDisplayOff().setLinewidth(linetype);
        } else {
            this.linetype = linetype;
        }
    }

    public GeometryDisplay setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public void setFontSize(float s) {
        this.setFontSize(s, false);
    }

    public void setFontSize(float s, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setFontSize(s);
            this.geom.getDisplayStandard().setFontSize(s);
            this.geom.getDisplayOff().setFontSize(s);
        } else {
            this.fontsize = s;
        }
    }

    public GeometryDisplay setPointmarker(Image i) {
        return this.setPointmarker(i, false);
    }

    public GeometryDisplay setPointmarker(Image i, boolean all) {
        if (all && this.geom != null) {
            this.geom.getDisplaySel().setPointmarker(i);
            this.geom.getDisplayStandard().setPointmarker(i);
            this.geom.getDisplayOff().setPointmarker(i);
        } else {
            this.pointmarker = i;
        }
        return this;
    }

    public Image getPointmarker() {
        return this.pointmarker;
    }

    public Stroke getStoke() {
        if (this.linetype == 7) {
            return new BasicStroke(this.linewidth, 2, 0, 10.0f, new float[]{3.0f, 6.0f}, 0.0f);
        }
        if (this.linetype == 6) {
            return new BasicStroke(this.linewidth, 2, 0, 10.0f, new float[]{15.0f, 10.0f}, 0.0f);
        }
        return new BasicStroke(this.linewidth);
    }

    public static GeometryDisplay createCircle(int size, Color c) {
        GeometryDisplay d = new GeometryDisplay(4);
        d.setDisplay(4, size, c);
        return d;
    }

    public static GeometryDisplay createPlus(int size, Color c) {
        GeometryDisplay d = new GeometryDisplay(2);
        d.setDisplay(2, size, c);
        return d;
    }

    public static GeometryDisplay createX(int size, Color c) {
        GeometryDisplay d = new GeometryDisplay(1);
        d.setDisplay(1, size, c);
        return d;
    }

    public void setDashedLine(int i) {
        this.setLinewidth(i);
        this.setLinetype(6);
    }

    public void setSolidLine(int i) {
        this.setLinewidth(i);
        this.setLinetype(5);
    }

    public void setDottedLine(int i) {
        this.setLinewidth(i);
        this.setLinetype(7);
    }
}

