/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiPanel
extends JPanel {
    DefaultListModel<String> model = new DefaultListModel();
    ArrayList<String> panelTitles = new ArrayList();
    HashMap<String, JPanel> panels = new HashMap();
    Dimension dialogDim = new Dimension(0, 0);
    boolean cancelled = false;
    JDialog dlg;
    private JButton btnCancel;
    private JButton btnNext;
    private JButton btnOk;
    private JButton btnPrevious;
    private JPanel jPanel1;
    private JList list;
    private JScrollPane listPane;
    private JPanel main;

    public MultiPanel(JDialog dlg) {
        this.initComponents();
        this.dlg = dlg;
    }

    public void initialise(float fontSize) {
        this.model.clear();
        for (String t : this.panelTitles) {
            this.model.addElement(t);
        }
        this.list.setModel(this.model);
        if (this.panelTitles.size() > 0) {
            this.list.setSelectedIndex(0);
        }
        this.list.setFont(this.list.getFont().deriveFont(fontSize));
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void addPanel(String title, JPanel panel) {
        this.panelTitles.add(title);
        this.panels.put(title, panel);
        this.main.add(panel);
        panel.setVisible(false);
    }

    public HashMap<String, JPanel> getPanelMap() {
        return this.panels;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
    }

    private void initComponents() {
        this.listPane = new JScrollPane();
        this.list = new JList();
        this.main = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new BorderLayout());
        this.list.setModel(this.model);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MultiPanel.this.listValueChanged(evt);
            }
        });
        this.listPane.setViewportView(this.list);
        this.add((Component)this.listPane, "West");
        this.main.setLayout(new BorderLayout());
        this.add((Component)this.main, "Center");
        this.btnPrevious.setText(" < ");
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiPanel.this.btnPreviousActionPerformed(evt);
            }
        });
        this.btnNext.setText(" > ");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiPanel.this.btnNextActionPerformed(evt);
            }
        });
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiPanel.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiPanel.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 422, Short.MAX_VALUE).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPrevious, -2, 36, -2).addComponent(this.btnNext, -2, 36, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "South");
    }

    private void listValueChanged(ListSelectionEvent evt) {
        String panelTitle = (String)this.list.getSelectedValue();
        JPanel p = this.panels.get(panelTitle);
        for (JPanel pa : this.panels.values()) {
            pa.setVisible(false);
        }
        p.setVisible(true);
        this.btnPrevious.setEnabled(this.list.getSelectedIndex() > 0);
        this.btnNext.setEnabled(this.list.getSelectedIndex() < this.panelTitles.size() - 1);
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndex() > 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndex() < this.panelTitles.size() - 1) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dlg.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.dlg.dispose();
    }
}

