/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

public class Point {
    public double x;
    public double y;
    public double z;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(Point p) {
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public Point() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point(java.awt.Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double distance(Point p) {
        double dx = p.getX() - this.getX();
        double dy = p.getY() - this.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double heading(Point p) {
        double deg;
        for (deg = 90.0 - Math.toDegrees(Math.atan2(p.y - this.y, p.x - this.x)); deg < 0.0; deg += 360.0) {
        }
        return deg;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public void setLocation(Point p) {
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public Point translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Point translatePolar(double angle, double dist) {
        this.x += Math.cos(Math.toRadians(90.0 - angle)) * dist;
        this.y += Math.sin(Math.toRadians(90.0 - angle)) * dist;
        return this;
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", z=" + this.z;
    }
}

