/*
 * Decompiled with CFR 0.152.
 */
package at.grid.gui;

import at.grid.data.grid.GridGeometry;
import at.grid.gui.BasicGeometry;
import at.grid.gui.GeometryDisplay;
import at.grid.gui.ImagePanelInterface;
import at.grid.gui.Point;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;

public class SimpleGeometry
extends BasicGeometry {
    private GeometryDisplay display = new GeometryDisplay(4, this);
    private GeometryDisplay displaySel = new GeometryDisplay(4, this).setColor(Color.YELLOW);
    private GeometryDisplay displayOff = new GeometryDisplay(4, this).setColor(Color.GRAY);

    public SimpleGeometry(int type, boolean selectable) {
        super(type, selectable);
    }

    public SimpleGeometry(int type) {
        this(type, true);
    }

    public SimpleGeometry(SimpleGeometry geo, boolean clone) {
        super(geo, clone);
        this.setDisplay(geo.getDisplayStandard(), geo.getDisplaySel(), geo.getDisplayOff());
    }

    public SimpleGeometry(Geometry g, int type) {
        this(type);
    }

    public SimpleGeometry(ArrayList<Point> points, int type) {
        this(type);
        this.points = points;
    }

    public GeometryDisplay getDisplay() {
        if (this.status == 2) {
            return this.displayOff;
        }
        if (this.status == 3) {
            return this.displaySel;
        }
        return this.display;
    }

    public GeometryDisplay getDisplayStandard() {
        return this.display;
    }

    public GeometryDisplay getDisplaySel() {
        return this.displaySel;
    }

    public GeometryDisplay getDisplayOff() {
        return this.displayOff;
    }

    public boolean hasPointMarker() {
        return this.getDisplay().pointmarker != null;
    }

    public Image getPointMarker() {
        if (this.status == 2) {
            return this.displayOff.pointmarker == null ? this.display.pointmarker : this.displayOff.pointmarker;
        }
        if (this.status == 3) {
            return this.displaySel.pointmarker == null ? this.display.pointmarker : this.displaySel.pointmarker;
        }
        return this.display.pointmarker;
    }

    public void setPointMarker(Image icon) {
        this.display.setPointmarker(icon);
        this.displaySel.setPointmarker(icon);
        this.displayOff.setPointmarker(icon);
    }

    public void setPointMarker(Image icon, Image icon_off, Image icon_sel) {
        this.display.setPointmarker(icon);
        this.displaySel.setPointmarker(icon_sel);
        this.displayOff.setPointmarker(icon_off);
    }

    public int[][] getAsArray(ImagePanelInterface panel) {
        int[][] result = new int[2][this.points.size()];
        for (int ii = 0; ii < this.points.size(); ++ii) {
            Point p = (Point)this.points.get(ii);
            Point ps = panel.image2screen(p.x, p.y);
            result[0][ii] = (int)ps.x;
            result[1][ii] = (int)ps.y;
        }
        return result;
    }

    public Point getPoint(ImagePanelInterface panel) {
        if (this.size() > 0) {
            Point p = (Point)this.points.get(0);
            Point ps = panel.image2screen(p.x, p.y);
            ps.x = (int)ps.x;
            ps.y = (int)ps.y;
            return ps;
        }
        return null;
    }

    public Point getCenterPoint(ImagePanelInterface panel) {
        Point pc = this.getCenterPoint();
        return panel.image2screen(pc.x, pc.y);
    }

    private void setDisplay(GeometryDisplay displayStandard, GeometryDisplay displaySel, GeometryDisplay displayOff) {
        this.display.setDisplay(displayStandard);
        this.displaySel.setDisplay(displaySel);
        this.displayOff.setDisplay(displayOff);
    }

    @Override
    public SimpleGeometry retransform(int imgheight, GridGeometry geo) {
        SimpleGeometry g = new SimpleGeometry(this, true);
        this.retransform(g, imgheight, geo);
        return g;
    }

    @Override
    public SimpleGeometry transform(int imgheight, GridGeometry geo) {
        SimpleGeometry g;
        if (geo != null) {
            if (imgheight == 0) {
                imgheight = geo.getHeight();
            }
            int geoheight = geo.getHeight();
            ArrayList<Point> newpoints = new ArrayList<Point>();
            for (Point p : this.points) {
                double cy = geo.getCorner().y;
                double sy = geo.getCellSizeY();
                double y = cy + ((double)imgheight - p.y) * sy;
                newpoints.add(new Point(geo.getCorner().x + p.x * geo.getCellSizeX(), geo.getCorner().y + ((double)imgheight - p.y) * geo.getCellSizeY()));
            }
            g = new SimpleGeometry(newpoints, this.type);
        } else {
            g = new SimpleGeometry(this, true);
        }
        this.transform(g, imgheight, geo);
        return g;
    }

    public static SimpleGeometry fromWKT(String wkt) {
        SimpleGeometry g = new SimpleGeometry(1);
        SimpleGeometry.fromWKT(g, wkt);
        return g;
    }

    @Override
    public SimpleGeometry add(String newpoint) {
        super.add(newpoint);
        return this;
    }

    @Override
    public SimpleGeometry add(double x, double y) {
        super.add(x, y);
        return this;
    }

    @Override
    public SimpleGeometry add(Point newpoint, boolean snap) {
        super.add(newpoint, snap);
        return this;
    }

    @Override
    public SimpleGeometry add(Point newpoint) {
        super.add(newpoint);
        return this;
    }

    @Override
    public SimpleGeometry scale(double factor) {
        super.scale(factor);
        return this;
    }
}

