/*
 * Decompiled with CFR 0.152.
 */
package at.grid.license;

import at.grid.license.ShowSystemIdDialog;
import at.grid.util.Util;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.swing.JFrame;

public final class GridLicense {
    private File licensefile;
    private String username = "";
    private String product = "";
    private String modules = "";
    private String date = "";
    private String key = "";
    private String systemid = "";
    private float version = 0.0f;
    private String lastMessage = "";
    private Map<String, String> systemids = GridLicense.getMacAddress();

    public GridLicense() {
        this.systemids.put("hdd0", GridLicense.createHDDId());
    }

    public void load(File f) {
        this.licensefile = f;
        Properties props = new Properties();
        if (f.isFile()) {
            try {
                props.load(new FileReader(f));
                this.set(props);
            }
            catch (IOException ex) {
                Util.log(Level.SEVERE, "Error while loading license file: " + ex.getLocalizedMessage());
            }
        }
    }

    public void save() {
        if (this.licensefile != null) {
            this.save(this.licensefile);
        }
    }

    public boolean save(File f) {
        Properties props = new Properties();
        props.setProperty("username", this.username);
        props.setProperty("product", this.product);
        props.setProperty("modules", this.modules);
        props.setProperty("date", this.date);
        props.setProperty("version", Float.toString(this.version));
        props.setProperty("key", this.key);
        props.setProperty("systemid", this.systemid);
        try {
            f.getParentFile().mkdirs();
            props.store(new FileWriter(f), null);
        }
        catch (IOException ex) {
            Util.log(Level.SEVERE, "Error while saving license file: " + ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void set(Properties props) {
        this.username = props.getProperty("username", "");
        this.modules = props.getProperty("modules", "");
        this.date = props.getProperty("date", "");
        this.version = Float.parseFloat(props.getProperty("version", "0"));
        this.key = props.getProperty("key", "");
        this.product = props.getProperty("product", "");
        this.systemid = props.getProperty("systemid", "");
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String[] getModules() {
        return this.modules.split(",");
    }

    public boolean hasModule(String module) {
        String[] mods;
        if (this.modules == null) {
            return false;
        }
        for (String m : mods = this.modules.split(",")) {
            if (!m.trim().equalsIgnoreCase(module)) continue;
            return true;
        }
        return false;
    }

    public void addModule(String m) {
        this.modules = this.modules.isEmpty() ? m : this.modules + "," + m;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public float getVersoin() {
        return this.version;
    }

    public void setVersion(float v) {
        this.version = v;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("username=").append(this.username).append("\n");
        sb.append("product=").append(this.product).append("\n");
        sb.append("modules=").append(this.modules).append("\n");
        sb.append("version=").append(this.version).append("\n");
        sb.append("date=").append(this.date).append("\n");
        sb.append("systemid=").append(this.systemid).append("\n");
        sb.append("key=").append(this.key);
        return sb.toString();
    }

    public final boolean isValid(float currentversion) {
        if ("".equals(this.username)) {
            this.lastMessage = "No username provided";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if ("".equals(this.modules)) {
            this.lastMessage = "No license modules provided";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if ("".equals(this.product)) {
            this.lastMessage = "No product defined";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if ("".equals(this.key)) {
            this.lastMessage = "No key provided";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if ("".equals(this.systemid)) {
            this.lastMessage = "No System-ID provided";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if (this.version == 0.0f) {
            this.lastMessage = "No version provided";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if (this.version < currentversion) {
            this.lastMessage = "No license for this version";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if (!"0".equals(this.systemid) && !this.getSystemIds().values().contains(this.systemid)) {
            this.lastMessage = "System-ID not found on this computer";
            Util.log(Level.SEVERE, this.lastMessage);
            return false;
        }
        if (this.date != null && !"".equals(this.date)) {
            try {
                Date dt = Util.parseDate(this.date, new String[]{Util.DATE_ISO, Util.DATE_READ, Util.DATE_READ_SHORT}, TimeZone.getTimeZone("GMT+1"));
                if (!dt.after(new Date())) {
                    this.lastMessage = "License expired";
                    Util.log(Level.SEVERE, this.lastMessage);
                    return false;
                }
            }
            catch (Exception e) {
                this.lastMessage = "Invalid license date";
                Util.log(Level.SEVERE, this.lastMessage);
                return false;
            }
        }
        String h = Util.md5(this.username + this.systemid + this.version + this.product + this.modules + this.date);
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int ii = 0; ii < h.length(); ++ii) {
            int ascii = h.charAt(ii) * 3;
            sb.append(ascii);
            sb2.insert(0, ascii);
        }
        String hash = Util.md5(sb.toString()) + Util.md5(sb2.toString()).substring(3);
        if (this.key.equals(hash)) {
            return true;
        }
        this.lastMessage = "Invalid license key";
        Util.log(Level.SEVERE, this.lastMessage);
        return false;
    }

    public Map<String, String> getSystemIds() {
        return this.systemids;
    }

    protected static String createHDDId() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("gridlicense", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            Util.log(Level.WARNING, "Cannot acces HDD id: " + e.getMessage());
        }
        return result.trim();
    }

    protected static Map<String, String> getMacAddress() {
        HashMap<String, String> macs = new HashMap<String, String>();
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                byte[] hardwareAddress = ni.getHardwareAddress();
                String result = "";
                if (hardwareAddress == null) continue;
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    result = result + String.format((i == 0 ? "" : "") + "%02X", hardwareAddress[i]);
                }
                if (result.length() <= 0 || ni.isLoopback() || ni.isPointToPoint() || ni.isVirtual() || ni.getDisplayName().toLowerCase().startsWith("vmware")) continue;
                macs.put(ni.getName(), result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return macs;
    }

    public static void main(String[] args) {
        ShowSystemIdDialog dialog = new ShowSystemIdDialog((Frame)new JFrame(), true, new GridLicense());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        dialog.setVisible(true);
    }
}

