/*
 * Decompiled with CFR 0.152.
 */
package at.grid.license;

import at.grid.license.LicenseGenerator;
import at.grid.util.Util;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LicenseGeneratorDialog
extends JDialog {
    private JButton btnClose;
    private JButton btnGenerate;
    private JTextField fldDate;
    private JTextArea fldLicense;
    private JTextField fldModules;
    private JTextField fldProduct;
    private JTextField fldSystemid;
    private JTextField fldUsername;
    private JTextField fldVersion;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;

    public LicenseGeneratorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fldUsername = new JTextField();
        this.fldSystemid = new JTextField();
        this.fldModules = new JTextField();
        this.btnClose = new JButton();
        this.btnGenerate = new JButton();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldLicense = new JTextArea();
        this.jLabel5 = new JLabel();
        this.fldProduct = new JTextField();
        this.jLabel7 = new JLabel();
        this.fldVersion = new JTextField();
        this.fldDate = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Benutzername");
        this.jLabel2.setText("System-ID");
        this.jLabel3.setText("Datum");
        this.jLabel4.setText("Module");
        this.btnClose.setText("OK");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseGeneratorDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnGenerate.setText("Generieren");
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseGeneratorDialog.this.btnGenerateActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Lizenz");
        this.fldLicense.setColumns(20);
        this.fldLicense.setRows(5);
        this.jScrollPane1.setViewportView(this.fldLicense);
        this.jLabel5.setText("Produkt");
        this.jLabel7.setText("Version");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 237, Short.MAX_VALUE).addComponent(this.btnClose).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldModules, -1, 150, Short.MAX_VALUE).addComponent(this.fldVersion, -1, 150, Short.MAX_VALUE).addComponent(this.fldProduct, -1, 150, Short.MAX_VALUE).addComponent(this.fldSystemid, -1, 150, Short.MAX_VALUE).addComponent(this.fldUsername, -1, 150, Short.MAX_VALUE).addComponent(this.fldDate))).addComponent(this.btnGenerate).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fldUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fldSystemid, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fldDate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.fldProduct, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.fldVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.fldModules, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnGenerate).addGap(17, 17, 17).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 176, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnClose).addContainerGap()));
        this.pack();
    }

    private void btnGenerateActionPerformed(ActionEvent evt) {
        String username = this.fldUsername.getText();
        if ("".equals(username)) {
            JOptionPane.showMessageDialog(this, "Benutzername fehlt", "Fehler", 0);
            return;
        }
        String systemid = this.fldSystemid.getText();
        if ("".equals(systemid)) {
            JOptionPane.showMessageDialog(this, "System-ID fehlt", "Fehler", 0);
            return;
        }
        String product = this.fldProduct.getText();
        if ("".equals(product)) {
            JOptionPane.showMessageDialog(this, "Produkt fehlt", "Fehler", 0);
            return;
        }
        String modules = this.fldModules.getText();
        if ("".equals(modules)) {
            JOptionPane.showMessageDialog(this, "Module fehlen", "Fehler", 0);
            return;
        }
        Date dt = null;
        try {
            dt = Util.parseDate(this.fldDate.getText(), Util.DATE_READ);
        }
        catch (ParseException ex) {
            Logger.getLogger(LicenseGeneratorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (dt == null) {
            JOptionPane.showMessageDialog(this, "Datum fehlt", "Fehler", 0);
            return;
        }
        String date = Util.formatDate(dt, Util.DATE_ISO);
        this.fldLicense.setText(LicenseGenerator.getLicenseCode(username, systemid, product, modules, date, Float.parseFloat(this.fldVersion.getText())));
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LicenseGeneratorDialog dialog = new LicenseGeneratorDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

