/*
 * Decompiled with CFR 0.152.
 */
package at.grid.license;

import at.grid.file.FileDialog;
import at.grid.license.GridLicense;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LicensePanel
extends JPanel {
    GridLicense lic;
    float currentversion = 0.0f;
    private JButton btnLoadLicenseFile;
    private JButton btnSaveSystemId;
    private JTextArea fldLicense;
    private JTextField fldStatus;
    private JTextArea fldSystemId;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public LicensePanel(float version) {
        this.initComponents();
        this.lic = new GridLicense();
        this.updateSystemId();
        this.currentversion = version;
        this.updateStatus();
    }

    public LicensePanel(GridLicense lic, float version) {
        this.lic = lic;
        this.currentversion = version;
        this.initComponents();
        this.fldLicense.setText(lic.toString());
        this.updateSystemId();
        this.updateStatus();
    }

    public GridLicense getLicense() {
        return this.lic;
    }

    public float getVersion() {
        return this.currentversion;
    }

    public void updateSystemId() {
        if (this.lic != null) {
            StringBuilder sb = new StringBuilder();
            Map<String, String> ids = this.lic.getSystemIds();
            for (String type : ids.keySet()) {
                sb.append(type).append(": ").append(ids.get(type)).append("\n");
            }
            this.fldSystemId.setText(sb.toString());
        }
    }

    public void updateStatus() {
        try {
            this.fldStatus.setText("CHECKING");
            this.fldStatus.setBackground(Color.white);
            String licenseString = this.fldLicense.getText();
            StringReader r = new StringReader(licenseString);
            Properties props = new Properties();
            props.load(r);
            this.lic.set(props);
            boolean checkLicense = this.lic.isValid(this.currentversion);
            if (checkLicense) {
                this.fldStatus.setBackground(Color.green);
                this.fldStatus.setText("OK");
            } else {
                this.fldStatus.setBackground(Color.red);
                this.fldStatus.setText(this.lic.getLastMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.fldStatus = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldLicense = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.fldSystemId = new JTextArea();
        this.btnSaveSystemId = new JButton();
        this.btnLoadLicenseFile = new JButton();
        this.fldStatus.setEditable(false);
        this.jLabel2.setFont(new Font("Verdana", 0, 11));
        this.jLabel2.setText("Lizenzschl\u00fcssel");
        this.jLabel3.setFont(new Font("Verdana", 0, 11));
        this.jLabel3.setText("Status");
        this.fldLicense.setColumns(8);
        this.fldLicense.setFont(new Font("Verdana", 0, 11));
        this.fldLicense.setLineWrap(true);
        this.fldLicense.setRows(5);
        this.fldLicense.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                LicensePanel.this.fldLicenseInputMethodTextChanged(evt);
            }
        });
        this.fldLicense.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                LicensePanel.this.fldLicenseKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fldLicense);
        this.jLabel4.setFont(new Font("Verdana", 0, 11));
        this.jLabel4.setText("System-ID");
        this.fldSystemId.setEditable(false);
        this.fldSystemId.setColumns(20);
        this.fldSystemId.setFont(new Font("Verdana", 0, 11));
        this.fldSystemId.setRows(5);
        this.jScrollPane2.setViewportView(this.fldSystemId);
        this.btnSaveSystemId.setFont(new Font("Verdana", 0, 11));
        this.btnSaveSystemId.setText("System-ID speichern");
        this.btnSaveSystemId.setBorder(new SoftBevelBorder(0));
        this.btnSaveSystemId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicensePanel.this.btnSaveSystemIdActionPerformed(evt);
            }
        });
        this.btnLoadLicenseFile.setFont(new Font("Verdana", 0, 11));
        this.btnLoadLicenseFile.setText("Lizenzfile laden");
        this.btnLoadLicenseFile.setBorder(new SoftBevelBorder(0));
        this.btnLoadLicenseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicensePanel.this.btnLoadLicenseFileActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldStatus)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -1, 302, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, -1, -2).addComponent(this.jLabel4))).addGroup(layout.createSequentialGroup().addComponent(this.btnSaveSystemId, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoadLicenseFile, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 138, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldStatus, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSaveSystemId, -2, 30, -2).addComponent(this.btnLoadLicenseFile, -2, 30, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnSaveSystemIdActionPerformed(ActionEvent evt) {
        String sysid = this.fldSystemId.getText();
        String desktopPath = System.getProperty("user.home") + "/Desktop";
        FileDialog dlg = new FileDialog("System-ID Speichern", 1, new File(desktopPath), new FileNameExtensionFilter("Text-Dateien (*.txt)", "txt"), "txt", false, false);
        if (dlg.getCancelled()) {
            return;
        }
        File f = dlg.getSelection();
        if (f.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Bitte geben Sie einen g\u00fcltigen Namen f\u00fcr die Datei an.", "Information", 1, null);
            return;
        }
        boolean overwriteFile = true;
        if (f.exists()) {
            Object[] options = new String[]{"Ja", "Nein"};
            int option = JOptionPane.showOptionDialog(null, "Soll die vorhandene Datei \u00fcberschrieben werden?", "Datei vorhanden", -1, 3, null, options, options[0]);
            overwriteFile = option != 1;
        }
        if (f != null && overwriteFile) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(f);
                fw.write(sysid);
                fw.close();
                JOptionPane.showMessageDialog(null, "Die System-ID wurde erfolgreich gespeichert.", "Information", 1, null);
            }
            catch (IOException ex) {
                Logger.getLogger(LicensePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    fw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicensePanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void btnLoadLicenseFileActionPerformed(ActionEvent evt) {
        String desktopPath = System.getProperty("user.home") + "/Desktop";
        FileDialog dlg = new FileDialog("Lizenzfile laden", 0, new File(desktopPath), new FileNameExtensionFilter("Text-Dateien (*.txt)", "txt"), "txt", false, false);
        File f = dlg.getSelection();
        if (f != null) {
            try {
                this.fldLicense.setText(Util.fileToString(f));
            }
            catch (IOException ex) {
                Logger.getLogger(LicensePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateStatus();
        } else {
            JOptionPane.showMessageDialog(null, "Das Lizenzfile konnte nicht geladen werden.", "Achtung", 2, null);
        }
    }

    private void fldLicenseInputMethodTextChanged(InputMethodEvent evt) {
        this.updateStatus();
    }

    private void fldLicenseKeyTyped(KeyEvent evt) {
        this.updateStatus();
    }
}

