/*
 * Decompiled with CFR 0.152.
 */
package at.grid.mail;

import at.grid.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Sendmail {
    public static final String version = "2.0, 10.11.2021";
    private ArrayList<HashMap<String, String>> records = new ArrayList();
    private StringBuffer message = new StringBuffer();
    private String smtp;
    private String smtpport;
    private String smtpuser;
    private String smtppwd;
    private String subject;
    private String mailfrom;
    private File attachmentFile = null;
    private int pause = 5;

    public Sendmail(String smtp, String port, String mailfrom, String subject) throws Exception {
        this.smtp = smtp;
        this.smtpport = port;
        this.smtppwd = null;
        this.smtpuser = null;
        this.mailfrom = mailfrom;
        this.subject = subject;
    }

    public void readAdresses(String fn) throws FileNotFoundException, IOException {
        File f = new File(fn);
        if (!f.exists()) {
            throw new FileNotFoundException("File '" + f.getAbsolutePath() + "' does not exists");
        }
        BufferedReader fr = new BufferedReader(new FileReader(f));
        int countlines = 0;
        int counter = 0;
        String ln = fr.readLine();
        List<String> keys = Arrays.asList(ln.split("\t"));
        ArrayList emails = new ArrayList();
        if (!keys.contains("GREETING")) {
            throw new IOException("No 'GREETING' found in list");
        }
        if (!keys.contains("EMAIL")) {
            throw new IOException("No 'EMAIL' found in list");
        }
        while ((ln = fr.readLine()) != null) {
            ++countlines;
            String[] rec = ln.split("\t");
            if (rec.length < 1) continue;
            HashMap<String, String> items = new HashMap<String, String>();
            for (int ii = 0; ii < keys.size(); ++ii) {
                if (rec.length > ii) {
                    items.put(keys.get(ii), rec[ii]);
                    continue;
                }
                items.put(keys.get(ii), "");
            }
            String email = (String)items.get("EMAIL");
            if (email == null || "".equals(email) || emails.contains(email)) continue;
            this.records.add(items);
            ++counter;
        }
        fr.close();
        System.out.println("address list read with " + countlines + " lines, " + counter + " addresses found");
    }

    public void readMessage(String fn) throws FileNotFoundException, IOException {
        String ln;
        File f = new File(fn);
        if (!f.exists()) {
            throw new FileNotFoundException("File '" + f.getAbsolutePath() + "' does not exists");
        }
        BufferedReader fr = new BufferedReader(new FileReader(f));
        while ((ln = fr.readLine()) != null) {
            this.message.append(ln + "\n");
        }
        fr.close();
    }

    public void setMessage(String msg) {
        this.message = new StringBuffer(msg);
    }

    public String getMessage(HashMap<String, String> replacements) {
        String msg = this.message.toString();
        for (String k : replacements.keySet()) {
            msg = msg.replaceAll("##" + k.toUpperCase() + "##", replacements.get(k));
        }
        return msg;
    }

    public String getMessage() {
        return this.message.toString();
    }

    public void loadAttachment(String fn, String name) throws FileNotFoundException {
        this.attachmentFile = new File(fn);
        if (!this.attachmentFile.exists()) {
            String msg = "File '" + this.attachmentFile.getAbsolutePath() + "' does not exists";
            this.attachmentFile = null;
            throw new FileNotFoundException(msg);
        }
    }

    public boolean hasAttachment() {
        return this.attachmentFile != null;
    }

    public void sendList(String list, boolean checkonly) throws Exception {
        this.readAdresses(list);
        int counter = this.records.size();
        System.out.println("Sending mails...");
        for (int ii = 0; ii < counter; ++ii) {
            HashMap<String, String> item = this.records.get(ii);
            String email = item.get("EMAIL");
            if (email == null || "".equals(email)) {
                System.out.println("e-mail in line " + ii + " NOT sent ... no e-mail address ");
                continue;
            }
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", "smtp");
            props.setProperty("mail.host", this.smtp);
            if (this.smtpuser != null) {
                props.setProperty("mail.user", this.smtpuser);
                props.setProperty("mail.password", this.smtppwd);
            }
            if (this.smtpport != null) {
                props.setProperty("mail.smtp.port", this.smtpport);
            }
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            Transport transport = mailSession.getTransport();
            MimeMessage message = new MimeMessage(mailSession);
            message.setSubject(this.subject);
            message.setFrom((Address)new InternetAddress(this.mailfrom));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            MimeMultipart multipart = new MimeMultipart("related");
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            String htmlText = this.getMessage(item);
            messageBodyPart.setContent((Object)htmlText, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            if (this.hasAttachment()) {
                MimeBodyPart mbp = new MimeBodyPart();
                FileDataSource fds99 = new FileDataSource(this.attachmentFile);
                mbp.setDataHandler(new DataHandler((DataSource)fds99));
                mbp.setFileName(fds99.getName());
                multipart.addBodyPart((BodyPart)mbp);
            }
            if (checkonly) continue;
            try {
                transport.connect();
                transport.sendMessage((Message)message, message.getRecipients(Message.RecipientType.TO));
                transport.close();
                System.out.println("... sent to " + email);
            }
            catch (Exception e) {
                System.out.println("ERROR: " + email + " ... " + e.getMessage());
            }
            try {
                if (ii >= counter - 1) continue;
                Thread.sleep(this.pause * 1000);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Sendmail.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void sendSingle(String mailto, boolean checkonly) {
        System.out.println("Single Mail NOT IMPLEMENTED");
    }

    public static void showUsage() {
        System.out.println("Usage: Sendmail MSG=filename FROM=emailfrom SUBJ=subject SMTP=server [USER=username [PWD=password]] [TO=email] [LIST=filename] [ATTACH=filename]");
    }

    public static void main(String[] args) throws Exception {
        block25: {
            System.out.println("Sendmail 2.0, 10.11.2021");
            String msg = null;
            String from = null;
            String subj = null;
            String smtp = null;
            String smtpport = null;
            String smtpuser = null;
            String smtppassword = null;
            String to = null;
            String list = null;
            String attach = null;
            int pause = 5;
            boolean checkonly = false;
            for (String a : args) {
                String[] s = a.split("=");
                if (s.length == 1) {
                    if ("/?".equals(a) || "-h".equals(a) || "--help".equals(a)) {
                        Sendmail.showUsage();
                        System.exit(0);
                        continue;
                    }
                    if (!"verify".equals(s[0])) continue;
                    checkonly = true;
                    continue;
                }
                if ("msg".equalsIgnoreCase(s[0])) {
                    msg = s[1];
                    continue;
                }
                if ("from".equals(s[0])) {
                    from = s[1];
                    continue;
                }
                if ("subj".equals(s[0])) {
                    subj = s[1];
                    continue;
                }
                if ("smtp".equals(s[0])) {
                    smtp = s[1];
                    continue;
                }
                if ("smtpport".equals(s[0])) {
                    smtpport = s[1];
                    continue;
                }
                if ("user".equals(s[0])) {
                    smtpuser = s[1];
                    continue;
                }
                if ("pwd".equals(s[0])) {
                    smtppassword = s[1];
                    continue;
                }
                if ("to".equals(s[0])) {
                    to = s[1];
                    continue;
                }
                if ("list".equals(s[0])) {
                    list = s[1];
                    continue;
                }
                if ("attach".equals(s[0])) {
                    attach = s[1];
                    continue;
                }
                if ("pause".equals(s[0])) {
                    pause = Util.parseInt(s[1], 5);
                    continue;
                }
                System.out.println("Unknown flag '" + s[0] + "'");
                System.exit(1);
            }
            try {
                if (msg == null) {
                    throw new Exception("Missing message file name");
                }
                if (from == null) {
                    throw new Exception("Missing from-address");
                }
                if (subj == null) {
                    throw new Exception("Missing subject");
                }
                if (smtp == null) {
                    throw new Exception("Missing SMTP server");
                }
                if (to == null && list == null) {
                    throw new Exception("Missing address or address list");
                }
                Sendmail sm = new Sendmail(smtp, smtpport, from, subj);
                if (smtpuser != null) {
                    sm.setSmtp(smtp, smtpuser, smtppassword);
                }
                sm.pause = pause;
                sm.readMessage(msg);
                if (attach != null) {
                    sm.loadAttachment(attach, attach);
                }
                if (to != null) {
                    sm.sendSingle(to, checkonly);
                    break block25;
                }
                if (list != null) {
                    sm.sendList(list, checkonly);
                    break block25;
                }
                throw new Exception("Neither TO-address nor list provided");
            }
            catch (Exception e) {
                System.out.println("An error has occured: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    private void setSmtp(String smtp, String smtpuser, String smtppassword) {
        this.smtp = smtp;
        this.smtppwd = smtpuser;
        this.smtpuser = smtppassword;
    }
}

