/*
 * Decompiled with CFR 0.152.
 */
package at.grid.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class Dijkstra {
    private static HashMap<String, Long> edgeMap;
    private static SimpleWeightedGraph<String, DefaultWeightedEdge> graph;

    public static void createGraph(ResultSet rs) throws SQLException {
        graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        edgeMap = new HashMap();
        while (rs.next()) {
            Long idsegment = rs.getLong("idedge");
            String fromnode = rs.getString("fromnode");
            String tonode = rs.getString("tonode");
            double time = rs.getDouble("time");
            double length = rs.getDouble("length");
            Double cost = time;
            graph.addVertex((Object)fromnode);
            graph.addVertex((Object)tonode);
            graph.addEdge((Object)fromnode, (Object)tonode);
            DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.getEdge((Object)fromnode, (Object)tonode);
            graph.setEdgeWeight((Object)edge, cost.doubleValue());
            String nodes = "(" + fromnode + " : " + tonode + ")";
            edgeMap.put(nodes, idsegment);
        }
    }

    public static synchronized ArrayList<Long> calcPath(long fromnode, long tonode) throws Exception {
        ArrayList<Long> edgeList = new ArrayList<Long>();
        String source = Long.valueOf(fromnode).toString();
        String target = Long.valueOf(tonode).toString();
        List resultList = DijkstraShortestPath.findPathBetween(graph, (Object)source, (Object)target);
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            String nodes = it.next().toString();
            Long idsegment = edgeMap.get(nodes);
            edgeList.add(idsegment);
        }
        return edgeList;
    }
}

