/*
 * Decompiled with CFR 0.152.
 */
package at.grid.routing;

import at.grid.gps.routing.SampleEdge;
import at.grid.gps.routing.SampleVertex;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.DirectedWeightedMultigraph;

public class SampleDWMultigraph {
    DirectedWeightedMultigraph<SampleVertex, SampleEdge> graph;
    Set<SampleVertex> verticesSet;
    Set<SampleEdge> edgesSet;

    public void createGraph() {
        this.graph = new DirectedWeightedMultigraph((EdgeFactory)new ClassBasedEdgeFactory(SampleEdge.class));
        ArrayList<Long> vertices = new ArrayList<Long>();
        vertices.add(200L);
        vertices.add(201L);
        vertices.add(202L);
        vertices.add(203L);
        vertices.add(204L);
        vertices.add(205L);
        for (Long v : vertices) {
            SampleVertex j = new SampleVertex(v);
            this.graph.addVertex((Object)j);
        }
        this.verticesSet = this.graph.vertexSet();
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(0)), (Object)this.getSampleVertex((Long)vertices.get(2))))).setId(301L), 20.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(0)), (Object)this.getSampleVertex((Long)vertices.get(3))))).setId(302L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(2)), (Object)this.getSampleVertex((Long)vertices.get(0))))).setId(301L), 20.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(3)), (Object)this.getSampleVertex((Long)vertices.get(0))))).setId(302L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(4)), (Object)this.getSampleVertex((Long)vertices.get(0))))).setId(303L), 5.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(1)), (Object)this.getSampleVertex((Long)vertices.get(2))))).setId(304L), 5.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(2)), (Object)this.getSampleVertex((Long)vertices.get(1))))).setId(304L), 5.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(2)), (Object)this.getSampleVertex((Long)vertices.get(3))))).setId(305L), 15.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(3)), (Object)this.getSampleVertex((Long)vertices.get(2))))).setId(305L), 15.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(3)), (Object)this.getSampleVertex((Long)vertices.get(4))))).setId(306L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(4)), (Object)this.getSampleVertex((Long)vertices.get(3))))).setId(306L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(1)), (Object)this.getSampleVertex((Long)vertices.get(5))))).setId(307L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(3)), (Object)this.getSampleVertex((Long)vertices.get(5))))).setId(309L), 30.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(4)), (Object)this.getSampleVertex((Long)vertices.get(5))))).setId(310L), 25.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(5)), (Object)this.getSampleVertex((Long)vertices.get(1))))).setId(307L), 10.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(5)), (Object)this.getSampleVertex((Long)vertices.get(2))))).setId(308L), 5.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(5)), (Object)this.getSampleVertex((Long)vertices.get(3))))).setId(308L), 30.0);
        this.graph.setEdgeWeight((Object)((SampleEdge)((Object)this.graph.addEdge((Object)this.getSampleVertex((Long)vertices.get(5)), (Object)this.getSampleVertex((Long)vertices.get(4))))).setId(310L), 25.0);
        this.edgesSet = this.graph.edgeSet();
    }

    public ArrayList<Long> calculatePath(Long source, Long target) {
        System.out.println("Edge :" + this.graph.getEdge((Object)this.getSampleVertex(source), (Object)this.getSampleVertex(target)));
        DijkstraShortestPath path = new DijkstraShortestPath(this.graph, (Object)this.getSampleVertex(source), (Object)this.getSampleVertex(target));
        List edges = path.getPathEdgeList();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SampleEdge e : edges) {
            ids.add(e.getId());
        }
        return ids;
    }

    public SampleVertex getSampleVertex(Long id) {
        for (SampleVertex v : this.verticesSet) {
            if (!id.equals(v.getId())) continue;
            return v;
        }
        return null;
    }

    public SampleEdge getSampleEdge(Long id) {
        for (SampleEdge e : this.edgesSet) {
            if (!id.equals(e.getId())) continue;
            return e;
        }
        return null;
    }

    public static void main(String[] args) {
        long idfrom = 200L;
        long idto = 205L;
        SampleDWMultigraph tg = new SampleDWMultigraph();
        Date t1 = new Date();
        tg.createGraph();
        Date t2 = new Date();
        System.out.println("Time to create graph: " + (t2.getTime() - t1.getTime()));
        System.out.println(tg.calculatePath(idfrom, idto).toString());
        Date t3 = new Date();
        System.out.println("Time to calculate path:  " + (t3.getTime() - t2.getTime()));
    }
}

