/*
 * Decompiled with CFR 0.152.
 */
package at.grid.tests;

import java.awt.EventQueue;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTree
extends JFrame {
    FileTreeModel model;
    private JTree fileTree;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;

    public FileTree() {
        this.initComponents();
        File root = new File(System.getProperty("user.home"));
        this.model = new FileTreeModel(root);
        this.fileTree.setModel(this.model);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.fileTree = new JTree();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.jScrollPane2.setViewportView(this.fileTree);
        this.jLabel1.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(0, 190, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 300, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FileTree.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FileTree.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FileTree.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FileTree.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileTree().setVisible(true);
            }
        });
    }

    class FileTreeModel
    implements TreeModel {
        private File root;
        private Vector listeners = new Vector();

        public FileTreeModel(File rootDirectory) {
            this.root = rootDirectory;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            File directory = (File)parent;
            String[] children = directory.list();
            return new TreeFile(directory, children[index]);
        }

        @Override
        public int getChildCount(Object parent) {
            String[] fileList;
            File file = (File)parent;
            if (file.isDirectory() && (fileList = file.list()) != null) {
                return file.list().length;
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            File file = (File)node;
            return file.isFile();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            File directory = (File)parent;
            File file = (File)child;
            String[] children = directory.list();
            for (int i = 0; i < children.length; ++i) {
                if (!file.getName().equals(children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object value) {
            File oldFile = (File)path.getLastPathComponent();
            String fileParentPath = oldFile.getParent();
            String newFileName = (String)value;
            File targetFile = new File(fileParentPath, newFileName);
            oldFile.renameTo(targetFile);
            File parent = new File(fileParentPath);
            int[] changedChildrenIndices = new int[]{this.getIndexOfChild(parent, targetFile)};
            Object[] changedChildren = new Object[]{targetFile};
            this.fireTreeNodesChanged(path.getParentPath(), changedChildrenIndices, changedChildren);
        }

        private void fireTreeNodesChanged(TreePath parentPath, int[] indices, Object[] children) {
            TreeModelEvent event = new TreeModelEvent((Object)this, parentPath, indices, children);
            Iterator iterator = this.listeners.iterator();
            TreeModelListener listener = null;
            while (iterator.hasNext()) {
                listener = (TreeModelListener)iterator.next();
                listener.treeNodesChanged(event);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        private class TreeFile
        extends File {
            public TreeFile(File parent, String child) {
                super(parent, child);
            }

            @Override
            public String toString() {
                return this.getName();
            }
        }
    }
}

