/*
 * Decompiled with CFR 0.152.
 */
package at.grid.tests;

import at.grid.gui.Dialogs;
import at.grid.util.Util;
import com.sun.mail.imap.IMAPFolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;

public class ImapMailTest {
    private static void readEmails() throws MessagingException, IOException {
        ImapMailTest.readEmails("mail.grid-it.at", "interface@themis-software.com", "Ci32Ebp6", 993);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEmails(String imapServer, String emailAuthUser, String emailAuthPwd, int port) throws MessagingException, IOException {
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        props.setProperty("mail.imap.ssl.enable", "true");
        props.setProperty("mail.imap.socketFactory.port", port + "");
        Session session = Session.getDefaultInstance((Properties)props, null);
        try (Store store = session.getStore("imaps");){
            System.out.println("Connecting to IMAP server: " + imapServer);
            store.connect(imapServer, port, emailAuthUser, emailAuthPwd);
            Folder root = store.getDefaultFolder();
            Folder[] folders = root.list();
            System.out.println("Select a folder");
            for (int i = 0; i < folders.length; ++i) {
                System.out.println("\t" + folders[i].getName());
            }
            String folderName = "INBOX";
            IMAPFolder folder = (IMAPFolder)store.getFolder(folderName);
            long afterFolderSelectionTime = System.nanoTime();
            boolean totalNumberOfMessages = false;
            try {
                Message[] allMessages;
                if (!folder.isOpen()) {
                    folder.open(1);
                }
                System.out.println("Anzahl Messages: " + folder.getMessageCount());
                for (Message msg : allMessages = folder.getMessages()) {
                    String subj = msg.getSubject();
                    System.out.println("\t" + folder.getUID(msg) + "\t" + Util.formatDate(msg.getReceivedDate(), Util.DATETIME_READ, TimeZone.getDefault()) + "\t" + msg.getSubject());
                    if (subj == null) {
                        boolean bl = true;
                        continue;
                    }
                    if (!subj.startsWith("themis ")) continue;
                    ImapMailTest.saveParts(msg.getContent(), subj);
                }
            }
            finally {
                if (folder.isOpen()) {
                    folder.close(true);
                }
            }
        }
        Dialogs.showInfoDialog("Finished loading emails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveParts(Object content, String filename) throws IOException, MessagingException {
        OutputStream out = null;
        InputStream in = null;
        try {
            if (content instanceof Multipart) {
                Multipart multi = (Multipart)content;
                int parts = multi.getCount();
                for (int j = 0; j < parts; ++j) {
                    int k;
                    MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(j);
                    if (part.getContent() instanceof Multipart) {
                        ImapMailTest.saveParts(part.getContent(), part.getFileName());
                        continue;
                    }
                    String extension = "";
                    if (part.isMimeType("text/html")) {
                        extension = "html";
                        continue;
                    }
                    extension = part.isMimeType("text/plain") ? "txt" : part.getDataHandler().getName();
                    filename = filename + "." + extension;
                    System.out.println("... " + filename);
                    out = new FileOutputStream(new File("c:/temp", filename));
                    in = part.getInputStream();
                    while ((k = in.read()) != -1) {
                        out.write(k);
                    }
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void main(String[] args) throws MessagingException, IOException {
        ImapMailTest.readEmails();
    }
}

