/*
 * Decompiled with CFR 0.152.
 */
package at.grid.tests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MicMacXml {
    Document doc;
    double factor = 0.5;
    File source;
    File dest;

    public MicMacXml(File source, File dest, double factor) {
        this.source = source;
        this.dest = dest;
        this.dest.mkdirs();
        this.factor = factor;
    }

    public void process() throws JDOMException, IOException {
        SAXBuilder b = new SAXBuilder();
        for (File f : this.source.listFiles()) {
            FileWriter fw;
            XMLOutputter out;
            if (f.getName().startsWith("PC") && f.getName().endsWith(".xml")) {
                this.doc = b.build(f);
                this.reduce("Sz");
                this.reduce("Offset");
                out = new XMLOutputter(Format.getPrettyFormat().setTextMode(Format.TextMode.PRESERVE));
                fw = new FileWriter(new File(this.dest, f.getName()));
                out.output(this.doc, (Writer)fw);
                fw.close();
                continue;
            }
            if (!f.getName().equals("MTDOrtho.xml")) continue;
            this.doc = b.build(f);
            this.reduce("NombrePixels");
            out = new XMLOutputter(Format.getPrettyFormat().setTextMode(Format.TextMode.PRESERVE));
            fw = new FileWriter(new File(this.dest, f.getName()));
            out.output(this.doc, (Writer)fw);
            fw.close();
        }
    }

    private void reduce(String tag) {
        String sz = this.doc.getRootElement().getChildText(tag);
        String[] szs = sz.split(" ");
        int sz1 = (int)((double)Integer.parseInt(szs[0]) * this.factor);
        int sz2 = (int)((double)Integer.parseInt(szs[1]) * this.factor);
        this.doc.getRootElement().getChild(tag).setText(sz1 + " " + sz2);
    }

    public static void main(String[] args) throws JDOMException, IOException {
        MicMacXml mm = new MicMacXml(new File("C:/temp/class"), new File("C:/temp/class/out40"), 0.4);
        mm.process();
    }
}

