/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    BufferedImage backgroundImage;
    double zoom = 1.0;
    double zoomfactor = 2.0;
    Point corner = new Point(0, 0);
    Point drag0;
    Point dragCorner = new Point(this.corner);

    public ImagePanel() {
        this.setBackground(Color.white);
        this.setSize(450, 400);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public void setImage(BufferedImage out, BufferedImage i) {
        if (i == null) {
            out = null;
        } else {
            out = new BufferedImage(i.getWidth(this), i.getHeight(), 2);
            Graphics2D g2 = out.createGraphics();
            g2.drawImage((Image)i, 0, 0, this);
            g2.dispose();
        }
        this.repaint();
    }

    public void setBackgroundImage(BufferedImage i) {
        if (i == null) {
            this.backgroundImage = null;
        } else {
            this.backgroundImage = new BufferedImage(i.getWidth(this), i.getHeight(), 2);
            Graphics2D g2 = this.backgroundImage.createGraphics();
            g2.drawImage((Image)i, 0, 0, this);
            g2.dispose();
        }
        this.repaint();
    }

    public double getPanelZoom() {
        if (this.backgroundImage == null) {
            return 1.0;
        }
        return Math.min((double)this.getWidth() / (double)this.backgroundImage.getWidth(), (double)this.getHeight() / (double)this.backgroundImage.getHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double panelzoom = this.getPanelZoom();
        if (this.backgroundImage != null) {
            this.drawImage(this.backgroundImage, (Graphics2D)g, panelzoom);
        }
    }

    private void drawImage(BufferedImage i, Graphics2D g2, double panelzoom) {
        BufferedImage iout = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D gg = iout.createGraphics();
        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gg.scale(this.zoom * panelzoom, this.zoom * panelzoom);
        gg.drawImage((Image)i, this.corner.x, this.corner.y, null);
        gg.dispose();
        g2.drawImage((Image)iout, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.drag0 = e.getPoint();
        this.dragCorner.setLocation(this.corner);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double panelzoom = this.getPanelZoom();
        this.corner.setLocation(this.dragCorner.x + (int)((double)(e.getPoint().x - this.drag0.x) / (this.zoom * panelzoom)), this.dragCorner.y + (int)((double)(e.getPoint().y - this.drag0.y) / (this.zoom * panelzoom)));
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoom = e.getWheelRotation() < 0 ? (this.zoom *= this.zoomfactor) : (this.zoom /= this.zoomfactor);
        this.repaint();
    }
}

