/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import at.grid.util.ProgressHandler;
import java.util.logging.Logger;

public class LoggerProgressHandler
implements ProgressHandler {
    Logger log;
    String steptitle;
    String progresstitle;
    int currentProgress = 0;

    public LoggerProgressHandler(Logger log, String title) {
        this.log = log;
        this.progresstitle = title;
    }

    @Override
    public void progressDone() {
        this.log.info("Done" + this.progresstitle + "!");
    }

    @Override
    public void doneWithConfirm(String info) {
        this.progressDone();
    }

    @Override
    public void progress(String t, int step) {
        this.currentProgress = step;
        this.log.info("Setting progress for '" + this.progresstitle + "' to #" + step + " (" + t + ")");
    }

    @Override
    public void progress(int step) {
        this.currentProgress = step;
        this.log.info("Setting progress for '" + this.progresstitle + "' to #" + step);
    }

    @Override
    public void progress(String t) {
        this.setDisplayName(t);
        this.log.info("Setting progress for '" + this.progresstitle + "' to #" + this.currentProgress + " (" + t + ")");
    }

    @Override
    public void switchToDeterminate(int workunits) {
        this.log.info("Setting workunits for '" + this.progresstitle + "' to " + workunits);
    }

    @Override
    public void setDisplayName(String n) {
        this.progresstitle = n;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void disableCancel() {
    }

    @Override
    public void increaseProgress(int count) {
        this.progress(this.currentProgress + count);
    }

    @Override
    public void progress(int fromCount, int untilCount, float val) {
        this.progress((int)((float)fromCount + val * (float)(untilCount - fromCount)));
    }
}

