/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.util.ArrayList;
import java.util.Collections;

public class NumberRange {
    Integer untilMin;
    Integer fromMax;
    ArrayList<Integer> numbers = new ArrayList();
    boolean allowNegative;

    public NumberRange(String s) {
        this(s, false);
    }

    public NumberRange(String s, boolean allowNegative) {
        if (s == null || "".equals(s)) {
            return;
        }
        for (String s0 : s.split(",")) {
            if (s0.startsWith("-")) {
                if (allowNegative) {
                    try {
                        int n = Integer.parseInt(s0);
                        this.numbers.add(n);
                    }
                    catch (Exception n) {}
                    continue;
                }
                this.untilMin = Integer.parseInt(s0.substring(1));
                continue;
            }
            if (s0.startsWith("..")) {
                this.untilMin = Integer.parseInt(s0.substring(2));
                continue;
            }
            if (s0.endsWith("-")) {
                this.fromMax = Integer.parseInt(s0.substring(0, s0.length() - 1));
                continue;
            }
            if (s0.endsWith("..")) {
                this.fromMax = Integer.parseInt(s0.substring(0, s0.length() - 2));
                continue;
            }
            if (s0.contains("-") && !s0.startsWith("-")) {
                String[] split = s0.split("-");
                int nFrom = Integer.parseInt(split[0]);
                if (split.length <= 1) continue;
                int nTo = Integer.parseInt(split[1]);
                for (int ii = nFrom; ii <= nTo; ++ii) {
                    this.numbers.add(ii);
                }
                continue;
            }
            try {
                int n = Integer.parseInt(s0);
                this.numbers.add(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(this.numbers);
    }

    public int size() {
        return this.numbers.size();
    }

    public boolean hasMany() {
        return this.untilMin != null || this.fromMax != null || this.size() > 1;
    }

    public boolean isEmpty() {
        return !this.hasMany() && this.size() == 0;
    }

    public boolean isSingle() {
        return !this.hasMany() && this.size() == 1;
    }

    public boolean containsNumber(int n) {
        if (this.untilMin != null && n <= this.untilMin) {
            return true;
        }
        if (this.fromMax != null && n >= this.fromMax) {
            return true;
        }
        return this.numbers.contains(n);
    }
}

