/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import at.grid.util.DefaultProgressHandler;
import at.grid.util.Dimension;
import at.grid.util.ProgressHandler;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.json.JSONObject;
import org.openide.util.Exceptions;

public class Util {
    public static String DATETIME_SQL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static String DATETIME_XML = "yyyy-MM-dd HH:mm:ss.SSS";
    public static String DATETIME_ISO = "yyyy-MM-dd HH:mm:ss.SSS";
    public static String DATETIME_ISO_NO_MILI = "yyyy-MM-dd HH:mm:ss";
    public static String DATETIME_FILE = "yyyyMMdd_HHmmss";
    public static String DATETIME_FILE2 = "yyyy-MM-dd_HH-mm-ss";
    public static String DATETIME_FILE_MILI = "yyyyMMdd_HHmmssSSS";
    public static String DATETIME_URL = "yyyyMMddHHmmss";
    public static String DATETIME_READ = "dd.MM.yyyy HH:mm:ss";
    public static String DATETIME_PRETTY = "dd.MM.yyyy 'um' HH:mm";
    public static String DATE_SQL = "yyyy-MM-dd";
    public static String DATE_XML = "yyyy-MM-dd";
    public static String DATE_ISO = "yyyy-MM-dd";
    public static String DATE_FILE = "yyyyMMdd";
    public static String DATE_FILE_YEAR_MONTH = "yyyyMM";
    public static String DATE_URL = "yyyyMMdd";
    public static String DATE_READ = "dd.MM.yyyy";
    public static String DATE_READ_SHORT = "dd.MM.yy";
    private static final HashMap<String, Logger> loggers = new HashMap();
    private static final int NUMBER_MAX_LENGTH = String.valueOf(Long.MAX_VALUE).length();

    public static Logger getLogger(String name) {
        if (loggers.get(name) == null) {
            Logger log = Logger.getLogger(name);
            log.setUseParentHandlers(false);
            ConsoleHandler h = new ConsoleHandler();
            h.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String lvl = record.getLevel().getName();
                    int idx = Math.max(12, lvl.length());
                    String ref = "";
                    if (record.getLevel().equals(Level.SEVERE)) {
                        ref = " [" + record.getSourceClassName() + ":" + record.getSourceMethodName() + "] ";
                    }
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(record.getMillis()) + " " + lvl + "              ".substring(idx) + record.getMessage() + ref + "\n";
                }
            });
            log.addHandler(h);
            loggers.put(name, log);
            return log;
        }
        return loggers.get(name);
    }

    public static Logger getFileLogger(File output, String name) {
        if (loggers.get(name) == null) {
            StreamHandler h;
            Logger log = Logger.getLogger(name);
            log.setUseParentHandlers(false);
            try {
                h = new FileHandler(output.getAbsolutePath(), true);
            }
            catch (IOException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                h = new ConsoleHandler();
            }
            catch (SecurityException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                h = new ConsoleHandler();
            }
            h.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(record.getMillis()) + " " + record.getLevel() + " [" + record.getSourceClassName() + ":" + record.getSourceMethodName() + "] " + record.getMessage() + "\n";
                }
            });
            log.addHandler(h);
            loggers.put(name, log);
            return log;
        }
        return loggers.get(name);
    }

    public static double round(double v, int s) {
        double exp = Math.pow(10.0, s);
        return (double)Math.round(v * exp) / exp;
    }

    public static float round(float v, int s) {
        return (float)Util.round((double)v, s);
    }

    public static double interpolate(double[] x, double[] y, double x0) throws IllegalArgumentException {
        int ii;
        int l = x.length;
        if (l != y.length) {
            throw new IllegalArgumentException("Array length mismatch, cannot interpolate");
        }
        for (ii = 1; ii < l; ++ii) {
            if (x[ii] < x[ii - 1]) {
                throw new IllegalArgumentException("X-array not sorted, cannot interpolate");
            }
            if (x[ii] != x[ii - 1]) continue;
            throw new IllegalArgumentException("Two equal x-values, cannot interpolate");
        }
        if (x0 < x[0]) {
            return y[0];
        }
        if (x0 > x[l - 1]) {
            return y[l - 1];
        }
        for (ii = 1; ii < l; ++ii) {
            if (!(x0 <= x[ii])) continue;
            return y[ii - 1] + (y[ii] - y[ii - 1]) * (x0 - x[ii - 1]) / (x[ii] - x[ii - 1]);
        }
        return 0.0;
    }

    public static double randomNorm(double mean, double stdev) {
        double x2;
        double x1;
        while ((x1 = Math.random()) * x1 + (x2 = Math.random()) * x2 > 1.0 || x1 == 0.0 && x2 == 0.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(x1)) * Math.cos(Math.PI * 2 * x2);
        return mean + z * stdev;
    }

    public static double randomExp(double mean) {
        double x1;
        while ((x1 = Math.random()) == 0.0) {
        }
        double z = -Math.log(x1);
        return mean * z;
    }

    public static String toXmlString(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("&", "&amp;").replace("\"", "&quot;");
    }

    public static String toSqlString(boolean b) {
        if (b) {
            return "'t'";
        }
        return "'f'";
    }

    public static String toSqlString(String s) {
        if (s == null) {
            return "null";
        }
        return "'" + s.replaceAll("'", "''") + "'";
    }

    public static String toSqlString(Date dt, TimeZone tz) {
        if (dt == null) {
            return "null";
        }
        return "'" + Util.formatDate(dt, DATETIME_SQL, tz) + "'";
    }

    public static String toSqlString(Iterable lst) {
        return Util.toSqlString(lst, false);
    }

    public static String toSqlString(Iterable lst, boolean withQoutes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("(");
        for (Object o : lst) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            if (withQoutes) {
                sb.append("'");
            }
            sb.append(o.toString());
            if (!withQoutes) continue;
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(Iterable lst) {
        return Util.toString(lst, ",");
    }

    public static String toString(Iterable lst, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : lst) {
            if (!first) {
                sb.append(separator);
            }
            first = false;
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static String expandString(String s, String ch, int length) {
        return Util.expandString(s, ch, length, false);
    }

    public static String expandString(String s, String ch, int length, boolean addBefore) {
        if (ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(length - s.length());
        for (int ii = 0; ii < length - s.length(); ++ii) {
            sb.append(ch);
        }
        if (addBefore) {
            return sb.toString() + s;
        }
        return s + sb.toString();
    }

    public static String cutString(String s, int length, boolean cutWord, boolean withPoints) {
        if (s.length() < length) {
            return s;
        }
        if (withPoints) {
            length -= 6;
        }
        String s1 = s.substring(0, length);
        String result = "";
        if (cutWord) {
            int idx = s1.lastIndexOf(" ");
            result = s1.substring(0, idx);
        } else {
            result = s1.substring(0, length);
        }
        if (withPoints) {
            result = result + " (...)";
        }
        return result;
    }

    public static String getRelativePath(String path, String folderpath) {
        if (path.startsWith(folderpath)) {
            path = "." + path.substring(folderpath.length());
        }
        return path;
    }

    public static String md5(File f) {
        String md5 = null;
        try {
            InputStream is = Files.newInputStream(Paths.get(f.getAbsolutePath(), new String[0]), new OpenOption[0]);
            byte[] md5bytes = DigestUtils.md5((InputStream)is);
            is.close();
            md5 = Base64.getEncoder().encodeToString(md5bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return md5;
    }

    public static String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes(), 0, s.length());
            StringBuilder result = new StringBuilder(new BigInteger(1, m.digest()).toString(16));
            while (result.length() < 32) {
                result.insert(0, "0");
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return "error";
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        if (!sourceLocation.exists()) {
            return;
        }
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdirs();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                Util.copy(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            if (!targetLocation.exists()) {
                targetLocation.getParentFile().mkdirs();
            }
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = targetLocation.isDirectory() ? new FileOutputStream(new File(targetLocation, sourceLocation.getName())) : new FileOutputStream(targetLocation);
            Util.copy(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
            File fParent = targetLocation.getParentFile();
            targetLocation.setReadable(fParent.canRead());
            targetLocation.setWritable(fParent.canWrite());
            targetLocation.setExecutable(fParent.canExecute());
        }
    }

    public static InputStream getInputStream(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0");
        con.setRequestMethod("POST");
        return con.getInputStream();
    }

    public static void copy(URL url, File f) throws FileNotFoundException, IOException {
        Util.copy(url, f, null);
    }

    public static void copy(URL url, File f, ProgressHandler ph) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        Util.copy(Util.getInputStream(url), out, ph);
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Util.copy(in, out, null);
    }

    public static long copy(InputStream in, OutputStream out, ProgressHandler ph) throws IOException {
        int len;
        int max;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        if ((max = in.available()) >= 0) {
            ph.switchToDeterminate(max);
        }
        byte[] buf = new byte[32768];
        long totallen = 0L;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
            totallen += (long)len;
            if (max < 0) continue;
            ph.progress((int)totallen);
        }
        Util.closeStream(in);
        Util.closeStream(out);
        return totallen;
    }

    public static boolean move(File fromFile, File toFile) {
        if (toFile.exists()) {
            return false;
        }
        boolean ok = fromFile.renameTo(toFile);
        if (ok) {
            return true;
        }
        try {
            Util.copy(fromFile, toFile);
            toFile.setWritable(true, false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        ok = toFile.isFile();
        if (ok) {
            return Util.delete(fromFile);
        }
        return false;
    }

    public static void zipFile(File f, boolean overwrite) throws FileNotFoundException, IOException {
        File fOut = new File(f.getAbsoluteFile().getParentFile(), Util.getFileNameWithoutExtension(f) + ".zip");
        if (fOut.isFile() && !overwrite) {
            return;
        }
        fOut.delete();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(fOut));){
            zipOut.putNextEntry(new ZipEntry(f.getName()));
            Files.copy(f.toPath(), zipOut);
        }
    }

    public static void copyToZip(File fSource, File fTarget, boolean overwrite) throws FileNotFoundException, IOException {
        if (fTarget.isFile() && !overwrite) {
            return;
        }
        fTarget.delete();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(fTarget));){
            zipOut.putNextEntry(new ZipEntry(fSource.getName()));
            Files.copy(fSource.toPath(), zipOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File f, File destDir) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(f), Charset.forName("Cp437"));
        byte[] buffer = new byte[2048];
        while (true) {
            ZipEntry entry;
            if ((entry = zis.getNextEntry()) == null) {
                zis.close();
                return;
            }
            if (entry.isDirectory()) {
                new File(destDir, entry.getName()).mkdirs();
                continue;
            }
            try {
                File fEntry = new File(destDir, entry.getName());
                fEntry.getParentFile().mkdirs();
                fos = new FileOutputStream(fEntry);
                int len = 0;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (fos == null) continue;
                fos.close();
                continue;
            }
            break;
        }
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteContent(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        File[] children = folder.listFiles();
        if (children != null) {
            for (File f : children) {
                Util.delete(f);
            }
        }
    }

    public static boolean delete(File location) {
        boolean success = false;
        if (location == null) {
            return success;
        }
        if (location.isDirectory()) {
            File[] children = location.listFiles();
            if (children != null) {
                for (File f : children) {
                    Util.delete(f);
                }
            }
            location.delete();
        } else if (location.isFile()) {
            location.delete();
        }
        return !location.exists();
    }

    public static String getFileExtension(File f) {
        if (f == null) {
            return "";
        }
        String n = f.getName();
        int idx = n.lastIndexOf(".");
        if (idx < 0) {
            return "";
        }
        return n.substring(idx + 1);
    }

    public static String getFileNameWithoutExtension(File f) {
        String n = f.getName();
        int idx = n.lastIndexOf(".");
        if (idx < 0) {
            return n;
        }
        return n.substring(0, idx);
    }

    public static String fileToString(File f) throws IOException {
        if (!f.exists() || f.isDirectory()) {
            return null;
        }
        byte[] buffer = new byte[(int)f.length()];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        bis.read(buffer);
        Util.closeStream(bis);
        return new String(buffer);
    }

    public static String urlToString(URL u) throws IOException {
        try (Scanner scanner = new Scanner(u.openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public static void stringToFile(String s, File f) throws IOException {
        if (f == null) {
            return;
        }
        try {
            f.delete();
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            Util.closeStream(fw);
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static String stringToFileIgnoreException(String s, File f) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            Util.closeStream(fw);
            return null;
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    public static void setFileVisibility(File file, boolean visible) {
        Path path = file.toPath();
        try {
            Files.setAttribute(path, "dos:hidden", !visible, new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int countFilesInSubdirectories(File f) {
        int counter = 0;
        File[] lst = f.listFiles();
        if (lst == null) {
            return 0;
        }
        for (File ff : lst) {
            ++counter;
            if (!ff.isDirectory()) continue;
            counter += Util.countFilesInSubdirectories(ff);
        }
        return counter;
    }

    public static void socketClient(String address, int port) {
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket(address, port);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: " + address);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: " + address);
            System.exit(1);
        }
        try {
            String teststring = "Teststring from socket client";
            System.out.println("Starting socket client");
            System.out.println("Client is sending '" + teststring + "'");
            out.println(teststring);
            System.out.println("Server is responding '" + in.readLine() + "'");
            out.close();
            in.close();
            echoSocket.close();
            System.out.println("Terminating socket client");
        }
        catch (IOException e) {
            System.out.println("R/W ERror");
        }
    }

    public static void socketServer(int port) {
        System.out.println("Starting socket server");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(1);
        }
        Socket clientSocket = null;
        try {
            clientSocket = serverSocket.accept();
        }
        catch (IOException e) {
            System.err.println("Accept failed.");
            System.exit(1);
        }
        try {
            String inputLine;
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                System.out.println("Received: '" + inputLine + "'");
                String outputLine = "ECHO: " + inputLine;
                out.println(outputLine);
                System.out.println("Sent: " + outputLine);
                if (!outputLine.equals("Bye.")) continue;
                System.out.println("Terminating socket server");
                break;
            }
            out.close();
            in.close();
            clientSocket.close();
            serverSocket.close();
        }
        catch (IOException e) {
            System.out.println("R/W ERror");
        }
    }

    public static void log(Level SEVERE, String string) {
        Util.getLogger("grid").log(SEVERE, string);
    }

    @Deprecated
    public static String formatDate(Date dt, String pattern) {
        return Util.formatDate(dt, pattern, TimeZone.getTimeZone("GMT+1"));
    }

    public static String formatDate(Date dt, String pattern, TimeZone tz) {
        if (dt == null) {
            return "";
        }
        SimpleDateFormat frm = new SimpleDateFormat(pattern);
        frm.setTimeZone(tz);
        return frm.format(dt);
    }

    @Deprecated
    public static Date parseDate(String dt, String pattern) throws ParseException {
        return Util.parseDate(dt, pattern, TimeZone.getTimeZone("GMT+1"));
    }

    public static Date parseDate(String dt, TimeZone tz) {
        String[] dateFormats;
        for (String df : dateFormats = new String[]{DATE_READ, DATE_ISO, DATETIME_ISO, DATETIME_READ, DATETIME_PRETTY}) {
            SimpleDateFormat f = new SimpleDateFormat(df);
            f.setLenient(true);
            try {
                return f.parse(dt);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Date parseDate(String dt, String[] formats, TimeZone tz) throws ParseException {
        for (String f : formats) {
            try {
                return Util.parseDate(dt, f, tz);
            }
            catch (Exception exception) {
            }
        }
        return Util.parseDate(dt, formats[0], tz);
    }

    public static Date parseDate(String dt, String pattern, TimeZone tz) throws ParseException {
        SimpleDateFormat frm = new SimpleDateFormat(pattern);
        frm.setTimeZone(tz);
        return frm.parse(dt);
    }

    public static Date parseDate(String dt, String pattern, TimeZone tz, Date defaultValue) {
        try {
            if (dt == null || "".equals(dt)) {
                return null;
            }
            SimpleDateFormat frm = new SimpleDateFormat(pattern);
            frm.setTimeZone(tz);
            return frm.parse(dt);
        }
        catch (ParseException parseException) {
            return defaultValue;
        }
    }

    public static Date julDayToDate(int julDay) {
        int ja;
        int julGreg = 2299161;
        if (julDay >= julGreg) {
            int jalpha = (int)(((double)(julDay - 1867216) - 0.25) / 36524.25);
            ja = julDay + 1 + jalpha - (int)(0.25 * (double)jalpha);
        } else {
            ja = julDay;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = (int)((double)(365 * jc) + 0.25 * (double)jc);
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return cal.getTime();
    }

    public static int dateToJulDay(Date dt) {
        int jm;
        int jy;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        int greg = 588829;
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        if (year < 0) {
            ++year;
        }
        if (month > 2) {
            jy = year;
            jm = month + 1;
        } else {
            jy = year - 1;
            jm = month + 13;
        }
        int jul = (int)(365.25 * (double)jy) + (int)(30.6001 * (double)jm) + day + 1720995;
        if (day + 31 * (month + 12 * year) >= greg) {
            int ja = (int)(0.01 * (double)jy);
            jul = jul + 2 - ja + (int)(0.25 * (double)ja);
        }
        return jul;
    }

    public static int countDays(Calendar cal, Date from, Date to) throws IllegalArgumentException {
        return Util.countDays(cal, from, to, true);
    }

    public static int countDays(Calendar cal, Date from, Date to, boolean strict) throws IllegalArgumentException {
        if (from == null || to == null) {
            return 0;
        }
        long deltaT = from.getTime() - to.getTime();
        int count = (int)(deltaT / 86400000L);
        cal.setTime(from);
        cal.add(5, count);
        if (cal.getTime().before(to)) {
            while (cal.getTime().before(to)) {
                cal.add(5, 1);
                ++count;
            }
        } else if (cal.getTime().after(to)) {
            while (cal.getTime().after(to)) {
                cal.add(5, -1);
                --count;
            }
        }
        if (!cal.getTime().equals(to) && strict) {
            throw new IllegalArgumentException("Cannot count days, dates show different time of day");
        }
        return count;
    }

    public static String addDaysToDate(int days) {
        GregorianCalendar c = new GregorianCalendar();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        ((Calendar)c).add(5, days);
        return formatter.format((Object)c.getTime());
    }

    public static String addDaysToDate(String days) {
        try {
            int temp = Integer.parseInt(days);
            return Util.addDaysToDate(temp);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Date rollDate(Date dt, int count, int field) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(dt);
        ((Calendar)c).roll(field, count);
        return c.getTime();
    }

    public static int daysBetweenDates(Date from, Date to) {
        int delta = 0;
        try {
            if (from == null) {
                GregorianCalendar c = new GregorianCalendar();
                from = c.getTime();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            from = sdf.parse(sdf.format(from));
            if (to == null) {
                return 0;
            }
            delta = (int)((to.getTime() - from.getTime()) / 86400000L);
        }
        catch (ParseException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        return delta;
    }

    public static String hourToString(double hour) {
        int h = (int)Math.floor(hour);
        int m = (int)((hour - (double)h) * 60.0);
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getTifDimension(File imgFile) throws IOException {
        int pos = imgFile.getName().lastIndexOf(".");
        if (pos == -1) {
            throw new IOException("No extension for file: " + imgFile.getAbsolutePath());
        }
        String suffix = imgFile.getName().substring(pos + 1);
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("tiff");
        Iterator<ImageReader> iter2 = ImageIO.getImageReadersBySuffix(suffix);
        IOException ex = null;
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                FileImageInputStream stream = new FileImageInputStream(imgFile);
                reader.setInput(stream);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e) {
                ex = e;
            }
            finally {
                reader.dispose();
            }
            if (ex != null) {
                throw ex;
            }
        }
        throw new IOException("Not a known image file: " + imgFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Dimension getImageSize(File f) {
        try {
            FileSeekableStream s = new FileSeekableStream(f);
            ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, null);
            try (ImageInputStream in = ImageIO.createImageInputStream(f);){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(in);
                        Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                        reader.dispose();
                        return dimension;
                    }
                    catch (Throwable throwable) {
                        reader.dispose();
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void centerOnParent(Window child, boolean absolute) {
        int y;
        int x;
        child.pack();
        boolean useChildsOwner = child.getOwner() != null ? child.getOwner() instanceof JFrame || child.getOwner() instanceof JDialog : false;
        java.awt.Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension parentSize = useChildsOwner ? child.getOwner().getSize() : screenSize;
        Point parentLocationOnScreen = useChildsOwner ? child.getOwner().getLocationOnScreen() : new Point(0, 0);
        java.awt.Dimension childSize = child.getSize();
        childSize.width = Math.min(childSize.width, screenSize.width);
        childSize.height = Math.min(childSize.height, screenSize.height);
        child.setSize(childSize);
        if (child.getOwner() != null && child.getOwner().isShowing()) {
            x = (parentSize.width - childSize.width) / 2;
            y = (parentSize.height - childSize.height) / 2;
            x += parentLocationOnScreen.x;
            y += parentLocationOnScreen.y;
        } else {
            x = (screenSize.width - childSize.width) / 2;
            y = (screenSize.height - childSize.height) / 2;
        }
        if (!absolute) {
            x /= 2;
            y /= 2;
        }
        child.setLocation(x, y);
    }

    public static String recode(String codeFrom, String codeTo, String s) {
        Charset chsFrom = Charset.forName(codeFrom);
        Charset chsTo = Charset.forName(codeTo);
        ByteBuffer bb = chsFrom.encode(s);
        CharBuffer cb = chsTo.decode(bb);
        return cb.toString();
    }

    public static byte[] compress(String s) {
        byte[] result = null;
        try {
            byte[] bytesUTF8 = s.getBytes("UTF-8");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipOut = new GZIPOutputStream(baos);
            zipOut.write(bytesUTF8);
            zipOut.close();
            result = baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String compressToString(String s) {
        return new String(Util.compress(s));
    }

    public static String decompress(byte[] compressedBytes) {
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPInputStream zipIn = new GZIPInputStream(new ByteArrayInputStream(compressedBytes));
            byte[] buffer = new byte[256];
            int bytesRead = zipIn.read(buffer);
            while (bytesRead != -1) {
                baos.write(buffer, 0, bytesRead);
                bytesRead = zipIn.read(buffer);
            }
            result = new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return result;
    }

    public static String decompressFromString(String s) {
        return Util.decompress(s.getBytes());
    }

    public static byte[] deflate(String s) {
        Deflater compresser = new Deflater();
        byte[] output = new byte[s.length() * 2];
        try {
            compresser.setInput(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            return new byte[0];
        }
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        compresser.end();
        byte[] compressedBytes = new byte[compressedDataLength];
        for (int ii = 0; ii < compressedDataLength; ++ii) {
            compressedBytes[ii] = output[ii];
        }
        return compressedBytes;
    }

    public static String inflate(byte[] bytes) {
        int resultLength;
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Inflater decompresser = new Inflater();
        decompresser.setInput(bytes, 0, bytes.length);
        byte[] result = new byte[bytes.length * 10];
        try {
            resultLength = decompresser.inflate(result);
        }
        catch (DataFormatException ex) {
            return "";
        }
        decompresser.end();
        String resultString = "";
        try {
            resultString = new String(result, 0, resultLength, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        return resultString;
    }

    public static String uriEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            return s;
        }
    }

    public static BufferedImage resizeImageOnLongSide(BufferedImage img, int newW) {
        if (img.getWidth() > img.getHeight()) {
            return Util.resizeImage(img, newW, 0);
        }
        return Util.resizeImage(img, 0, newW);
    }

    public static BufferedImage resizeImage(BufferedImage img, int newW) {
        return Util.resizeImage(img, newW, 0);
    }

    public static BufferedImage resizeImage(BufferedImage img, int newW, int newH) {
        return Util.resizeImage(img, newW, newH, 1);
    }

    public static BufferedImage resizeImage(URL u, int newW, int newH, int imageType) {
        try {
            BufferedImage bi = ImageIO.read(u);
            return Util.resizeImage(bi, newW, newH, imageType);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static BufferedImage resizeImage(BufferedImage img, int newW, int newH, int imageType) {
        return Util.resizeImage(img, newW, newH, imageType, true);
    }

    public static BufferedImage resizeImage(BufferedImage img, int newW, int newH, int imageType, boolean allowEnlarge) {
        if (img == null) {
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == 0 || h == 0) {
            return img;
        }
        if (!allowEnlarge && w < newW && h < newH) {
            return img;
        }
        Dimension dimBasedOnWidth = new Dimension(newW, h * newW / w);
        Dimension dimBasedOnHeight = new Dimension(w * newH / h, newH);
        Dimension dim = new Dimension();
        if (newW > 0 && newH > 0) {
            if (dimBasedOnWidth.height > newH) {
                dim.setSize(dimBasedOnHeight);
            } else {
                dim.setSize(dimBasedOnWidth);
            }
        } else if (newW > 0) {
            dim.setSize(dimBasedOnWidth);
        } else if (newH > 0) {
            dim.setSize(dimBasedOnHeight);
        } else {
            return img;
        }
        int type = img.getType();
        BufferedImage resizedImage = new BufferedImage(dim.width, dim.height, imageType);
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, dim.width, dim.height, 0, 0, w, h, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage convertToBufferedImage(Image img, int type) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), type);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static boolean isImageFile(String fn) {
        return (fn = fn.toLowerCase()).endsWith(".jpg") || fn.endsWith(".jpeg") || fn.endsWith(".tiff") || fn.endsWith(".tif") || fn.endsWith(".gif") || fn.endsWith(".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getJPEGDimension(File f) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            if (fis.read() != 255 || fis.read() != 216) {
                Logger.getAnonymousLogger().severe("SOI (Start Of Image) marker 0xff 0xd8 missing");
                Dimension dimension = null;
                return dimension;
            }
            Dimension d = null;
            while (fis.read() == 255) {
                int marker = fis.read();
                int len = fis.read() << 8 | fis.read();
                if (marker == 192) {
                    fis.skip(1L);
                    int height = fis.read() << 8 | fis.read();
                    int width = fis.read() << 8 | fis.read();
                    d = new Dimension(width, height);
                    break;
                }
                fis.skip(len - 2);
            }
            fis.close();
            Dimension dimension = d;
            return dimension;
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static boolean isNumber(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (string.length() >= NUMBER_MAX_LENGTH) {
            try {
                Long.parseLong(string);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            int i = 0;
            if (string.charAt(0) == '-') {
                if (string.length() > 1) {
                    ++i;
                } else {
                    return false;
                }
            }
            while (i < string.length()) {
                if (!Character.isDigit(string.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isInteger(String v) {
        try {
            Integer.parseInt(v);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDouble(String v) {
        if (v == null) {
            return false;
        }
        if (v.toLowerCase().contains("d") || v.toLowerCase().contains("f")) {
            return false;
        }
        try {
            Double.parseDouble(v);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDate(String v) {
        String[] dateFormats;
        for (String df : dateFormats = new String[]{DATETIME_ISO, DATETIME_READ, DATETIME_PRETTY}) {
            SimpleDateFormat f = new SimpleDateFormat(df);
            f.setLenient(true);
            try {
                f.parse(v);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static boolean canWrite(File f) {
        if (f != null && f.isDirectory()) {
            File ff = new File(f, Long.toString(Math.round(Math.random() * 1.0E8)));
            try {
                new FileWriter(ff).close();
                boolean isThere = ff.isFile();
                ff.delete();
                return isThere;
            }
            catch (IOException iOException) {
                ff.delete();
            }
        }
        return false;
    }

    public static void main(String[] args) {
        HashMap<String, String> x = new HashMap<String, String>();
        x.put("a", "aa");
        x.put("x", "xx");
        x.put("c", "cc");
        List<String> asSortedList = Util.asSortedList(x.keySet());
        for (String s : asSortedList) {
            System.out.println(s);
        }
    }

    public static Date toDateOnly(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static int parseInt(String s, int defaultValue) {
        int result = defaultValue;
        if (s == null) {
            return result;
        }
        try {
            result = Integer.parseInt(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long parseLong(String s, long defaultValue) {
        long result = defaultValue;
        try {
            result = Long.parseLong(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static float parseFloat(String s, float defaultValue) {
        float result = defaultValue;
        try {
            result = Float.parseFloat(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static double parseDouble(String s, double defaultValue) {
        double result = defaultValue;
        try {
            result = Double.parseDouble(s.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String toXml(Document doc) {
        if (doc == null) {
            return "";
        }
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8").setTextMode(Format.TextMode.PRESERVE));
        return output.outputString(doc);
    }

    public static String toXml(Element xml) {
        if (xml == null) {
            return "";
        }
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8").setTextMode(Format.TextMode.PRESERVE));
        return output.outputString(xml);
    }

    public static Element fromXml(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xml));
        Element e = doc.getRootElement();
        return e;
    }

    public static Element getXmlElement(Element root, String path, boolean create) throws JDOMException {
        String debugXml = Util.toXml(root);
        StringBuilder sb = new StringBuilder();
        boolean inQuote = false;
        for (int ii = 0; ii < path.length(); ++ii) {
            String c = path.substring(ii, ii + 1);
            if ("'".equals(c)) {
                boolean bl = inQuote = !inQuote;
            }
            if (" ".equals(c) && !inQuote) {
                c = "";
            }
            sb.append(c);
        }
        path = sb.toString();
        Element e = (Element)XPath.selectSingleNode((Object)root, (String)path);
        if (e == null && create) {
            e = root;
            for (String s : path.split("/")) {
                if ("".equals(s) || "themis".equals(s)) continue;
                Element child = e.getChild(s);
                if (child == null) {
                    child = new Element(s);
                    e.addContent((Content)child);
                }
                e = child;
            }
        }
        return e;
    }

    public static String getXmlElementText(Element root, String path, String defaultvalue) {
        try {
            Element e = Util.getXmlElement(root, path, false);
            return e == null ? defaultvalue : e.getText();
        }
        catch (JDOMException jDOMException) {
            return defaultvalue;
        }
    }

    public static String getXmlAttribute(Element root, String path, String defaultvalue) throws JDOMException {
        Object att = XPath.selectSingleNode((Object)root, (String)(path = path.replaceAll(" ", "")));
        if (att == null) {
            return defaultvalue;
        }
        if (att instanceof Attribute) {
            return ((Attribute)att).getValue();
        }
        return defaultvalue;
    }

    public static boolean hasStringValue(String s) {
        return s != null && !"".equals(s);
    }

    public static ArrayList<File> getFiles(File importFolder, String ext, boolean includeSubfolder) {
        ArrayList<File> files = new ArrayList<File>();
        if (importFolder == null || !importFolder.isDirectory()) {
            return files;
        }
        for (File f : importFolder.listFiles()) {
            if (f.isDirectory() && includeSubfolder) {
                files.addAll(Util.getFiles(f, ext, true));
                continue;
            }
            if (ext != null && !f.getName().toLowerCase().endsWith("." + ext.toLowerCase())) continue;
            files.add(f);
        }
        return files;
    }

    public static String toValidFilename(String fn) {
        fn = fn.replaceAll(">", "-");
        fn = fn.replaceAll("<", "-");
        fn = fn.replaceAll(":", "-");
        fn = fn.replaceAll("\"", "");
        fn = fn.replaceAll("\\\\", "-");
        fn = fn.replaceAll("/", "-");
        fn = fn.replaceAll("\\|", "-");
        fn = fn.replaceAll("\\?", "-");
        fn = fn.replaceAll("\\*", "-");
        return fn;
    }

    public static boolean isValidFilename(String fn) {
        return !fn.trim().contains("<") && !fn.trim().contains(">") && !fn.trim().contains(":") && !fn.trim().contains("\"") && !fn.trim().contains("\\\\") && !fn.trim().contains("/") && !fn.trim().contains("|") && !fn.trim().contains("?") && !fn.trim().contains("\\") && !fn.trim().contains("*");
    }

    public static Color getColorFromString(String color) {
        String[] rgb = color.split(",");
        return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    public static String getStringFromColor(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static boolean checkUrlConnection(String url) {
        try {
            URL u = new URL(url);
            u.openConnection();
            u.getContent();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getHostname() {
        String hostname = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static String getJSONString(JSONObject o, String key, String defVal) {
        if (o.has(key)) {
            return o.getString(key);
        }
        return defVal;
    }

    public static int getUrlPort(String url) {
        int idx0 = url.indexOf("://");
        int idx1 = url.indexOf(":", idx0 + 2);
        if (idx1 < 0) {
            return 0;
        }
        int idx2 = url.indexOf("/", idx1);
        String p = idx2 >= 0 ? url.substring(idx1 + 1, idx2) : url.substring(idx1 + 1);
        return Util.parseInt(p, 0);
    }

    public static String getUrlWithoutPort(String url) {
        int idx0 = url.indexOf("://");
        int idx1 = url.indexOf(":", idx0 + 2);
        if (idx1 < 0) {
            return url;
        }
        int idx2 = url.indexOf("/", idx1);
        String url1 = url.substring(0, idx1) + (idx2 >= 0 ? url.substring(idx2) : "");
        return url1;
    }

    public static File getUniqueFile(File folder, String name) {
        int counter = 2;
        File f = new File(folder, name);
        String filename = Util.getFileNameWithoutExtension(f);
        String fileext = Util.getFileExtension(f);
        while (f.exists()) {
            String fn = filename + counter + "." + fileext;
            f = new File(folder, fn);
        }
        return f;
    }
}

