/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.util.List;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class XML {
    public static Logger logger = null;

    public static void setLogger(Logger l) {
        logger = l;
    }

    public static Float getAttributeFloat(Element e, String att) {
        try {
            return Float.valueOf(e.getAttribute(att).getFloatValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Double getAttributeDouble(Element e, String att) {
        try {
            return e.getAttribute(att).getDoubleValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer getAttributeInt(Element e, String att) {
        try {
            return e.getAttribute(att).getIntValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Attribute getXPathAttribute(Element e, String xpath) {
        try {
            Object att = XPath.selectSingleNode((Object)e, (String)xpath);
            if (att == null) {
                return null;
            }
            if (att instanceof Attribute) {
                return (Attribute)att;
            }
            if (logger != null) {
                logger.severe("Error accessing report specification using path '" + xpath + "' - not an attribute");
            }
            return null;
        }
        catch (JDOMException ex) {
            if (logger != null) {
                logger.severe("Error accessing report specification using path '" + xpath + "': " + ex.getMessage());
            }
            ex.printStackTrace();
            return null;
        }
    }

    public static String getXPathAttributeValue(Element e, String xpath) {
        Attribute att = XML.getXPathAttribute(e, xpath);
        if (att == null) {
            return null;
        }
        return att.getValue();
    }

    public static String getXPathAttributeValue(Element e, String xpath, String defaultvalue) {
        String r = XML.getXPathAttributeValue(e, xpath);
        if (r == null) {
            return defaultvalue;
        }
        return r;
    }

    public static Element getXPathElement(Element e, String xpath) {
        try {
            return (Element)XPath.selectSingleNode((Object)e, (String)xpath);
        }
        catch (JDOMException ex) {
            if (logger != null) {
                logger.severe("Error accessing report specification using path '" + xpath + "': " + ex.getMessage());
            }
            ex.printStackTrace();
            return null;
        }
    }

    public static String getXPathElementText(Element e, String xpath) {
        Element ele = XML.getXPathElement(e, xpath);
        if (ele == null) {
            return null;
        }
        return ele.getText();
    }

    public static String getXPathElementText(Element e, String xpath, String defaultvalue) {
        String r = XML.getXPathElementText(e, xpath);
        if (r == null) {
            return defaultvalue;
        }
        return r;
    }

    public static Boolean getXPathElementBoolean(Element e, String xpath) {
        String txt = XML.getXPathElementText(e, xpath);
        return txt == null ? null : Boolean.valueOf("true".equalsIgnoreCase(txt) || "yes".equalsIgnoreCase(txt) || "ja".equalsIgnoreCase(txt) || "1".equalsIgnoreCase(txt));
    }

    public static boolean getXPathElementBoolean(Element e, String xpath, boolean defaultValue) {
        Boolean b = XML.getXPathElementBoolean(e, xpath);
        return b == null ? defaultValue : b;
    }

    public static Integer getXPathElementInt(Element e, String xpath) {
        String txt = XML.getXPathElementText(e, xpath);
        if (txt == null) {
            return null;
        }
        try {
            return Integer.parseInt(txt);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getXPathElementInt(Element e, String xpath, int defaultValue) {
        Integer i = XML.getXPathElementInt(e, xpath);
        return i == null ? defaultValue : i;
    }

    public static Long getXPathElementLong(Element e, String xpath) {
        String txt = XML.getXPathElementText(e, xpath);
        if (txt == null) {
            return null;
        }
        try {
            return Long.parseLong(txt);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static long getXPathElementLong(Element e, String xpath, long defaultValue) {
        Long i = XML.getXPathElementLong(e, xpath);
        return i == null ? defaultValue : i;
    }

    public static List<Element> getXPathElements(Element e, String xpath) {
        try {
            List selectNodes = XPath.selectNodes((Object)e, (String)xpath);
            return selectNodes;
        }
        catch (JDOMException ex) {
            if (logger != null) {
                logger.severe("Error accessing report specification using path '" + xpath + "': " + ex.getMessage());
            }
            ex.printStackTrace();
            return null;
        }
    }

    public static String getXPath(Element e) {
        String xpath = "";
        while (e.getParentElement() != null) {
            e = e.getParentElement();
            xpath = "/" + e.getName() + xpath;
        }
        return xpath;
    }

    public static String getFullXPath(Element e, String xpath) {
        String fullxpath = XML.getXPath(e);
        if (!xpath.startsWith("/")) {
            xpath = "/" + xpath;
        }
        return fullxpath + xpath;
    }

    public static double getXpathDouble(Element wrap, String xpath, double defaultValue) {
        try {
            String s = XML.getXPathAttributeValue(wrap, xpath);
            if (s == null) {
                return defaultValue;
            }
            return Double.parseDouble(s);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

