/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    private static final int BUFFER_SIZE = 4096;

    private static void extractFile(InputStream in, File outdir, String name) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        int count = -1;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    public static void extract(File zipfile, File outdir) {
        try {
            Charset CP866 = Charset.forName("CP866");
            ZipFile zf = new ZipFile(zipfile, CP866);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) {
                    ZipUtils.mkdirs(outdir, name);
                    continue;
                }
                String dir = ZipUtils.dirpart(name);
                if (dir != null) {
                    ZipUtils.mkdirs(outdir, dir);
                }
                ZipUtils.extractFile(zf.getInputStream(entry), outdir, name);
            }
            zf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

