/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util.cli;

import at.grid.util.cli.Action;
import at.grid.util.cli.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;

public abstract class CLIApplication {
    TreeMap<String, Action> actions = new TreeMap();
    HashMap<String, String> actionsAlt = new HashMap();
    private File currentDir = new File("").getAbsoluteFile();

    public CLIApplication() {
        this.registerAction(new DefaultHelpAction(this));
        this.registerAction(new DefaultExitAction(this));
        this.registerAction(new DefaultCDAction(this));
        this.registerAction(new DefaultPWDAction(this));
        this.registerAction(new DefaultDirAction(this));
        this.registerAction(new DefaultRunMacroAction(this));
    }

    public final void registerAction(Action a) {
        this.actions.put(a.getCommand(), a);
        if (a.getCommandAlt() != null) {
            this.actionsAlt.put(a.getCommandAlt(), a.getCommand());
        }
    }

    public Collection<Action> getActions() {
        return this.actions.values();
    }

    public Action getAction(String cmd) {
        return this.actions.get(cmd);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File f) {
        this.currentDir = f;
    }

    public void execute(Command cmd) {
        Action a;
        String action = this.actionsAlt.get(cmd.getAction());
        if (action == null) {
            action = cmd.getAction();
        }
        if ((a = this.actions.get(action)) == null) {
            if (cmd.getSource() != null) {
                cmd.getSource().display("ERROR! Command not found: " + action);
            }
        } else {
            a.executeAction(cmd);
        }
    }

    protected void preExit() {
    }

    private static class DefaultRunMacroAction
    extends Action {
        public DefaultRunMacroAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            int lineNo = 0;
            String filename = cmd.getArgument(0);
            File macroFile = new File(filename);
            if (!macroFile.isFile()) {
                macroFile = new File(this.app.getCurrentDir(), filename);
            }
            String macroFileName = macroFile.getName();
            File macroFileParent = macroFile.getParentFile();
            if (macroFileName.indexOf(".") < 0) {
                macroFileName = macroFileName + ".mc";
            }
            if (!(macroFile = new File(macroFileParent, macroFileName)).exists()) {
                return "Cannot find macro file '" + macroFile.getAbsolutePath() + "'";
            }
            if (!macroFile.isFile()) {
                return "The macro file '" + macroFile.getAbsolutePath() + "' seems to be a directory";
            }
            try {
                String currentLine;
                BufferedReader fr = new BufferedReader(new FileReader(macroFile));
                while ((currentLine = fr.readLine()) != null) {
                    String line = currentLine.trim();
                    ++lineNo;
                    if (line.startsWith("#") || line.equals("")) continue;
                    Command macrocmd = new Command(cmd.getSource(), line);
                    macrocmd.setExclusive(true);
                    cmd.display(line);
                    this.app.execute(macrocmd);
                }
                fr.close();
            }
            catch (IOException except) {
                return "I/O exception in macro file, line " + lineNo + " (" + except.getLocalizedMessage() + ")";
            }
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            if (cmd.countArgs() != 1) {
                return "Insufficient number of arguments.";
            }
            return null;
        }

        @Override
        protected String getUsage() {
            return "RUNMACRO <file>\n  <file> is the macro to be executed";
        }

        @Override
        protected String getDescription() {
            return "Run all commands within the file as macro";
        }

        @Override
        protected String getCommand() {
            return "runmacro";
        }

        @Override
        protected String getCommandAlt() {
            return "rm";
        }
    }

    private static class DefaultDirAction
    extends Action {
        public DefaultDirAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            Object[] list = this.app.getCurrentDir().list();
            for (int ii = 0; ii < list.length; ++ii) {
                list[ii] = new File((String)list[ii]).isDirectory() ? "[dir] " + (String)list[ii] : "      " + (String)list[ii];
            }
            Arrays.sort(list);
            StringBuilder sb = new StringBuilder();
            for (Object s : list) {
                sb.append("  ");
                sb.append((String)s);
                sb.append("\n");
            }
            cmd.display(sb.toString());
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            return null;
        }

        @Override
        protected String getUsage() {
            return "DIR";
        }

        @Override
        protected String getDescription() {
            return "Display content of current directory";
        }

        @Override
        protected String getCommand() {
            return "dir";
        }

        @Override
        protected String getCommandAlt() {
            return "ls";
        }
    }

    private static class DefaultPWDAction
    extends Action {
        public DefaultPWDAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            cmd.display(this.app.getCurrentDir().getAbsolutePath());
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            return null;
        }

        @Override
        protected String getUsage() {
            return "PWD";
        }

        @Override
        protected String getDescription() {
            return "Print the current working directory.";
        }

        @Override
        protected String getCommand() {
            return "pwd";
        }
    }

    private static class DefaultCDAction
    extends Action {
        public DefaultCDAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            String dir = cmd.getArgument(0);
            String newDirString = dir.equals("..") ? this.app.getCurrentDir().getParent() : (dir.indexOf(":") >= 0 || dir.startsWith(File.separator) ? dir : this.app.getCurrentDir().getAbsolutePath() + File.separator + dir);
            File newDir = new File(newDirString);
            if (!newDir.isDirectory()) {
                return "'" + dir + "' is not a valid directory";
            }
            this.app.setCurrentDir(newDir);
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            if (cmd.countArgs() != 1) {
                return "Insufficient number of arguments.";
            }
            return null;
        }

        @Override
        protected String getUsage() {
            return "CD <new_directory>\n  <new_directory> absolute or relative path to the new directory";
        }

        @Override
        protected String getDescription() {
            return "Change the current directory";
        }

        @Override
        protected String getCommand() {
            return "cd";
        }
    }

    private static class DefaultExitAction
    extends Action {
        public DefaultExitAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            this.app.preExit();
            cmd.display("... terminating!");
            System.exit(0);
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            return null;
        }

        @Override
        protected String getUsage() {
            return "EXIT";
        }

        @Override
        protected String getDescription() {
            return "Terminate the application.";
        }

        @Override
        protected String getCommand() {
            return "exit";
        }

        @Override
        protected String getCommandAlt() {
            return "x";
        }
    }

    private static class DefaultHelpAction
    extends Action {
        public DefaultHelpAction(CLIApplication app) {
            super(app);
        }

        @Override
        protected String execute(Command cmd) {
            if (cmd.countArgs() > 0) {
                Action a = this.app.getAction(cmd.getArgument(0));
                if (a == null) {
                    return "No such command: '" + cmd.getArgument(0) + "'";
                }
                cmd.display(a.getCommand().toUpperCase() + (a.getCommandAlt() == null ? "" : " | " + a.getCommandAlt().toUpperCase()) + "\n" + a.getDescription() + "\nUsage: " + a.getUsage());
            } else {
                cmd.display("The following commands are available:");
                for (Action a : this.app.getActions()) {
                    cmd.display(a.getCommand().toUpperCase() + (a.getCommandAlt() == null ? "" : " | " + a.getCommandAlt().toUpperCase()));
                }
            }
            return null;
        }

        @Override
        protected String validate(Command cmd) {
            return null;
        }

        @Override
        protected String getUsage() {
            return "HELP [<command>]\n  <command> Name of the command to be explained";
        }

        @Override
        protected String getDescription() {
            return "Show available commands with a short description or show the usage for a specific command.";
        }

        @Override
        protected String getCommand() {
            return "help";
        }

        @Override
        protected String getCommandAlt() {
            return "h";
        }
    }
}

