/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class ConnectionPool
implements Runnable {
    private String driver;
    private String uri;
    private String user;
    private String password;
    private Properties dbprops;
    private int initialConn;
    private int maximumConn;
    private boolean busyWait;
    private ArrayList<Connection> availableConnections;
    private ArrayList<Connection> busyConnections;
    private boolean connectionPending = false;

    public ConnectionPool(String driver, String uri, String user, String password, int initialConn, int maximumConn, boolean busyWait) throws SQLException, NumberFormatException {
        this.driver = driver;
        this.uri = uri;
        this.user = user;
        this.password = password;
        this.initialConn = initialConn;
        this.maximumConn = maximumConn;
        this.busyWait = busyWait;
        if (this.maximumConn < 1) {
            this.maximumConn = 1;
        }
        if (this.initialConn > this.maximumConn) {
            this.initialConn = this.maximumConn;
        }
        this.initialise();
    }

    public void initialise() throws SQLException {
        this.availableConnections = new ArrayList(this.initialConn);
        this.busyConnections = new ArrayList();
        for (int ii = 0; ii < this.initialConn; ++ii) {
            this.availableConnections.add(this.makeNewConnection());
        }
    }

    public synchronized Connection getConnection(Object requestingObject) throws SQLException {
        return this.getConnection();
    }

    public synchronized Connection getConnection() throws SQLException {
        if (!this.availableConnections.isEmpty()) {
            int lastIndex = this.availableConnections.size() - 1;
            Connection existingConnection = this.availableConnections.get(lastIndex);
            this.availableConnections.remove(lastIndex);
            if (existingConnection.isClosed()) {
                this.notifyAll();
                return this.getConnection(this);
            }
            this.busyConnections.add(existingConnection);
            return existingConnection;
        }
        if (this.totalConnections() < this.maximumConn && !this.connectionPending) {
            this.makeBackgroundConnection();
        } else if (!this.busyWait) {
            throw new SQLException("Connection limit reached");
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Connection connection = this.makeNewConnection();
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.availableConnections.add(connection);
                this.connectionPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void free(Connection con, Object requestingObject) {
        this.free(con);
    }

    public synchronized void free(Connection connection) {
        this.busyConnections.remove(connection);
        this.availableConnections.add(connection);
        this.notifyAll();
    }

    public synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }

    public synchronized void closeAllConnections() {
        this.closeConnections(this.availableConnections);
        this.availableConnections = new ArrayList();
        this.closeConnections(this.busyConnections);
        this.busyConnections = new ArrayList();
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ConnectionPool ");
        sbuf.append(this.uri);
        sbuf.append(" for " + this.user + ": ");
        sbuf.append("used " + this.busyConnections.size());
        sbuf.append(" of " + this.maximumConn);
        return sbuf.toString();
    }

    private void makeBackgroundConnection() {
        this.connectionPending = true;
        try {
            Thread connectThread = new Thread(this);
            connectThread.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    private void closeConnections(ArrayList<Connection> connections) {
        try {
            for (int i = 0; i < connections.size(); ++i) {
                Connection connection = connections.get(i);
                if (connection.isClosed()) continue;
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private synchronized Connection makeNewConnection() throws SQLException {
        try {
            if (this.driver.equalsIgnoreCase("org.apache.derby.jdbc.EmbeddedDriver")) {
                Class.forName(this.driver).newInstance();
            } else {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Can't find class for driver: " + this.driver);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Embedded Apache Derby JDBC driver can't be loaded: " + this.driver);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Embedded Apache Derby JDBC driver can't be loaded: " + this.driver);
        }
        Properties props = new Properties();
        if (this.user != null) {
            props.setProperty("user", this.user);
        }
        if (this.password != null) {
            props.setProperty("password", this.password);
        }
        return DriverManager.getConnection(this.uri, props);
    }
}

