/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util.model;

public abstract class SimulationProgressListener {
    protected int min;
    protected int max;
    protected int progress;
    protected long start;
    private int nextEta;
    int etaCounter;

    public void prepare(int min, int max) {
        this.min = min;
        this.max = max;
        this.progress = min;
        this.start = System.currentTimeMillis();
        this.nextEta = -1;
        this.etaCounter = 0;
        this.progressUpdated();
    }

    public void progressChanged(int progress) {
        this.progress = progress;
        this.progressUpdated();
        if (this.progress >= this.max) {
            this.finished();
        } else {
            this.checkETA();
        }
    }

    public synchronized void increaseProgress() {
        ++this.progress;
        this.progressUpdated();
        if (this.progress >= this.max) {
            this.finished();
        } else {
            this.checkETA();
        }
    }

    private void checkETA() {
        if (this.progress >= this.nextEta + this.min) {
            int steps = (int)(1000.0f * (float)(this.progress - this.min) / (float)(System.currentTimeMillis() - this.start));
            if (steps < 1) {
                steps = 1;
            }
            this.nextEta = this.progress + steps;
            this.etaUpdated(this.calcETA());
        }
    }

    protected long calcETA() {
        return (long)(this.max - this.progress) * (System.currentTimeMillis() - this.start) / (long)(this.progress - this.min);
    }

    public abstract void etaUpdated(long var1);

    public abstract void progressUpdated();

    public abstract void sendMessage(String var1);

    public abstract void finished();
}

