/*
 * Decompiled with CFR 0.152.
 */
package at.grid.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import java.util.logging.Logger;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class DefaultWebDavClient {
    private final String url;
    private final String user;
    private final String pwd;
    private final int port;
    private final Sardine sardine;
    Logger logger = Logger.getAnonymousLogger();

    public DefaultWebDavClient(String url, String user, String pwd, final int port) {
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        this.port = port;
        HttpClientBuilder builder = new HttpClientBuilder(){

            public CloseableHttpClient build() {
                SchemePortResolver spr = httpHost -> port;
                CloseableHttpClient httpclient = HttpClients.custom().useSystemProperties().setSchemePortResolver(spr).build();
                return httpclient;
            }
        };
        this.sardine = new SardineImpl(builder, user, pwd);
    }
}

