/*
 * Decompiled with CFR 0.152.
 */
package at.grid.webdav;

import at.grid.util.Util;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.SardineImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class NextCloudWebDAV {
    private final String shareUrl;
    private final String url;
    private final String user;
    private final String pwd;
    private final Sardine sardine;
    private static Logger logger = Logger.getAnonymousLogger();

    public NextCloudWebDAV(String url, String user, String pwd) {
        this(null, url, user, pwd);
    }

    public NextCloudWebDAV(String shareUrl, String url, String user, String pwd) {
        this.shareUrl = shareUrl;
        this.user = user;
        this.pwd = pwd;
        this.url = url;
        final int port = Util.getUrlPort(url);
        if (port == 0) {
            this.sardine = SardineFactory.begin((String)user, (String)pwd);
        } else {
            HttpClientBuilder builder = new HttpClientBuilder(){

                public CloseableHttpClient build() {
                    SchemePortResolver spr = httpHost -> port;
                    CloseableHttpClient httpclient = HttpClients.custom().useSystemProperties().setSchemePortResolver(spr).build();
                    return httpclient;
                }
            };
            this.sardine = new SardineImpl(builder, user, pwd);
        }
    }

    public static NextCloudWebDAV fromShareUrl(String shareUrl) throws IllegalArgumentException {
        return NextCloudWebDAV.fromShareUrl(shareUrl, null);
    }

    public static NextCloudWebDAV fromShareUrl(String shareUrl, String pwd) throws IllegalArgumentException {
        if (shareUrl == null || "".equals(shareUrl.trim())) {
            throw new IllegalArgumentException("invalid share url");
        }
        String user = shareUrl.substring(shareUrl.lastIndexOf("/") + 1);
        String url = shareUrl;
        int idx = shareUrl.indexOf("/s/");
        String baseurl = idx > 0 ? shareUrl.substring(0, idx) : shareUrl;
        url = baseurl.toLowerCase().endsWith("/index.php") ? baseurl.substring(0, baseurl.length() - 10) + "/public.php/webdav" : baseurl + "/public.php/webdav";
        return new NextCloudWebDAV(shareUrl, url, user, pwd);
    }

    public void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public boolean checkServerConnection() {
        String checkUrl = this.shareUrl;
        if (checkUrl == null || "".equals(checkUrl.trim())) {
            checkUrl = this.url;
        }
        if (checkUrl == null || "".equals(checkUrl.trim())) {
            logger.info("checking THEMIS server connection ... no URL in server code");
            return false;
        }
        try {
            URL u = new URL(this.url);
            URLConnection c = u.openConnection();
            c.connect();
            logger.info("checking THEMIS server connection ... OK");
            return true;
        }
        catch (IOException ex) {
            logger.severe("checking THEMIS server connection ... no connection available: " + ex.getMessage());
            return false;
        }
    }

    private String getUrlForFolder(String folder) {
        return this.url + (folder == null || "".equals(folder) || ".".equals(folder) ? "" : "/" + folder);
    }

    private String getUrlForFile(String folder, String filename) {
        try {
            String fname = URLEncoder.encode(filename, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
            return this.getUrlForFolder(folder) + "/" + fname;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.getUrlForFolder(folder) + "/" + filename;
        }
    }

    public ArrayList<String> getFilenames(String folder) throws IOException {
        return this.getFilenames(folder, null);
    }

    public ArrayList<String> getFilenames(String folder, String ext) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        String urlForFolder = this.getUrlForFolder(folder);
        if (!urlForFolder.endsWith("/")) {
            urlForFolder = urlForFolder + "/";
        }
        List resources = this.sardine.list(urlForFolder);
        for (int ii = 1; ii < resources.size(); ++ii) {
            String filename = ((DavResource)resources.get(ii)).getName();
            if (ext != null && !filename.toLowerCase().endsWith("." + ext.toLowerCase())) continue;
            names.add(filename);
        }
        return names;
    }

    public boolean hasFile(String folder, String filename) {
        try {
            return this.sardine.exists(this.getUrlForFolder(folder) + "/" + filename);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean hasFolder(String folder) {
        try {
            String f = this.getUrlForFolder(folder);
            logger.info("checking if folder exists (" + f + ")");
            return this.sardine.exists(f + "/");
        }
        catch (IOException ex) {
            logger.warning("checking folder failed (" + ex.getMessage() + ")");
            return false;
        }
    }

    public void createFolder(String ... folders) throws IOException {
        for (String folder : folders) {
            try {
                folder = folder.replace("\\", "/");
                String u = this.getUrlForFolder(folder);
                this.sardine.createDirectory(u + "/");
            }
            catch (SardineException ex) {
                logger.warning("create directory not executed");
            }
        }
    }

    public void deleteFolder(String folder) throws IOException {
        if (this.hasFolder(folder)) {
            String u = this.getUrlForFolder(folder);
            if (!u.endsWith("/")) {
                u = u + "/";
            }
            this.sardine.delete(u);
        }
    }

    public void deleteFolderContent(String folder) throws IOException {
        if (this.hasFolder(folder)) {
            this.deleteFolder(folder);
            this.createFolder(folder);
        }
    }

    public void putString(String string, String folder, String filename) throws IOException {
        this.putFile(string.getBytes(StandardCharsets.UTF_8), folder, filename);
    }

    public void putStringAsZip(String string, String folder, String filename) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        this.putFileAsZip(is, folder, filename);
    }

    public void putFile(String folder, File file) throws IOException {
        this.putFile(FileUtils.readFileToByteArray((File)file), folder, file.getName());
    }

    public void putFile(String folder, File file, String filename) throws IOException {
        if (filename == null || "".equals(filename)) {
            filename = file.getName();
        }
        this.putFile(FileUtils.readFileToByteArray((File)file), folder, filename);
    }

    public void putFile(byte[] data, String folder, String filename) throws IOException {
        String u = this.getUrlForFile(folder, filename);
        if (this.sardine.exists(u)) {
            this.sardine.delete(u);
        }
        if (folder != null) {
            this.createFolder(folder);
        }
        this.sardine.put(u, data);
    }

    public void putFileAsZip(String folder, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        this.putFileAsZip(fis, folder, file.getName());
        NextCloudWebDAV.closeStream(fis);
    }

    public void putFileAsZip(InputStream is, String folder, String filename) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        String u = this.getUrlForFile(folder, filename);
        this.sardine.put(u, (InputStream)zis);
        NextCloudWebDAV.closeStream(zis);
        NextCloudWebDAV.closeStream(is);
    }

    public InputStream getFile(String folder, String filename) throws IOException {
        String u = this.getUrlForFile(folder, filename);
        return this.sardine.get(u);
    }

    public void getFile(String folder, String filename, File targetfile) throws IOException {
        InputStream is = this.getFile(folder, filename);
        targetfile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(targetfile);
        this.copy(is, os);
        NextCloudWebDAV.closeStream(is);
        NextCloudWebDAV.closeStream(os);
    }

    public String getString(String folder, String filename) throws IOException {
        InputStream is = this.getFile(folder, filename);
        String text = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        NextCloudWebDAV.closeStream(is);
        return text;
    }

    public void deleteFile(String folder, String filename) throws IOException {
        String u = this.getUrlForFile(folder, filename);
        this.sardine.delete(u);
    }

    public void deleteFolder(String folder, String foldername) throws IOException {
        String u = this.getUrlForFile(folder, foldername);
        this.sardine.delete(u + "/");
    }

    public void moveFile(String folder, String filename, String newFolder) throws IOException {
        String u1 = this.getUrlForFile(folder, filename);
        String u2 = this.getUrlForFile(newFolder, filename);
        this.sardine.move(u1, u2);
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[32768];
        long totallen = 0L;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
            totallen += (long)len;
        }
        NextCloudWebDAV.closeStream(in);
        NextCloudWebDAV.closeStream(out);
        return totallen;
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getShareUrl() {
        return this.shareUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getType() {
        return this.shareUrl == null ? "apache" : "nextcloud";
    }
}

