/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.tools.webdavutils;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class NextcloudWebdav {
    String public_webdav_url = "https://cloud.grid-it.at/public.php/webdav";
    String anonymous_pwd = "anonymous";
    public static final String VERSION = "3";
    Logger logger = Logger.getGlobal();

    public NextcloudWebdav() {
    }

    public NextcloudWebdav(String url) {
        this.public_webdav_url = url;
    }

    public NextcloudWebdav setLogger(Logger l) {
        this.logger = l;
        return this;
    }

    public void setWebdavUrlFromPublicShare(String shareUrl) {
        int idx = shareUrl.indexOf("/s/");
        String baseurl = shareUrl.substring(0, idx);
        this.public_webdav_url = baseurl.toLowerCase().endsWith("/index.php") ? shareUrl.substring(0, idx - 10) + "/public.php/webdav" : shareUrl.substring(0, idx) + "/public.php/webdav";
    }

    public void setUrl(String url) {
        this.public_webdav_url = url;
    }

    public String getPublicWebdavUrl() {
        return this.public_webdav_url;
    }

    public ArrayList<String> getFilenames(String user) throws IOException {
        return this.getFilenames(user, this.anonymous_pwd);
    }

    public ArrayList<String> getFilenames(String user, String pwd) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        Sardine sardine = SardineFactory.begin();
        sardine.setCredentials(user, pwd);
        List<DavResource> resources = sardine.list(this.public_webdav_url);
        for (int ii = 1; ii < resources.size(); ++ii) {
            names.add(resources.get(ii).getName());
        }
        return names;
    }

    public boolean checkFileExists(String filename, String user) throws IOException {
        return this.checkFileExists(filename, user, this.anonymous_pwd);
    }

    public boolean checkFileExists(String filename, String user, String pwd) throws IOException {
        return this.getFilenames(user, pwd).contains(filename);
    }

    public void putFile(File f, String user) throws IOException {
        this.putFile(f, user, this.anonymous_pwd);
    }

    public void putFile(File f, String user, String pwd) throws IOException {
        Sardine sardine = SardineFactory.begin();
        sardine.setCredentials(user, pwd);
        byte[] data = FileUtils.readFileToByteArray(f);
        String fname = URLEncoder.encode(f.getName(), StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
        sardine.put(this.public_webdav_url + "/" + fname, data);
    }

    public void getFile(String filename, String user, File targetfile) throws IOException, URISyntaxException {
        this.getFile(filename, user, this.anonymous_pwd, targetfile);
    }

    public void getFile(String filename, String user, String pwd, File targetfile) throws IOException, URISyntaxException {
        if (pwd == null) {
            pwd = this.anonymous_pwd;
        }
        Sardine sardine = SardineFactory.begin();
        sardine.setCredentials(user, pwd);
        InputStream is = sardine.get(this.getEncodedURI(this.public_webdav_url + "/" + filename));
        targetfile.getAbsoluteFile().getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(targetfile);
        this.copy(is, os);
    }

    public void deleteFile(String filename, String user) throws IOException, MalformedURLException, URISyntaxException {
        this.deleteFile(filename, user, this.anonymous_pwd);
    }

    public void deleteFile(String filename, String user, String pwd) throws IOException, MalformedURLException, URISyntaxException {
        Sardine sardine = SardineFactory.begin();
        sardine.setCredentials(user, pwd);
        sardine.delete(this.getEncodedURI(this.public_webdav_url + "/" + filename));
    }

    private String getEncodedURI(String s) throws MalformedURLException, URISyntaxException {
        URL url = new URL(s);
        URI u = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
        return u.toString();
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[32768];
        long totallen = 0L;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
            totallen += (long)len;
        }
        NextcloudWebdav.closeStream(in);
        NextcloudWebdav.closeStream(out);
        return totallen;
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

