/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ImageMetadataReader {
    private static final int JPEG_FILE_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final int PSD_MAGIC_NUMBER = 14402;

    @NotNull
    public static Metadata readMetadata(@NotNull BufferedInputStream bufferedInputStream, boolean bl) throws ImageProcessingException, IOException {
        int n = ImageMetadataReader.readMagicNumber(bufferedInputStream);
        return ImageMetadataReader.readMetadata(bufferedInputStream, null, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            n = ImageMetadataReader.readMagicNumber(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return ImageMetadataReader.readMetadata(null, file, n, false);
    }

    @NotNull
    private static Metadata readMetadata(@Nullable BufferedInputStream bufferedInputStream, @Nullable File file, int n, boolean bl) throws ImageProcessingException, IOException {
        assert (file != null ^ bufferedInputStream != null);
        if ((n & 0xFFD8) == 65496) {
            if (bufferedInputStream != null) {
                return JpegMetadataReader.readMetadata(bufferedInputStream, bl);
            }
            return JpegMetadataReader.readMetadata(file);
        }
        if (n == 18761 || n == 19789) {
            if (bufferedInputStream != null) {
                return TiffMetadataReader.readMetadata(bufferedInputStream, bl);
            }
            return TiffMetadataReader.readMetadata(file);
        }
        if (n == 14402) {
            if (bufferedInputStream != null) {
                return PsdMetadataReader.readMetadata(bufferedInputStream, bl);
            }
            return PsdMetadataReader.readMetadata(file);
        }
        throw new ImageProcessingException("File format is not supported");
    }

    private static int readMagicNumber(@NotNull BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(2);
        int n = bufferedInputStream.read() << 8 | bufferedInputStream.read();
        bufferedInputStream.reset();
        return n;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] stringArray) throws MetadataException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = arrayList.remove("/thumb");
        boolean bl2 = arrayList.remove("/wiki");
        if (arrayList.size() < 1) {
            System.out.println("Usage: java -jar metadata-extractor-a.b.c.jar <filename> [<filename>] [/thumb] [/wiki]");
            System.exit(1);
        }
        for (String string : arrayList) {
            String string2;
            Object object;
            long l = System.nanoTime();
            File file = new File(string);
            if (!bl2 && arrayList.size() > 1) {
                System.out.println("***** PROCESSING: " + string);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            long l2 = System.nanoTime() - l;
            if (!bl2) {
                System.out.println("Processed " + (double)file.length() / 1048576.0 + "MB file in " + (double)l2 / 1000000.0 + "ms");
            }
            if (bl2) {
                object = file.getName();
                String string3 = ((String)object).replace(" ", "%20");
                Iterator<String> iterator = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
                String string4 = ImageMetadataReader.escapeForWiki(((Directory)((Object)iterator)).getString(271));
                string2 = ImageMetadataReader.escapeForWiki(((Directory)((Object)iterator)).getString(272));
                System.out.println();
                System.out.println("-----");
                System.out.println();
                System.out.printf("= %s - %s =%n", string4, string2);
                System.out.println();
                System.out.printf("<a href=\"http://metadata-extractor.googlecode.com/svn/sample-images/%s\">%n", string3);
                System.out.printf("<img src=\"http://metadata-extractor.googlecode.com/svn/sample-images/%s\" width=\"300\"/><br/>%n", string3);
                System.out.println((String)object);
                System.out.println("</a>");
                System.out.println();
                System.out.println("|| *Directory* || *Tag Id* || *Tag Name* || *Tag Description* ||");
            }
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    string2 = tag.getTagName();
                    String string5 = directory.getName();
                    String string6 = tag.getDescription();
                    if (bl2) {
                        System.out.printf("||%s||0x%s||%s||%s||%n", ImageMetadataReader.escapeForWiki(string5), Integer.toHexString(tag.getTagType()), ImageMetadataReader.escapeForWiki(string2), ImageMetadataReader.escapeForWiki(string6));
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", string5, string2, string6);
                }
                for (String string7 : directory.getErrors()) {
                    System.err.println("ERROR: " + string7);
                }
            }
            if (stringArray.length <= 1 || !bl) continue;
            object = metadata.getDirectory(ExifThumbnailDirectory.class);
            if (object != null && ((ExifThumbnailDirectory)object).hasThumbnailData()) {
                System.out.println("Writing thumbnail...");
                ((ExifThumbnailDirectory)object).writeThumbnail(stringArray[0].trim() + ".thumb.jpg");
                continue;
            }
            System.out.println("No thumbnail data exists in this image");
        }
    }

    @Nullable
    private static String escapeForWiki(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.replaceAll("(\\W|^)(([A-Z][a-z0-9]+){2,})", "$1!$2")) != null && string.length() > 120) {
            string = string.substring(0, 120) + "...";
        }
        if (string != null) {
            string = string.replace("[", "`[`").replace("]", "`]`").replace("<", "`<`").replace(">", "`>`");
        }
        return string;
    }
}

