/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms;

import at.grid.cms.OntologyFileAccess;
import at.grid.cms.OntologyFileAccessImpl;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.content.ElementCache;
import at.grid.cms.content.Keytable;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsGroup;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.DataStorage;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.user.AuthenticationModule;
import at.grid.cms.user.LDAPAuthentication;
import at.grid.cms.user.LocalAuthentication;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpSession;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CmsApplication {
    public static String version = "v3.2.1, 09.01.2017";
    private Properties props;
    private HashMap<String, Keytable> keytables = new HashMap();
    private HashMap<String, CmsElement> elementtypes = new HashMap();
    private Document config;
    private DataStorage storage;
    protected static List<LogRecord> logs = new ArrayList<LogRecord>();
    private File currentDir = new File("");
    private AuthenticationModule authent = new LocalAuthentication();
    private CmsUser adminuser;
    private CmsUser defaultuser;
    protected ElementCache cache;
    public static final String SESSION_USER = "user.currentUser";
    public static final String SESSION_SEARCHOBJECT = "search.object";
    private int updatev38counter = 0;
    private OntologyFileAccess fileAccess = new OntologyFileAccessImpl();
    protected Logger logger;

    public CmsApplication() {
    }

    public CmsApplication(Properties props) throws SQLException {
        this.initialise(props);
    }

    public CmsApplication(Properties props, boolean dbcheck) throws SQLException {
        this.initialise(props, this.getConfigurationInputStream(props), dbcheck);
    }

    protected void preInitialiseElements(List<Element> ets) {
    }

    protected InputStream getConfigurationInputStream() throws IOException {
        return null;
    }

    protected InputStream getConfigurationInputStream(Properties props) {
        return this.getConfigurationInputStream(props.getProperty("conf.elementtypes"));
    }

    protected InputStream getConfigurationInputStream(String configurl) {
        File f;
        InputStream is = null;
        try {
            is = this.getConfigurationInputStream();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Could not open Inputstream from method getConfigurationInputStream() ");
        }
        if (is == null && configurl != null) {
            try {
                URL urlxml = this.getClass().getResource(configurl);
                if (urlxml != null) {
                    is = urlxml.openStream();
                }
            }
            catch (MalformedURLException ex) {
                this.getLogger().log(Level.WARNING, "Not a valid URL (XML f\u00fcr elementtype definition): " + configurl);
            }
            catch (IOException ex) {
                this.getLogger().log(Level.WARNING, "Could not open Inputstream for : " + configurl);
            }
        }
        if (is == null && configurl != null && (f = new File(configurl)).exists() && f.isFile()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                this.getLogger().log(Level.WARNING, "Could not open Inputstream for : " + this.props.getProperty("conf.elementtypes"));
            }
        }
        if (is == null) {
            this.getLogger().log(Level.WARNING, "No element specification found at '" + this.props.getProperty("conf.elementtypes") + "', aborting!");
        }
        return is;
    }

    public final void reinitialise() throws SQLException {
        this.elementtypes.clear();
        this.keytables.clear();
        this.config = null;
        this.adminuser = null;
        this.defaultuser = null;
        this.storage.close();
        this.initialise(this.createProperties());
    }

    public final void initialise(Properties props) throws SQLException {
        this.initialise(props, this.getConfigurationInputStream(props), true);
    }

    public final void initialise(Properties props, InputStream conf, boolean checkDatabase) throws SQLException {
        this.initialise(props, conf, checkDatabase, null, 0);
    }

    public final boolean initialise(Properties props, InputStream conf, boolean checkDatabase, ProgressHandler ph, int progressStep) throws SQLException {
        return this.initialise(props, conf, checkDatabase, null, ph, progressStep);
    }

    public final boolean initialise(Properties props, InputStream conf, boolean checkDatabase, File traceFile, ProgressHandler ph, int progressStep) throws SQLException {
        boolean success;
        ResourceBundle bundle = ResourceBundle.getBundle("at/grid/cms/Bundle");
        if (ph != null) {
            ph.progress(bundle.getString("project.initializing"), progressStep++);
        }
        this.props = props;
        this.cache = new ElementCache(this);
        if ("ldap".equals(props.getProperty("authent.module"))) {
            LDAPAuthentication auth = new LDAPAuthentication();
            auth.setBase(props.getProperty("authent.module.ldap.base"));
            auth.setUrl(props.getProperty("authent.module.ldap.url"));
            auth.setPort(props.getProperty("authent.module.ldap.port", "389"));
            this.authent = auth;
        } else if ("file".equals(props.getProperty("authent.module"))) {
            // empty if block
        }
        if (conf != null) {
            this.getLogger().info("Trying to read XML from input stream ...");
            SAXBuilder builder = new SAXBuilder();
            try {
                this.config = builder.build(conf);
            }
            catch (JDOMException ex) {
                this.getLogger().severe("ERROR while parsing configuration: " + ex.getMessage());
                this.config = null;
                throw new Error("Application error, unable to continue");
            }
            catch (IOException ex) {
                this.getLogger().severe("ERROR while reading configuration: " + ex.getMessage());
                this.config = null;
                throw new Error("Application error, unable to continue");
            }
            finally {
                Util.closeStream((Closeable)conf);
            }
        } else {
            this.config = null;
            this.getLogger().severe("######### ALERT :  No configuration available !!!!!!!!!!!!!!!");
            throw new Error("Application error, unable to continue");
        }
        String storageclassname = props.getProperty("db.storageclass");
        if (storageclassname == null) {
            this.getLogger().severe("FAILURE: Missing application storage definition [db.storageclass]");
            throw new Error("Application error, unable to continue");
        }
        this.getLogger().fine("Initialising datastorage '" + storageclassname + "'");
        try {
            Constructor<?> con = Class.forName(storageclassname).getConstructor(new Class[0]);
            this.storage = (DataStorage)con.newInstance(new Object[0]);
            this.storage.initialise(this, props);
        }
        catch (Exception ex) {
            this.getLogger().severe("FAILURE: " + ex.getMessage());
            throw new Error("Application error, unable to continue");
        }
        if (ph != null) {
            ph.progress(bundle.getString("project.checking-db"), progressStep++);
        }
        if (!(success = this.getDatastorage().checkAndCreateDatabase(props))) {
            this.getLogger().warning("Database connection NOT established!");
            return false;
        }
        if (ph != null) {
            ph.progress(bundle.getString("project.creating-tables"), progressStep++);
        }
        this.getDatastorage().createDatabaseBaseTables();
        this.createLanguages();
        this.getKeytable("permissionlevel");
        this.getKeytable("workflowstatus");
        this.getKeytable("uploaddetail");
        this.createSystemElementtypes();
        this.getDatastorage().createDatabaseElementTables("user,group".split(","));
        this.getDatastorage().updateDatabaseTables();
        this.getLogger().fine("Checking for system users ...");
        if (this.getDatastorage().checkUser("_admin") < 0L) {
            this.getDatastorage().createSystemUsers("_admin");
            this.getLogger().fine("System user '_admin' created");
        }
        if (this.getDatastorage().checkUser("_removed") < 0L) {
            this.getDatastorage().createSystemUsers("_removed");
            this.getLogger().fine("System user '_removed' created");
        }
        this.getAdminUser();
        CmsUser defaultUser = (CmsUser)this.createElement(-1L, "user", this.getAdminUser());
        if (ph != null) {
            ph.progress(bundle.getString("project.initializing-elements"), progressStep++);
        }
        List ets = this.getConfig().getRootElement().getChild("elementtypes").getChildren("elementtype");
        this.preInitialiseElements(ets);
        CmsElement ele = null;
        for (Element et : ets) {
            String elementtype = et.getAttributeValue("code");
            if (!this.hasElementtype(elementtype)) {
                this.getLogger().info("Registering and initialising elementtype '" + elementtype + "'");
                String classname = et.getAttributeValue("class");
                if (classname == null) {
                    classname = "at.grid.cms.element.CmsElement";
                }
                try {
                    ele = (CmsElement)Class.forName(classname).newInstance();
                    ele.initialise(this, defaultUser, new Long(-1L), et);
                }
                catch (ClassNotFoundException ex) {
                    this.getLogger().severe("Class '" + et.getAttributeValue("class") + "' not found, check configuration");
                }
                catch (InstantiationException ex) {
                    this.getLogger().severe("Class '" + et.getAttributeValue("class") + "' could not be instantiated");
                }
                catch (IllegalAccessException ex) {
                    this.getLogger().severe("Empty constructor for class '" + et.getAttributeValue("class") + "' could not be accessed");
                }
                if (ele == null) continue;
                this.addElementtype(ele.getElementcode(), ele);
                continue;
            }
            ele = this.getDefaultElement(elementtype);
            this.getLogger().fine("Elementtype '" + elementtype + "' already registered, checking initialisation ...");
            if (!ele.isInitialised()) {
                ele.initialise(this, this.getDefaultUser(), -1L, et);
            }
            for (KeyAttribute att : ele.getKeyAttributes()) {
                att.getKeytable().verify();
                att.getKeytable().load();
            }
            this.getLogger().fine("Elementtype '" + elementtype + "', adding attributes ...");
            ele.initialiseFurtherAttributes(et);
            this.elementtypes.put(elementtype, ele);
        }
        this.getDatastorage().createDatabaseElementTables(this.getElementtypes());
        try {
            this.postCreateTables();
        }
        catch (SQLException ex) {
            this.getLogger().severe("Error while executing postCreateTables: " + ex.getMessage());
        }
        if (ph != null) {
            ph.progress(bundle.getString("project.updating-db"), progressStep++);
        }
        this.updateApplicationDatabase(ph, progressStep);
        return true;
    }

    private void createSystemElementtypes() {
        this.getLogger().fine("Registering and initialising elementtype 'user'");
        CmsUser u = new CmsUser();
        u.initialise(this, u, null);
        this.addElementtype("user", u);
        this.getLogger().fine("Registering and initialising elementtype 'group'");
        CmsGroup g = new CmsGroup();
        g.initialise(this, u, null);
        this.addElementtype("group", g);
    }

    protected void updateApplicationDatabase(ProgressHandler ph, int progressStep) {
    }

    protected String getPropertiesLocation() {
        return "gridontology.properties";
    }

    protected Properties createProperties() {
        Properties p = new Properties();
        String url = this.getPropertiesLocation();
        try {
            this.getLogger().info("Loading properties from " + url.toString());
            p.load(CmsApplication.class.getResourceAsStream(url));
        }
        catch (IOException ex) {
            this.getLogger().severe("Cannot access properties at " + url + ", " + ex.getMessage());
        }
        return p;
    }

    public static String getCmsVersion() {
        return version;
    }

    public String getVersion() {
        return "(no version)";
    }

    public OntologyFileAccess getFileAccess() {
        return this.fileAccess;
    }

    public void setFileAccess(OntologyFileAccess ofa) {
        this.fileAccess = ofa;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String prop, String defaultValue) {
        return this.props.getProperty(prop, defaultValue);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public Document getConfig() {
        return this.config;
    }

    public String getSRS() {
        return this.getProperty("geo.srs", "");
    }

    public boolean isMultilingual() {
        return "true".equalsIgnoreCase(this.getProperty("conf.multilingual", "false"));
    }

    public boolean supportWorkflow() {
        return "true".equalsIgnoreCase(this.getProperty("conf.workflow", "false"));
    }

    public boolean isShowMetadata() {
        return "true".equalsIgnoreCase(this.getProperty("conf.showmeta", "true"));
    }

    public boolean isKeepElementHistory() {
        return "true".equalsIgnoreCase(this.getProperty("conf.elementhistory", "false"));
    }

    public String getProjectCode() {
        return this.getProperty("conf.projectcode", this.getClass().getSimpleName());
    }

    public int getApplicationVersion() {
        return Integer.parseInt(this.getProperty("conf.applicationversion", "0"));
    }

    public int getAppliationDatabaseVersion() {
        return Integer.parseInt(this.getProperty("conf.databaseversion", "0"));
    }

    public ArrayList<String> getLanguages() {
        ArrayList<String> langs = new ArrayList<String>();
        for (String l : this.getProperty("conf.languages", "de").split(",")) {
            langs.add(l);
        }
        return langs;
    }

    public String getPrimaryLang() {
        return this.getProperty("conf.primarylang", "de");
    }

    public String getResourceUrl() {
        String url = this.getProperty("web.resourceurl", "/media/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public String getServletUrl() {
        String url = this.getProperty("web.servleturl", "/" + this.getProjectCode() + "/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getProperty("conf.timezone", "GMT+1"));
    }

    public Properties getDefaultUserSettings() {
        Properties p = new Properties();
        for (String key : this.getProperties().stringPropertyNames()) {
            if (!key.startsWith("user.")) continue;
            p.setProperty(key, this.getProperty(key, ""));
        }
        return p;
    }

    public AuthenticationModule getAuthenticationModule() {
        return this.authent;
    }

    public CmsUser getAdminUser() {
        if (this.adminuser == null) {
            long userid = this.getDatastorage().checkUser("_admin");
            this.adminuser = new CmsUser();
            this.adminuser.initialise(this, this.adminuser, null);
            this.adminuser.getBooleanAttribute("superadmin").setValue(true);
            this.adminuser.setAuthenticated(true);
            this.adminuser.load(userid, this.adminuser);
        }
        return this.adminuser;
    }

    public CmsUser getDefaultUser() {
        if (this.defaultuser == null) {
            this.defaultuser = new CmsUser();
            this.defaultuser.initialise(this, this.defaultuser, null);
            this.defaultuser.getBooleanAttribute("superadmin").setValue(false);
            this.defaultuser.setAuthenticated(true);
            this.defaultuser.setAttributeValue("username", "_default");
        }
        return this.defaultuser;
    }

    public CmsUser createAnonymousUser() {
        CmsUser u = (CmsUser)this.createElementWithoutId("user", this.getAdminUser());
        u.setAnonymous();
        return u;
    }

    public String getResourceText(String code, Locale loc) {
        if (code == null) {
            return "";
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String bundle = "";
        String resourceCode = code;
        String result = null;
        try {
            if (code.startsWith("core.")) {
                resourceCode = code.substring(5);
                bundle = "CORE";
            } else if (code.startsWith("app.")) {
                resourceCode = code.substring(4);
                bundle = "APP";
            } else {
                resourceCode = code;
                bundle = "NONE";
            }
            ResourceBundle b = this.getApplicationResourceBundle(loc);
            if (b != null && b.containsKey(resourceCode)) {
                result = b.getString(resourceCode);
            }
            if (result == null && (b = ResourceBundle.getBundle("at.grid.cms.Bundle", loc)) != null && b.containsKey(resourceCode)) {
                result = b.getString(resourceCode);
            }
            if (result == null) {
                this.getLogger().fine("No such resource in bundle '" + bundle + "': " + resourceCode);
                result = resourceCode;
            }
        }
        catch (MissingResourceException ex) {
            this.getLogger().severe("Exception, no such resource in bundle '" + bundle + "': " + resourceCode);
        }
        return result;
    }

    protected ResourceBundle getApplicationResourceBundle(Locale loc) {
        String name = this.getProperty("conf.bundle", null);
        if (name != null) {
            return ResourceBundle.getBundle(name, loc);
        }
        return null;
    }

    public ArrayList<String> getApplicationResourceKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String et : this.getElementtypes()) {
            for (CmsAttribute att : this.getDefaultElement(et).getDataAttributes()) {
                String val = att.getCode().substring(0, 1).toUpperCase() + att.getCode().substring(1);
                keys.add("attribute." + et + "." + att.getCode() + " = " + val);
            }
        }
        return keys;
    }

    public DataStorage getDatastorage() {
        return this.storage;
    }

    public int getDatabaseVersion() {
        return this.getDatastorage().getDatabaseVersion();
    }

    public void createDatabaseKeytables(Keytable tbl) throws SQLException {
        if ("role".equals(tbl.getCode())) {
            tbl.addTerm(0L, "de", "-");
            tbl.addTerm(1L, "de", "gast");
            tbl.addTerm(2L, "de", "autor");
            if (this.supportWorkflow()) {
                tbl.addTerm(3L, "de", "editor");
            }
            tbl.addTerm(4L, "de", "admin");
            tbl.addName("de", "Benutzerrolle");
        } else if ("permissionlevel".equals(tbl.getCode())) {
            tbl.addTerm(1L, "de", "jeder");
            tbl.addTerm(2L, "de", "angemeldet");
            tbl.addTerm(3L, "de", "gruppe");
            tbl.addTerm(4L, "de", "ersteller");
            tbl.addName("de", "Berechtigungslevel");
        } else if ("workflowstatus".equals(tbl.getCode())) {
            tbl.addTerm(1L, "de", "open");
            tbl.addTerm(4L, "de", "published");
            tbl.addName("de", "Workflowstatus");
        } else if (this.hasConfig()) {
            List ets = this.getConfig().getRootElement().getChild("keytables").getChildren("keytable");
            for (Element et : ets) {
                if (!tbl.getCode().equals(et.getAttributeValue("table"))) continue;
                List items = et.getChildren("item");
                for (Element item : items) {
                    try {
                        tbl.addTerm(item.getAttribute("id").getLongValue(), item.getAttributeValue("lang"), item.getAttributeValue("term"));
                    }
                    catch (DataConversionException ex) {
                        this.getLogger().severe("ERROR while adding keytable term '" + item.getAttributeValue("term") + "' for table '" + tbl.getCode() + "': " + ex.getMessage());
                    }
                }
                items = et.getChildren("name");
                for (Element item : items) {
                    tbl.addName(item.getAttributeValue("lang"), item.getAttributeValue("term"));
                }
            }
        }
        tbl.save();
    }

    public void createLanguages() {
        String languages = this.getProperty("conf.languages", this.getPrimaryLang());
        for (String lang : languages.split(",")) {
            this.createLanguage(lang);
        }
    }

    public void createLanguage(String lang) {
        int nextsort = this.getDatastorage().checkLanguage(lang);
        if (nextsort < 0) {
            this.getLogger().info("Ok, language '" + lang + "' is available");
        } else {
            this.getLogger().info("Language '" + lang + "' is not available, trying to add it ...");
            if (this.getDatastorage().createLanguage(lang, nextsort)) {
                this.getLogger().info("Ok, language '" + lang + "' added");
            }
        }
    }

    public ArrayList<String> postCreateTablesSql() {
        return new ArrayList<String>();
    }

    public void postCreateTables() throws SQLException {
    }

    public Collection<CmsElement> getDefaultElements() {
        return this.elementtypes.values();
    }

    public CmsElement getDefaultElement(String elementtype) {
        CmsElement e = this.elementtypes.get(elementtype);
        if (e == null) {
            throw new IllegalArgumentException("Unknown elementtype '" + elementtype + "'");
        }
        return e;
    }

    public CmsElement createElement(String elementtype, CmsUser u) {
        CmsElement edef = this.getDefaultElement(elementtype);
        CmsElement e = edef.createNewInstance(this, edef.getSpecification(), u);
        e.setDefaultAttributes();
        return e;
    }

    public CmsElement createElement(Document doc, CmsUser u) {
        return this.createElement(doc, u, null);
    }

    public CmsElement createElement(Document doc, CmsUser u, ZipFile zip) {
        return this.createElement(doc, u, zip, false);
    }

    public CmsElement createElement(Document doc, CmsUser u, ZipFile zip, boolean keepId) {
        CmsElement e;
        String et = doc.getRootElement().getChild("meta").getChildText("meta_elementtype");
        long id = Util.parseLong((String)doc.getRootElement().getAttributeValue("id"), (long)-1L);
        String uuid = doc.getRootElement().getAttributeValue("uuid");
        if (!this.hasElementtype(et)) {
            this.getLogger().severe("Unknown elementtype '" + et + "'");
            return null;
        }
        if (keepId && this.getDatastorage().hasElement(id)) {
            this.getLogger().severe("Cannot create element with ID=" + id + " ... is ID is already in use");
            return null;
        }
        CmsElement cmsElement = e = keepId ? this.createElement(id, et, u) : this.createElement(et, u);
        if (e == null) {
            this.getLogger().severe("Cannot create default element for elementtype '" + et + "'");
            return null;
        }
        Date dtCreated = Util.parseDate((String)doc.getRootElement().getChild("meta").getChildText("meta_created"), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone(), null);
        if (dtCreated != null) {
            ((DateAttribute)e.getAttribute("meta_created")).setDate(dtCreated);
        }
        Date dtLastEdit = Util.parseDate((String)doc.getRootElement().getChild("meta").getChildText("meta_lastedit"), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone(), null);
        if (dtCreated != null) {
            ((DateAttribute)e.getAttribute("meta_lastedit")).setDate(dtLastEdit);
        }
        e.update(doc.getRootElement(), zip);
        this.getLogger().info("Element " + e.getElementcode().toUpperCase() + " created from XML, original ID " + e.getOriginalId() + ", new ID " + e.getId() + ": " + e.getTitle());
        return e;
    }

    public CmsElement createElementWithoutId(String elementtype, CmsUser u) {
        CmsElement e = this.getDefaultElement(elementtype).createNewInstance(u, -1L);
        e.setCreation(u);
        e.setDefaultAttributes();
        return e;
    }

    public CmsElement createElement(long idelement, String elementtype, CmsUser u) {
        CmsElement e = this.getDefaultElement(elementtype).createNewInstance(u, idelement);
        e.setCreation(u);
        e.setDefaultAttributes();
        return e;
    }

    public CmsElement createElement(CmsElementSummary ele) {
        CmsElement e = this.createElement(ele.getId(), ele.getElementtype(), ele.getCurrentUser());
        e.setTitle(ele.getTitle());
        e.setMetaAttributeValue("readaccess", Long.toString(ele.getReadAccess()));
        e.setMetaAttributeValue("writeaccess", Long.toString(ele.getWriteAccess()));
        e.setMetaAttributeValue("idgroup", Long.toString(ele.getOwnerId()));
        e.setMetaAttributeValue("iduser", Long.toString(ele.getCreatorId()));
        e.setMetaAttributeValue("lasteditby", Long.toString(ele.getLastEditById()));
        e.setDefaultAttributes();
        return e;
    }

    public CmsElement loadElement(long id, CmsUser user) {
        return this.loadElement(id, user.getCurrentLanguage(), true, user);
    }

    public CmsElement loadElement(UUID uuid, CmsUser user) {
        long id = this.getDatastorage().getElementId(uuid);
        if (id > 0L) {
            return this.loadElement(id, user);
        }
        return null;
    }

    public CmsElement loadElement(long id, String lang, CmsUser user) {
        return this.loadElement(id, lang, true, user);
    }

    public CmsElement loadElement(long id, String lang, boolean full, CmsUser user) {
        String elementtype = this.getElementtypeForElement(id);
        if (elementtype == null) {
            return null;
        }
        if (this.cache != null) {
            return this.getCache().loadElement(id, lang, elementtype, user);
        }
        CmsElement e = this.createElementWithoutId(elementtype, user);
        e.load(id, lang, full, user);
        return e;
    }

    public ElementCache getCache() {
        return this.cache;
    }

    public boolean hasElement(long id) {
        return this.getDatastorage().hasElement(id);
    }

    public ArrayList<String> getElementtypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.elementtypes.keySet()) {
            result.add(s);
        }
        return result;
    }

    public String getElementtypeForElement(long id) {
        return this.getDatastorage().getElementtypeById(id);
    }

    public boolean hasElementtype(String type) {
        return this.elementtypes.containsKey(type);
    }

    public void addElementtype(String elementtypecode, CmsElement element) {
        this.elementtypes.put(elementtypecode, element);
    }

    public synchronized Keytable getKeytable(String keycode) {
        Keytable tbl = this.keytables.get(keycode);
        if (tbl == null) {
            tbl = new Keytable(this, keycode);
            this.keytables.put(keycode, tbl);
        }
        return tbl;
    }

    public HashMap<String, Keytable> getKeytables() {
        return this.keytables;
    }

    public List<String> getKeytableNames() {
        ArrayList<String> list = new ArrayList<String>(this.keytables.keySet());
        Collections.sort(list);
        return list;
    }

    public ArrayList<String> getSystemKeytables() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("role");
        names.add("permissionlevel");
        names.add("workflowstatus");
        return names;
    }

    @Deprecated
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Deprecated
    public void setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
    }

    public File getTempfileLocation() throws IOException {
        String result = this.getProperty("upload.location.temp", null);
        if (result != null) {
            File f = new File(result);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (f.isDirectory()) {
                return f;
            }
            throw new IOException("Temporary folder is a file, should be a folder: " + f.getAbsolutePath());
        }
        throw new IOException("no upload folder specified in configuration");
    }

    public File getFileLocation() throws IOException {
        String result = this.getProperty("upload.location", null);
        if (result != null) {
            File f = new File(result);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!f.exists()) {
                throw new IOException("Upload location does not exist: " + f.getAbsolutePath());
            }
            if (f.isDirectory()) {
                return f;
            }
            throw new IOException("Upload location is a file, should be a folder: " + f.getAbsolutePath());
        }
        throw new IOException("no upload folder specified in configuration");
    }

    public File getFileLocation(String et) throws IOException {
        return new File(this.getFileLocation(), et);
    }

    public File getUploadFile(String elementtype, String filename) throws IOException {
        File fld = this.getFileLocation(elementtype);
        return new File(fld, filename);
    }

    public boolean checkLicense(String server, String ip) {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GridCMS Application:      " + this.getClass().getSimpleName());
        sb.append("\nVersion:                  " + this.getVersion());
        sb.append("\nGRIDontology Version:     " + this.getCmsVersion());
        sb.append("\nProject code:             " + this.getProjectCode());
        return sb.toString();
    }

    public String getElementtypesAsHtmlSelect(String id, String name) {
        HashSet<String> types = new HashSet<String>();
        for (String et : this.getElementtypes()) {
            types.add(et);
        }
        return this.getElementtypesAsHtmlSelect(id, name, types, null);
    }

    public String getElementtypesAsHtmlSelect(String id, String name, Set<String> elementtypes, String style) {
        StringBuffer html = new StringBuffer();
        html.append("<SELECT id=\"").append(id).append("\" ");
        if (style != null && !"".equals(style)) {
            html.append("style=\"").append(style).append("\" ");
        }
        html.append("name=\"").append(name).append("\">");
        for (String et : elementtypes) {
            html.append("<OPTION value=\"" + et + "\">" + et + "</OPTION>");
        }
        html.append("</SELECT>");
        return html.toString();
    }

    public String getElementAsHtmlSelect(String id, String name, String elementtype, ArrayList<String> select, boolean hierarchy, boolean withEmpty, boolean usePathId) {
        return this.getElementAsHtmlSelect(id, name, elementtype, select, hierarchy, withEmpty, usePathId, null, 0);
    }

    public String getElementAsHtmlSelect(String id, String name, String elementtype, ArrayList<String> select, boolean hierarchy, boolean withEmpty, boolean usePathId, String whereclause, int maxwidth) {
        HashSet<String> selects = new HashSet<String>();
        for (String rec : select) {
            if ("".equals(rec)) continue;
            selects.add(rec);
        }
        return this.getElementAsHtmlSelect(id, name, elementtype, selects, hierarchy, withEmpty, usePathId, whereclause, maxwidth);
    }

    public String getElementAsHtmlSelect(String id, String name, String elementtype, Set<String> select, boolean hierarchy, boolean withEmpty, boolean usePathId) {
        return this.getElementAsHtmlSelect(id, name, elementtype, select, hierarchy, withEmpty, usePathId, null, 0);
    }

    public String getElementAsHtmlSelect(String id, String name, String elementtype, Set<String> select, boolean hierarchy, boolean withEmpty, boolean usePathId, String whereclause, int maxwidth) {
        CmsSqlSearch s = new CmsSqlSearch(this, this.adminuser, false);
        CmsElement e = this.getDefaultElement(elementtype);
        if (hierarchy && (e.getAttribute("pathid") == null || e.getAttribute("pathname") == null)) {
            throw new IllegalArgumentException("Elementtype '" + elementtype + "' is not a hierarchy element");
        }
        s.setElementtypes(elementtype);
        s.addSelectMeta();
        if (hierarchy) {
            s.addSelectAttribute(e.getAttribute("pathname"));
            s.addSelectAttribute(e.getAttribute("pathid"));
        }
        if (hierarchy) {
            s.setSort(e.getAttribute("pathname"));
        } else {
            s.setSort("el.title");
        }
        if (whereclause != null) {
            s.addElementJoin(elementtype);
            s.addWhere(whereclause);
        }
        SearchResult result = s.search();
        StringBuilder html = new StringBuilder();
        String style = "";
        if (maxwidth > 0) {
            style = " style=\"max-width: 220px\" ";
        }
        html.append("<SELECT id=\"" + id + "\" name=\"" + name + "\" " + style + ">\n");
        if (withEmpty) {
            html.append("  <OPTION value=\"\">-</OPTION>\n");
        }
        for (DataRecord rec : result.getResult()) {
            String t = rec.getString("meta_title");
            String indent = "";
            if (hierarchy) {
                int level;
                String pathid = rec.getString("pathid");
                if (pathid != null) {
                    String[] xx = pathid.split("\\.");
                    level = xx.length - 1;
                } else {
                    level = 0;
                }
                if (level > 10) {
                    level = 10;
                }
                if (level > 0) {
                    indent = "            ".substring(0, level);
                }
                t = indent + indent + indent + " " + t;
            }
            String htmlvalue = usePathId ? rec.getString("pathid") : rec.getString("meta_id");
            String sel = "";
            if (select.contains(htmlvalue)) {
                sel = " selected=\"selected\"";
            }
            html.append("  <OPTION value=\"" + htmlvalue + "\"" + sel + " >" + t.replace(" ", "&nbsp;") + "</OPTION>\n");
        }
        html.append("</SELECT>");
        return html.toString();
    }

    public static List<LogRecord> getLogs() {
        return logs;
    }

    public static List<LogRecord> getLogs(Level l) {
        ArrayList<LogRecord> result = new ArrayList<LogRecord>();
        for (LogRecord r : logs) {
            if (r.getLevel().intValue() < l.intValue()) continue;
            result.add(r);
        }
        return result;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            CmsApplication appref = this;
            this.logger = Logger.getLogger("GRIDcmsLogger");
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                    Util.getLogger((String)"at.grid.cms").log(record);
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Object getSessionObject(HttpSession session, String code) {
        String k = this.getProjectCode() + "." + code;
        return session.getAttribute(k);
    }

    public void setSessionObject(HttpSession session, String code, Object o) {
        String k = this.getProjectCode() + "." + code;
        session.setAttribute(k, o);
    }

    public boolean syncApplication(CmsApplication app) {
        if (!app.getDatastorage().isConnected()) {
            return false;
        }
        boolean flg = this.preSyncApplication(app);
        if (!flg) {
            return false;
        }
        return this.postSyncApplication(app);
    }

    protected boolean preSyncApplication(CmsApplication app) {
        return true;
    }

    protected boolean postSyncApplication(CmsApplication app) {
        return true;
    }
}

