/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms;

import at.grid.cms.OntologyFileAccess;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OntologyFileAccessImpl
implements OntologyFileAccess {
    private static boolean forceDebug = false;
    private static boolean isConfigRead = false;
    private static String appdataFoldername = null;

    @Override
    public boolean copy(File fromFile, File toFile) {
        try {
            long l2;
            Util.copy((File)fromFile, (File)toFile);
            this.setWritePermission(toFile);
            if (!toFile.exists()) {
                return false;
            }
            if (fromFile.isDirectory()) {
                return toFile.isDirectory();
            }
            long l1 = toFile.length();
            return l1 == (l2 = fromFile.length());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean move(File fromFile, File toFile) {
        boolean ok = fromFile.renameTo(toFile);
        if (!ok) {
            ok = this.copy(fromFile, toFile);
            if (ok) {
                return this.delete(fromFile);
            }
            return false;
        }
        toFile.setWritable(true, false);
        return ok;
    }

    @Override
    public boolean delete(File f) {
        Util.delete((File)f);
        return !f.exists();
    }

    @Override
    public boolean mkdirs(File f) {
        f.mkdirs();
        return f.exists();
    }

    @Override
    public boolean rename(File fromFile, File toFile) {
        return fromFile.renameTo(toFile);
    }

    @Override
    public ArrayList<File> getFileList(File folder) {
        File[] listFiles;
        ArrayList<File> files = new ArrayList<File>();
        if (folder == null || !folder.isDirectory()) {
            return files;
        }
        for (File f : listFiles = folder.listFiles()) {
            files.add(f);
        }
        Collections.sort(files);
        return files;
    }

    @Override
    public OutputStream outputStream(File f) throws FileNotFoundException {
        return new FileOutputStream(f);
    }

    @Override
    public String zipFile(File file, File dumpFileZip) {
        try {
            Path p = Paths.get(file.getAbsolutePath(), new String[0]);
            FileOutputStream fos = new FileOutputStream(dumpFileZip);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry("themis.h2.db"));
            Files.copy(p, zos);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(OntologyFileAccessImpl.class.getName()).log(Level.SEVERE, null, ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "zip error";
            }
            return msg;
        }
    }

    @Override
    public boolean checkWriteAccess(File f) {
        if (f.isDirectory()) {
            String rand = Integer.toString((int)(Math.random() * 1.0E8));
            File ff = new File(f, rand);
            boolean result = false;
            try {
                FileOutputStream os = new FileOutputStream(ff);
                os.close();
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.delete(ff);
            return result;
        }
        if (f.isFile()) {
            return f.canWrite();
        }
        File ff = f.getParentFile();
        if (ff.isDirectory()) {
            return this.checkWriteAccess(ff);
        }
        return false;
    }

    @Override
    public void setHidden(File file, boolean hidden) {
        Path path = file.toPath();
        try {
            Files.setAttribute(path, "dos:hidden", hidden, new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public File getApplicationDataFolder() {
        if (!isConfigRead) {
            OntologyFileAccessImpl.readAppConfig();
        }
        File f = new File(appdataFoldername, "THEMIS");
        f.mkdirs();
        return f;
    }

    @Override
    public void setWritePermission(File f) {
        f.setWritable(true, false);
        f.setExecutable(true, false);
        try {
            Path path = f.toPath();
            UserPrincipal authenticatedUsers = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName("Authenticated Users");
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(authenticatedUsers).setFlags(AclEntryFlag.DIRECTORY_INHERIT, AclEntryFlag.FILE_INHERIT).setPermissions(AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.WRITE_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.EXECUTE, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.READ_NAMED_ATTRS).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void readAppConfig() {
        File f = new File("config.properties");
        String appdata = "system";
        if (f.isFile()) {
            Properties p = new Properties();
            try {
                FileReader fr = new FileReader(f);
                p.load(fr);
                forceDebug = "yes".equalsIgnoreCase(p.getProperty("debug"));
                appdata = p.getProperty("appdata", "system");
                fr.close();
                isConfigRead = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        switch (appdata) {
            case "user": {
                appdataFoldername = System.getenv("APPDATA");
                break;
            }
            case "system": {
                File ff = new File("c:/ProgramData");
                if (ff.isDirectory()) {
                    appdataFoldername = ff.getAbsolutePath();
                    break;
                }
                appdataFoldername = new File("etc").getAbsoluteFile().getAbsolutePath();
                break;
            }
            default: {
                appdataFoldername = appdata;
            }
        }
    }

    public static boolean doForceDebug() {
        if (!isConfigRead) {
            OntologyFileAccessImpl.readAppConfig();
        }
        return forceDebug;
    }
}

