/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import java.util.logging.Level;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class BooleanAttribute
extends CmsAttribute {
    private boolean value = false;

    public BooleanAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((BooleanAttribute)att).value;
    }

    @Override
    public String getValue() {
        return this.value ? "X" : "";
    }

    @Override
    public String getDatabaseValue() {
        String dbvalue = null;
        dbvalue = this.app.getDatastorage().getClass().getName().endsWith("DerbyDatastorage") ? "'" + (this.value ? "t" : "f") + "'" : "'" + (this.value ? "true" : "false") + "'";
        return dbvalue;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public boolean isSet() {
        return this.value;
    }

    @Override
    public void clear() {
        this.value = false;
    }

    @Override
    public void setValue(String value) {
        this.value = value != null && !"".equals(value) && !"-".equalsIgnoreCase(value) && !"nein".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value) && !"f".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value);
    }

    public void setValue(boolean f) {
        this.value = f;
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        try {
            if (this.app.getDatastorage().getClass().getName().endsWith("DerbyDatastorage")) {
                String dbvalue = rs.getString(this.code);
                if (dbvalue.equalsIgnoreCase("f")) {
                    this.value = false;
                } else if (dbvalue.equalsIgnoreCase("t")) {
                    this.value = true;
                }
            } else {
                this.value = rs.getBoolean(this.parent.getElementcode() + this.code, false);
            }
        }
        catch (Exception e) {
            this.value = false;
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public boolean checkValue(String value) {
        return true;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append("<input type=\"hidden\" name=\"" + name + "_checkbox\" value=\"yes\"> ");
        html.append("<input type=\"checkbox\" id=\"cms_" + name + "\" name=\"" + name + "\" ");
        if (this.value) {
            html.append("checked=\"checked\"");
        }
        html.append("/>");
        return html.toString();
    }

    @Override
    public int getType() {
        return 1;
    }
}

