/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public abstract class CmsAttribute {
    protected CmsApplication app;
    protected CmsElement parent;
    protected String code;
    protected boolean multilingual;
    protected String field;
    protected boolean virtual;
    protected boolean readonly;
    protected boolean hidden;
    protected boolean showedit;
    protected boolean showview;
    protected boolean required;
    protected String attributegroup;
    protected HashMap<String, String> customproperties;
    protected boolean metadata = false;
    protected String label = null;
    protected String link = null;
    protected String dbreference = null;
    public static final int BOOLEAN = 1;
    public static final int DATE = 2;
    public static final int FLOAT = 3;
    public static final int GEOLINE = 4;
    public static final int GEOPOINT = 5;
    public static final int GEOPOLY = 6;
    public static final int INTEGER = 7;
    public static final int KEY = 8;
    public static final int LONG = 9;
    public static final int MULTIKEY = 10;
    public static final int TEXT = 12;
    public static final int TEXTAREA = 13;
    public static final int RELATION = 14;
    public static final int UPLOAD = 15;
    public static final int IMAGE = 16;
    public static final int SECTION = 17;
    public static final int BUTTON = 18;
    public static final int GEOPOINTTEXT = 19;
    public static final int COUNTER = 22;

    public CmsAttribute() {
        throw new UnsupportedOperationException("Empty constructor not supported");
    }

    public CmsAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        this.parent = parent;
        this.app = app;
        this.customproperties = new HashMap();
        this.setAttributegroup("main");
        this.initialiseAttribute(xml);
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public void initialiseAttribute(Element xml) {
        this.code = xml.getAttributeValue("code");
        this.field = xml.getAttributeValue("field");
        this.dbreference = xml.getAttributeValue("dbreference");
        this.multilingual = this.checkXmlBoolean(xml, "multilingual");
        this.virtual = this.checkXmlBoolean(xml, "virtual");
        this.hidden = this.checkXmlBoolean(xml, "hidden");
        this.required = this.checkXmlBoolean(xml, "required");
        this.readonly = this.checkXmlBoolean(xml, "readonly");
        String show = xml.getAttributeValue("show");
        if ("edit".equalsIgnoreCase(show)) {
            this.showedit = true;
            this.showview = false;
        } else if ("view".equalsIgnoreCase(show)) {
            this.showedit = false;
            this.showview = true;
        } else if ("none".equalsIgnoreCase(show)) {
            this.showedit = false;
            this.showview = false;
            this.hidden = true;
        } else {
            this.showedit = true;
            this.showview = true;
        }
        if (xml.getAttributeValue("group") != null) {
            this.setAttributegroup(xml.getAttributeValue("group"));
        }
        List atts = xml.getAttributes();
        for (Attribute att : atts) {
            if (!att.getName().startsWith("_")) continue;
            this.customproperties.put(att.getName().substring(1), att.getValue());
        }
    }

    public abstract void copyFrom(CmsAttribute var1);

    public abstract void clear();

    public abstract void setValue(String var1);

    public void setValue(Element jdom) {
        if (jdom == null) {
            this.clear();
        } else {
            this.setValue(jdom.getText());
        }
    }

    public abstract void setValue(DataRecord var1, boolean var2);

    public void readFromDatabase(long idelement) {
        this.app.getDatastorage().loadAttribute(this, idelement);
    }

    public void setMetdata() {
        this.metadata = true;
    }

    public void setParent(CmsElement p) {
        this.parent = p;
    }

    public void setLabel(String lbl) {
        this.label = lbl;
    }

    public abstract String getValue();

    public String getFormattedValue() {
        try {
            if (this.isNumber()) {
                if ("".equals(this.getValue()) || this.getValue() == null) {
                    return "";
                }
                if (this.isOfType(3)) {
                    return NumberFormat.getIntegerInstance(this.parent.getCurrentUser().getCurrentLocale()).format(Double.parseDouble(this.getValue()));
                }
                return NumberFormat.getIntegerInstance(this.parent.getCurrentUser().getCurrentLocale()).format(Long.parseLong(this.getValue()));
            }
            return this.getValue();
        }
        catch (Exception e) {
            return this.getValue();
        }
    }

    public abstract String getDatabaseValue();

    public abstract boolean checkValue(String var1);

    public String getDbreference() {
        return this.dbreference;
    }

    public boolean hasDbreference() {
        return this.dbreference != null;
    }

    public CmsElement getParent() {
        return this.parent;
    }

    public String getCode() {
        return this.code;
    }

    public void setLink(String l) {
        this.link = l;
    }

    public boolean hasLink() {
        return this.link != null;
    }

    public String getLink() {
        return this.link;
    }

    public CmsAttribute forceMultilingual() {
        this.multilingual = true;
        return this;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.metadata) {
            return this.app.getResourceText("core.attribute.meta." + this.getCode(), this.parent.getCurrentUser().getCurrentLocale());
        }
        if (this.getParent().getElementcode().equals("user") || this.getParent().getElementcode().equals("group")) {
            return this.app.getResourceText("core.attribute." + this.parent.getElementcode() + "." + this.getCode(), this.parent.getCurrentUser().getCurrentLocale());
        }
        return this.app.getResourceText("app.attribute." + this.parent.getElementcode() + "." + this.getCode(), this.parent.getCurrentUser().getCurrentLocale());
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public CmsAttribute setVirtual(boolean virtual) {
        this.virtual = virtual;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public CmsAttribute setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public abstract boolean hasValue();

    public boolean isShowEdit() {
        return this.showedit;
    }

    public void setShowEdit(boolean showedit) {
        this.showedit = showedit;
    }

    public boolean isShowView() {
        return this.showview;
    }

    public void setShowView(boolean showview) {
        this.showview = showview;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public CmsAttribute setReadonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public boolean isGeoAttribute() {
        return false;
    }

    public boolean isSqlQuoted() {
        if (this.isOfType(2)) {
            return true;
        }
        if (this.isOfType(12)) {
            return true;
        }
        if (this.isOfType(13)) {
            return true;
        }
        return this.isOfType(1);
    }

    public String getAttributegroup() {
        return this.attributegroup;
    }

    public CmsAttribute setAttributegroup(String attributegroup) {
        this.attributegroup = attributegroup;
        return this;
    }

    public String getCustomProperty(String key) {
        return this.customproperties.get(key);
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    public String getField() {
        return this.field;
    }

    public Element toJDOMElement() {
        return new Element(this.code).setText(this.getValue());
    }

    public String toXML() {
        return Util.toXml((Element)this.toJDOMElement());
    }

    public String toHTMLview(String style, String js) {
        if (this.isHidden() || !this.isShowView()) {
            return "";
        }
        return this.toHTML(this.getHTMLview(js));
    }

    public String toHTMLedit(String style, String js) {
        if (this.isHidden() || !this.isShowEdit()) {
            return "";
        }
        if (this.isReadonly()) {
            return this.toHTML(this.getHTMLview(js));
        }
        return this.toHTML(this.getHTMLedit(this.getCode(), js));
    }

    private String toHTML(String component) {
        StringBuffer html = new StringBuffer();
        String labelclass = "grid_ele_label";
        if (this.isRequired()) {
            labelclass = labelclass + "_required";
        }
        html.append("<tr><td class=\"" + labelclass + "\" valign=\"top\">");
        html.append(this.getLabel());
        html.append("</td><td class=\"grid_ele_value\" valign=\"top\">");
        html.append(component);
        html.append("</td></tr>");
        return html.toString();
    }

    protected String getHTMLview(String js) {
        return this.getFormattedValue();
    }

    protected abstract String getHTMLedit(String var1, String var2);

    public abstract int getType();

    public String getTypeAsString() {
        return this.getClass().getSimpleName().replace("Attribute.java", "");
    }

    public boolean isOfType(int type) {
        return this.getType() == type;
    }

    public boolean isNumber() {
        return this.isOfType(3) || this.isOfType(9) || this.isOfType(22) || this.isOfType(7);
    }

    public boolean isStandardAttribute() {
        return this.isOfType(1) || this.isOfType(2) || this.isOfType(3) || this.isOfType(7) || this.isOfType(8) || this.isOfType(9) || this.isOfType(12) || this.isOfType(13) || this.isOfType(22) || this.isOfType(14) && (((RelationAttribute)this).isSingle() || ((RelationAttribute)this).isSizeOne());
    }

    public boolean isGeometry() {
        return this.isOfType(4) || this.isOfType(5) || this.isOfType(6) || this.isOfType(19);
    }

    protected boolean checkXmlBoolean(Element xml, String code) {
        try {
            if (xml.getAttribute(code) != null && xml.getAttribute(code).getBooleanValue()) {
                return true;
            }
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.getIdentifier() + " = " + this.getValue();
    }

    public boolean equals(CmsAttribute att2) {
        return this.toXML().equals(att2.toXML());
    }

    public String getIdentifier() {
        if (this.parent == null) {
            return this.code;
        }
        return this.parent.getElementcode() + "." + this.code;
    }
}

