/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class DateAttribute
extends CmsAttribute {
    private Date value;
    private String format;

    public DateAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        this.format = xml.getAttributeValue("format");
        if (this.format == null) {
            this.format = Util.DATETIME_READ;
        }
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = att.hasValue() ? new Date(((DateAttribute)att).getDate().getTime()) : null;
    }

    @Override
    public String getValue() {
        return this.value == null ? "" : Util.formatDate((Date)this.value, (String)this.format, (TimeZone)this.app.getTimeZone());
    }

    @Override
    public String getDatabaseValue() {
        return Util.toSqlString((Date)this.value, (TimeZone)this.app.getTimeZone());
    }

    public void setDate(Date dt) {
        this.value = dt == null ? null : new Date(dt.getTime());
    }

    public Date getDate() {
        return this.value;
    }

    public boolean isSet() {
        return this.value != null;
    }

    @Override
    public boolean hasValue() {
        return this.isSet();
    }

    @Override
    public void setValue(String v) {
        if (v == null || "".equals(v)) {
            this.value = null;
            return;
        }
        boolean foundFormat = false;
        String dateFormat = this.format;
        String[] datesplit = v.split("\\.");
        if (datesplit.length == 3 && datesplit[2].length() < 3) {
            dateFormat = Util.DATE_READ_SHORT;
        }
        try {
            this.value = Util.parseDate((String)v, (String)dateFormat, (TimeZone)this.app.getTimeZone());
            foundFormat = true;
        }
        catch (Exception e) {
            this.value = null;
        }
        if (!foundFormat) {
            String[] formats;
            for (String f : formats = new String[]{Util.DATE_READ_SHORT, Util.DATE_READ, Util.DATE_ISO, Util.DATE_FILE, Util.DATETIME_READ, Util.DATETIME_ISO, Util.DATETIME_FILE}) {
                try {
                    this.value = Util.parseDate((String)v, (String)f, (TimeZone)this.app.getTimeZone());
                    foundFormat = true;
                    break;
                }
                catch (Exception e) {
                    this.value = null;
                }
            }
            if (!foundFormat) {
                this.getApplication().getLogger().log(Level.WARNING, "Invalid date '" + v + "', impossible to parse");
            }
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.value = rs.getDate(this.parent.getElementcode() + this.code, this.app.getTimeZone());
    }

    @Override
    public boolean checkValue(String value) {
        try {
            Util.parseDate((String)value, (String)this.format, (TimeZone)this.app.getTimeZone());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        String id = "cms_" + name;
        StringBuilder html = new StringBuilder();
        html.append("<input class=\"date\" id=\"").append(id).append("\" name=\"").append(name).append("\" ");
        html.append("type=\"text\" ");
        html.append("value=\"").append(this.getValue()).append("\" />");
        return html.toString();
    }

    @Override
    public int getType() {
        return 2;
    }

    private String getOptionsOfDatepicker(String currentLanguage) {
        if ("de".equals(currentLanguage)) {
            return "{dateFormat: 'dd.mm.yy' ,monthNames: ['J\u00e4nner','Februar','M\u00e4rz','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'],dayNamesMin: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa']}";
        }
        return "";
    }
}

