/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import java.util.logging.Level;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class FloatAttribute
extends CmsAttribute {
    private Float value;

    public FloatAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((FloatAttribute)att).value;
    }

    @Override
    public String getValue() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public String getDatabaseValue() {
        if (this.value == null) {
            return "null";
        }
        return this.getValue();
    }

    public void setValue(float f) {
        this.value = Float.valueOf(f);
    }

    public float getFloatValue() {
        if (this.value == null) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    @Override
    public void setValue(String value) {
        if ("".equals(value) || value == null) {
            this.value = null;
            return;
        }
        try {
            this.value = Float.valueOf(Float.parseFloat(value));
        }
        catch (Exception e) {
            this.value = null;
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.value = rs.getFloat(this.parent.getElementcode() + this.code);
    }

    @Override
    public boolean checkValue(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append("<input id=\"cms_" + name + "\" name=\"" + name + "\" ");
        html.append("type=\"text\" ");
        html.append("value=\"" + this.getValue() + "\" />");
        return html.toString();
    }

    @Override
    public int getType() {
        return 3;
    }
}

