/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import java.text.DecimalFormat;
import java.util.logging.Level;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class IntegerAttribute
extends CmsAttribute {
    private Integer value;
    private DecimalFormat format = null;

    public IntegerAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        String f = xml.getAttributeValue("format");
        if (f != null) {
            this.format = new DecimalFormat(f);
        }
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((IntegerAttribute)att).value;
    }

    public void setValue(int v) {
        this.value = v;
    }

    @Override
    public String getValue() {
        return this.value == null ? "" : Integer.toString(this.value);
    }

    @Override
    public String getFormattedValue() {
        if (this.format == null) {
            return super.getFormattedValue();
        }
        return this.value == null ? "" : this.format.format(this.value);
    }

    public int getIntValue() {
        if (this.value == null) {
            return 0;
        }
        return this.value;
    }

    public int getValueAsInt() {
        if (this.value == null) {
            return 0;
        }
        return this.value;
    }

    @Override
    public String getDatabaseValue() {
        if (this.value == null) {
            return "null";
        }
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        if ("".equals(value)) {
            this.value = null;
            return;
        }
        try {
            this.value = Integer.parseInt(value);
        }
        catch (Exception e) {
            this.value = null;
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.value = rs.getInt(this.parent.getElementcode() + this.code);
    }

    @Override
    public boolean checkValue(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append("<input id=\"cms_" + name + "\" name=\"" + name + "\" ");
        html.append("type=\"text\" ");
        html.append("value=\"" + this.getValue() + "\" />");
        return html.toString();
    }

    @Override
    public int getType() {
        return 7;
    }
}

