/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.logging.Level;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class KeyAttribute
extends CmsAttribute {
    private long id;
    private String value;
    private Keytable tbl;

    public KeyAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        String tablename = xml.getAttributeValue("table");
        this.tbl = app.getKeytable(tablename);
        this.id = -1L;
        this.value = "";
    }

    public Keytable getKeytable() {
        return this.tbl;
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((KeyAttribute)att).value;
        this.id = ((KeyAttribute)att).id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getDatabaseValue() {
        if (this.id < 0L) {
            return "null";
        }
        return Long.toString(this.id);
    }

    public String getTableCode() {
        return this.tbl.getCode();
    }

    @Override
    public void setValue(String value) {
        try {
            if (value == null || "".equals(value)) {
                this.clear();
            } else if (Util.isNumber((String)value)) {
                this.setValue(Long.parseLong(value));
            } else {
                Keytable keytable = this.getKeytable();
                long id = keytable.getIdByTerm(value, this.getParent().getLang());
                if (id < 0L) {
                    id = keytable.createNewId();
                    keytable.addTerm(id, this.getParent().getLang(), value);
                    keytable.save();
                    this.setValue(id);
                } else {
                    this.setValue(id);
                }
            }
        }
        catch (Exception e) {
            this.clear();
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setTerm(String value, boolean createNew) {
        try {
            if (value == null || "".equals(value)) {
                this.clear();
            } else {
                Keytable keytable = this.getKeytable();
                long id = keytable.getIdByTerm(value, this.getParent().getLang());
                if (id < 0L) {
                    if (createNew) {
                        id = keytable.createNewId();
                        keytable.addTerm(id, this.getParent().getLang(), value);
                        keytable.save();
                        this.setValue(id);
                    }
                } else {
                    this.setValue(id);
                }
            }
        }
        catch (Exception e) {
            this.clear();
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setValue(Element jdom) {
        if (jdom == null) {
            this.clear();
        } else {
            this.setValueByTerm(jdom.getText());
        }
    }

    public void setValue(long v) {
        try {
            if (v < 0L) {
                this.clear();
            } else if (this.tbl.hasId(v, this.parent.getCurrentUser().getCurrentLanguage())) {
                this.id = v;
                this.value = this.tbl.getTerm(this.id, this.parent.getCurrentUser().getCurrentLanguage());
            }
        }
        catch (Exception e) {
            this.clear();
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setValueByTerm(String term) {
        this.setValueByTerm(term, this.parent.getCurrentUser().getCurrentLanguage());
    }

    public void setValueByTerm(String term, String lang) {
        if (term == null || "".equals(term)) {
            this.id = -1L;
            this.value = "";
        } else {
            try {
                this.value = term;
                this.id = this.tbl.getIdByTerm(term, lang);
                if (this.id < 0L) {
                    this.value = "";
                }
            }
            catch (Exception e) {
                this.id = -1L;
                this.value = "";
                this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.id = rs.getLong("id" + this.parent.getElementcode() + this.code, -1L);
        if (this.id >= 0L) {
            this.value = this.tbl.getTerm(this.id, this.parent.getCurrentUser().getCurrentLanguage());
        } else {
            this.id = -1L;
            this.value = "";
        }
    }

    @Override
    public boolean checkValue(String value) {
        try {
            return this.tbl.hasId(Long.parseLong(value), this.parent.getCurrentUser().getCurrentLanguage());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasValue() {
        return this.id >= 0L;
    }

    @Override
    public void clear() {
        this.value = "";
        this.id = -1L;
    }

    public ArrayList<KeytableRecord> getTableValues() {
        return this.tbl.toList(this.parent.getCurrentUser().getCurrentLanguage());
    }

    public KeytableRecord[] getTableValuesArray() {
        ArrayList<KeytableRecord> values = this.tbl.toList(this.parent.getCurrentUser().getCurrentLanguage());
        KeytableRecord[] tags = new KeytableRecord[values.size()];
        for (int ii = 0; ii <= tags.length - 1; ++ii) {
            tags[ii] = values.get(ii);
        }
        return tags;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append(this.tbl.toHTMLselect("cms_" + name, name, 1, this.id, this.parent.getCurrentUser().getCurrentLanguage(), false, !this.isRequired()));
        return html.toString();
    }

    @Override
    public Element toJDOMElement() {
        return new Element(this.code).setText(this.getValue()).setAttribute("id", Long.toString(this.getId()));
    }
}

