/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class LongAttribute
extends CmsAttribute {
    private Long value;

    public LongAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((LongAttribute)att).value;
    }

    @Override
    public String getValue() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public String getDatabaseValue() {
        if (this.value == null || this.hasDbreference() && this.value == 0L) {
            return "null";
        }
        return this.getValue();
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getLong() {
        if (this.value == null) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if ("".equals(value)) {
            this.value = null;
            return;
        }
        try {
            this.value = Long.parseLong(value);
        }
        catch (Exception e) {
            this.value = null;
            this.app.getLogger().severe(e.getMessage());
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.value = rs.getLong(this.parent.getElementcode() + this.code);
    }

    @Override
    public boolean checkValue(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append("<input id=\"cms_" + name + "\" name=\"" + name + "\" ");
        html.append("type=\"text\" ");
        html.append("value=\"" + this.getValue() + "\" />");
        return html.toString();
    }

    @Override
    public int getType() {
        return 9;
    }
}

