/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class MultikeyAttribute
extends CmsAttribute {
    private HashMap<Long, String> values;
    private Keytable tbl;

    public MultikeyAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        this.tbl = app.getKeytable(xml.getAttributeValue("table"));
        this.values = new HashMap();
    }

    public Keytable getKeytable() {
        return this.tbl;
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.clear();
        for (long id : ((MultikeyAttribute)att).values.keySet()) {
            this.add(id, this.values.get(id));
        }
    }

    @Override
    public String getValue() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (String s : this.values.values()) {
            if (!first) {
                result.append(", ");
            }
            result.append(s);
            first = false;
        }
        return result.toString();
    }

    public String[] getValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.values.values()) {
            list.add(s);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public Long[] getIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long k : this.values.keySet()) {
            list.add(k);
        }
        Long[] result = new Long[list.size()];
        list.toArray(result);
        return result;
    }

    public String[] getKeys(String lang) {
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, ArrayList<KeytableRecord>> table = this.tbl.getTable();
        for (KeytableRecord k : table.get(lang)) {
            keys.add(k.term);
        }
        String[] result = new String[keys.size()];
        keys.toArray(result);
        return result;
    }

    @Override
    public String getDatabaseValue() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        result.append("(");
        for (Long s : this.values.keySet()) {
            if (!first) {
                result.append(",");
            }
            result.append(s);
            first = false;
        }
        if (first) {
            result.append("-1");
        }
        result.append(")");
        return result.toString();
    }

    private void add(long id, String value) {
        if (!this.values.containsKey(new Long(id))) {
            this.values.put(new Long(id), value);
        }
    }

    public void addId(long id) {
        if (!this.values.containsKey(new Long(id))) {
            try {
                String term = this.tbl.getTerm(id, this.parent.getCurrentUser().getCurrentLanguage());
                this.add(id, term);
            }
            catch (Exception e) {
                this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), "ID not found in keytable : " + id + " -> nothing added...");
            }
        }
    }

    public void addTerm(String term) {
        try {
            long id = this.tbl.getIdByTerm(term, this.parent.getCurrentUser().getCurrentLanguage());
            this.add(id, term);
        }
        catch (Exception e) {
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), "Term not found in keytable : " + term + " -> nothing added...");
        }
    }

    public void removeId(long id) {
        if (this.values.containsKey(new Long(id))) {
            this.values.remove(id);
        }
    }

    public void removeTerm(String term) {
        try {
            long id = this.tbl.getIdByTerm(term, this.parent.getCurrentUser().getCurrentLanguage());
            this.values.remove(id);
        }
        catch (Exception e) {
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), "Term not found in keytable : " + term + " -> nothing added...");
        }
    }

    public HashMap<Long, String> getRelations() {
        return this.values;
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("This is not supported with MultikeyAttributes. Use addById() or addByTerm() instead");
    }

    public void setValue(ArrayList<String> values) {
        for (String v : values) {
            try {
                this.addId(Long.parseLong(v));
            }
            catch (Exception ex) {
                this.getApplication().getLogger().severe("Cannot add ID " + v);
            }
        }
    }

    public void setValuesByIds(long[] ids) {
        for (long id : ids) {
            if (id < 0L) continue;
            try {
                String value = this.tbl.getTerm(id, this.parent.getCurrentUser().getCurrentLanguage());
                this.add(id, value);
            }
            catch (Exception e) {
                this.getApplication().getLogger().severe("ID not found in keytable: " + id + "  " + e);
            }
        }
    }

    public void setValuesByTerms(String[] terms) {
        this.values.clear();
        for (String term : terms) {
            try {
                long id = this.tbl.getIdByTerm(term, this.parent.getCurrentUser().getCurrentLanguage());
                this.add(id, term);
            }
            catch (Exception e) {
                this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), "Term not found in keytable: '" + term + "'  " + e);
            }
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        String sql = "SELECT tkey" + this.tbl.getCode() + "lng.id" + this.tbl.getCode() + " AS id, " + this.tbl.getCode() + "term AS term FROM tkey" + this.tbl.getCode() + "lng INNER JOIN tkey" + this.tbl.getCode() + "rel ON (tkey" + this.tbl.getCode() + "lng.id" + this.tbl.getCode() + "=tkey" + this.tbl.getCode() + "rel.id" + this.tbl.getCode() + ") WHERE idelement = " + this.parent.getId() + " AND lang='" + this.parent.getLang() + "'";
        SearchResult result = this.app.getDatastorage().executeQuery(sql, true);
        this.clear();
        for (DataRecord rec : result.getResult()) {
            this.add(rec.getLong("id"), rec.getString("term"));
        }
    }

    @Override
    public boolean checkValue(String value) {
        return false;
    }

    @Override
    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public String getTableName() {
        return this.tbl.getCode();
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuffer html = new StringBuffer();
        html.append(this.tbl.toHTMLselect("cms_" + name, name, 5, this.values.keySet(), this.parent.getCurrentUser().getCurrentLanguage(), true, !this.isRequired()));
        return html.toString();
    }

    @Override
    public Element toJDOMElement() {
        Element jdom = new Element(this.code);
        for (Map.Entry<Long, String> e : this.values.entrySet()) {
            jdom.addContent((Content)new Element("entry").setAttribute("id", Long.toString(e.getKey())).setText(e.getValue()));
        }
        return jdom;
    }

    @Override
    public void setValue(Element jdom) {
        this.clear();
        if (jdom != null) {
            String txt;
            List entries = jdom.getChildren("entry");
            for (Element entry : entries) {
                try {
                    this.add(entry.getAttribute("id").getLongValue(), entry.getText());
                }
                catch (DataConversionException ex) {
                    this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), "Error reading from XML : " + entry.toString() + " -> nothing added...");
                }
            }
            if (entries.isEmpty() && (txt = jdom.getText()) != null && !"".equals(txt)) {
                String[] ts;
                for (String t : ts = txt.split(",")) {
                    this.addTerm(t);
                }
            }
        }
    }

    @Override
    public int getType() {
        return 10;
    }
}

