/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.CmsPermission;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class RelationAttribute
extends CmsAttribute {
    public static final int FROM_TO = 1;
    public static final int TO_FROM = 2;
    public static final int INCLUDE_FULL = 1;
    public static final int INCLUDE_SUMMARY = 2;
    public static final int INCLUDE_TITLE = 3;
    public static final int SEARCH_DROPDOWN = 1;
    public static final int SEARCH_KEYWORD = 2;
    public static final int CAT_STANDARD = 1;
    public static final int CAT_SUBELEMENT = 2;
    private ArrayList<CmsElementSummary> elements;
    private HashMap<Long, CmsElement> fullelements;
    private ArrayList<Long> deletedelements = new ArrayList();
    private ArrayList<Long> temporaryElements = new ArrayList();
    private String relationcode;
    private int direction;
    private Set<String> elementtypes = new HashSet<String>();
    private boolean single;
    private String inversefield;
    private int maxsize;
    private int includetype = 3;
    private String table;
    private boolean allowAdd;
    private boolean allowSearch;
    private boolean doDeleteRemoved;
    private boolean doRemoveRemoved;
    private int category;
    private int searchmode;
    private String sqlcondition;
    private String autosort;

    public RelationAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        this.elementtypes.addAll(Arrays.asList(xml.getAttributeValue("elementcodes").split(",")));
        this.relationcode = xml.getAttributeValue("relationcode");
        this.elements = new ArrayList();
        this.fullelements = new HashMap();
        this.direction = 1;
        if (this.checkXmlBoolean(xml, "inverse")) {
            this.direction = 2;
        }
        this.single = this.checkXmlBoolean(xml, "single");
        this.inversefield = xml.getAttributeValue("inversefield");
        this.maxsize = 0;
        if (xml.getAttribute("size") != null) {
            this.maxsize = xml.getAttribute("size").getIntValue();
        }
        this.includetype = 3;
        if ("full".equalsIgnoreCase(xml.getAttributeValue("include"))) {
            this.includetype = 1;
        } else if ("summary".equalsIgnoreCase(xml.getAttributeValue("include"))) {
            this.includetype = 2;
        }
        this.table = "tdtarelation";
        this.allowAdd = "true".equalsIgnoreCase(xml.getAttributeValue("allowadd"));
        this.autosort = xml.getAttributeValue("autosort");
        this.sqlcondition = xml.getAttributeValue("condition");
        this.allowSearch = "true".equalsIgnoreCase(xml.getAttributeValue("allowsearch"));
        this.doDeleteRemoved = "true".equalsIgnoreCase(xml.getAttributeValue("deleteremoved"));
        this.doRemoveRemoved = "true".equalsIgnoreCase(xml.getAttributeValue("removeremoved"));
        String show = xml.getAttributeValue("category", "standard");
        this.category = "subelement".equalsIgnoreCase(show) ? 2 : 1;
        this.searchmode = 2;
        if (!this.single) {
            this.field = null;
        }
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        if (((RelationAttribute)att).isSubelement()) {
            ArrayList<Long> newIds = new ArrayList<Long>();
            for (long subId : ((RelationAttribute)att).getElementIds()) {
                CmsElement sub = this.getApplication().loadElement(subId, this.getParent().getCurrentUser()).copy();
                for (RelationAttribute subatt : sub.getRelationAttributes()) {
                    if (subatt.getRelationcode() == null || !subatt.getRelationcode().equals(((RelationAttribute)att).getRelationcode())) continue;
                    subatt.clear();
                }
                newIds.add(sub.saveCopy());
            }
            for (long subId : newIds) {
                this.add(subId);
            }
        } else {
            this.add(((RelationAttribute)att).getElements());
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (CmsElementSummary e : this.elements) {
            if (e.isTrash()) continue;
            if (!first) {
                result.append("; ");
            }
            result.append(e.getTitle());
            first = false;
        }
        return result.toString();
    }

    @Override
    public String getDatabaseValue() {
        if (this.isSingle()) {
            if (this.elements.isEmpty()) {
                return "null";
            }
            return Long.toString(this.getFirstElementId());
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        result.append("(");
        for (CmsElementSummary e : this.elements) {
            if (!first) {
                result.append(",");
            }
            result.append(e.getId());
            first = false;
        }
        if (first) {
            result.append("-1");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public void setValue(String value) {
        this.parent.getApplication().getDatastorage().loadElementRelationByIds(this.parent, this, value);
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        block6: {
            if (this.isSingle()) {
                try {
                    long eleid = rs.getLong("id" + this.parent.getElementcode() + this.code, -1L);
                    if (eleid >= 0L) {
                        String eletitle = rs.getString(this.parent.getElementcode() + this.code);
                        String elelang = rs.getString(this.parent.getElementcode() + this.code + "lang");
                        String eleuuid = rs.getString(this.parent.getElementcode() + this.code + "uuid");
                        CmsElementSummary es = new CmsElementSummary(this.getParent(), eleid, eletitle, elelang);
                        if (es.getElementcode() != null) {
                            this.set(new CmsElementSummary(this.getParent(), eleid, eletitle, elelang));
                        }
                        break block6;
                    }
                    this.clear();
                }
                catch (Exception exception) {}
            } else {
                this.parent.getApplication().getDatastorage().loadElementRelation(this.parent, this);
            }
        }
    }

    @Override
    public int getType() {
        return 14;
    }

    public boolean isSubelement() {
        return this.category == 2;
    }

    @Override
    public Element toJDOMElement() {
        Element e = new Element(this.code);
        if (this.isSubelement()) {
            for (CmsElement ele : this.getFullElements()) {
                e.addContent((Content)ele.toJDOMElement(false, true));
            }
        } else {
            for (CmsElementSummary ele : this.elements) {
                e.addContent((Content)ele.toJDOMElement());
            }
        }
        return e;
    }

    @Override
    public void setValue(Element jdom) {
        this.setValue(jdom, null);
    }

    public void setValue(Element jdom, ZipFile zip) {
        this.clear();
        if (jdom != null) {
            List entries = jdom.getChildren();
            for (Element entry : entries) {
                try {
                    Object uuid;
                    if (this.isSubelement()) {
                        uuid = UUID.fromString(entry.getAttributeValue("uuid"));
                        long relId = this.app.getDatastorage().getElementId((UUID)uuid);
                        if (relId > 0L) {
                            CmsElement fullEle = this.parent.getApplication().loadElement(relId, this.parent.getCurrentUser());
                            fullEle.update(entry, zip);
                            this.addFullElement(fullEle);
                            continue;
                        }
                        CmsElement subele = this.app.createElement(entry.getName(), this.getParent().getCurrentUser());
                        subele.getOriginalId();
                        subele.update(entry, zip);
                        this.addFullElement(subele);
                        continue;
                    }
                    uuid = entry.getAttributeValue("uuid");
                    CmsElementSummary elesum = null;
                    if (uuid != null && !"".equals(uuid)) {
                        elesum = this.app.getDatastorage().getElementSummary(this.getParent(), UUID.fromString((String)uuid));
                    }
                    if (elesum != null) {
                        this.add(elesum);
                        continue;
                    }
                    this.temporaryElements.add(Long.parseLong(entry.getAttributeValue("id")));
                }
                catch (Exception ex) {
                    this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), "Error reading from XML : ID = " + entry.getAttributeValue("id") + " -> nothing added...");
                }
            }
        }
    }

    @Override
    protected String getHTMLview(String js) {
        StringBuilder html = new StringBuilder();
        if (this.isSubelement()) {
            return this.getHTMLviewSubelement(js);
        }
        String divstyle = "";
        if (this.getIncludeType() == 2) {
            divstyle = "style=\"background-color: #EEE\"";
        }
        for (CmsElementSummary cmsElementSummary : this.getElements()) {
            if (cmsElementSummary.isTrash()) continue;
            if (this.getIncludeType() == 3 || this.getIncludeType() == 2) {
                html.append("<div ").append(divstyle).append("><a class=\"grid_ele_link\" onclick=\"").append(js).append(".load(").append(cmsElementSummary.getId()).append(",'view','").append(js).append("','true')\">");
                html.append(cmsElementSummary.getTitle());
                html.append("</a></div>");
            }
            if (this.getIncludeType() != 2) continue;
            int l = Integer.parseInt(this.getApplication().getProperty("conf.relation.summarylength", "-1"));
            String s = cmsElementSummary.getSummary();
            if (l > 0 && s.length() > l) {
                s = s.substring(0, l) + " (...)";
            }
            html.append("<div style=\"margin-bottom: 15px\">");
            html.append(s.replace("\n", "<br>"));
            html.append("</div>");
        }
        if (this.allowMore() && CmsPermission.check(this.parent, this.parent.getCurrentUser(), 2) && this.allowAdd) {
            HashSet<String> types = new HashSet<String>();
            for (String et : this.getElementtypes()) {
                if (!this.getApplication().getDefaultElement(et).checkPermission(2)) continue;
                types.add(et);
            }
            if (!types.isEmpty()) {
                String string = this.app.getResourceUrl();
                String style = null;
                if (types.size() == 1) {
                    style = "display: none";
                }
                html.append(this.app.getElementtypesAsHtmlSelect("gridont_" + this.getCode() + "_newtype", "", types, style));
                String javascriptFunction = "createRelation";
                if (this.isSubelement()) {
                    javascriptFunction = "createSubelement";
                }
                if (!this.getParent().isNew()) {
                    html.append("<button type=\"button\"  onclick=\"" + js + "." + javascriptFunction + "(" + this.getParent().getId() + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + this.getAttributegroup() + "','" + js + "','view','" + this.getRelationcode() + "')\" > neu erstellen</button>");
                } else {
                    html.append("<button type=\"button\"  onclick=\"" + js + "." + javascriptFunction + "(" + this.getParent().getId() + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + this.getAttributegroup() + "','" + js + "','view','" + this.getRelationcode() + "',true)\" > neu erstellen</button>");
                }
            }
        }
        return html.toString();
    }

    private String getHTMLviewSubelement(String js) {
        StringBuilder html = new StringBuilder();
        CmsElement et = this.app.getDefaultElement(this.getElementtypes().iterator().next());
        html.append("<table border=\"1\" cellpadding=\"3px\" cellspacing=\"0\"><tr>");
        for (CmsAttribute att : et.getDataAttributes()) {
            if (att.isHidden()) continue;
            html.append("<td><b>").append(att.getLabel()).append("</b></td>");
        }
        html.append("</tr>");
        int counter = 0;
        for (CmsElementSummary e : this.getElements()) {
            CmsElement ele = e.getId() < 0L ? this.getFullElement(counter + 1) : this.getFullElement(e.getId());
            if (ele != null) {
                String css = ele.getSubelementCSS();
                html.append("<tr style=\"").append(css).append("\">");
                for (CmsAttribute att : ele.getDataAttributes()) {
                    if (att.isHidden()) continue;
                    String colAlign = "";
                    if (att.isNumber()) {
                        colAlign = "align=\"right\"";
                    }
                    html.append("<td ").append(colAlign).append(">").append(att.getFormattedValue().replaceAll("\n", "<br>")).append("</td>");
                }
                html.append("</tr>");
            }
            ++counter;
        }
        html.append("</table>");
        return html.toString();
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        return this.getHTMLedit(name, this.parent.getId(), js);
    }

    protected String getHTMLedit(String name, long parentid, String js) {
        String img = this.app.getResourceUrl();
        StringBuilder html = new StringBuilder();
        String attgroup = this.getAttributegroup();
        if (this.elements.size() > 0) {
            if (this.isSubelement()) {
                html.append(this.getHTMLeditSubelement(parentid, js));
            } else {
                for (CmsElementSummary e : this.elements) {
                    if (e.isTrash()) continue;
                    html.append("<div>");
                    html.append(this.getHTMLeditButtons(parentid, e.getId(), js));
                    html.append("<a class=\"grid_ele_link\" onclick=\"").append(js).append(".load(").append(e.getId()).append(",'view','").append(js).append("','true')\">");
                    html.append(e.getTitle());
                    html.append("</a>");
                    html.append("</div>");
                }
            }
        }
        if (this.allowMore()) {
            String inputid = "gridont_" + this.getCode() + "_input" + (int)(10000.0 * Math.random());
            if (this.allowSearch) {
                if (this.searchmode == 1) {
                    html.append(CmsElement.listAsSelect(this.app, "cms_" + this.code, this.code, this.elementtypes, this.parent.getCurrentUser()));
                } else {
                    html.append("<input type=\"text\" size=\"15\" id=\"" + inputid + "\" value=\"\">");
                    html.append("<img onclick=\"" + js + ".searchRelation(" + parentid + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + attgroup + "','" + inputid + "','" + js + "')\" src=\"" + img + "buttons/search.gif\"/> ");
                }
            }
            if (this.allowAdd) {
                HashSet<String> types = new HashSet<String>();
                for (String et : this.getElementtypes()) {
                    if (!this.getApplication().getDefaultElement(et).checkPermission(2)) continue;
                    types.add(et);
                }
                if (!types.isEmpty()) {
                    if (this.allowSearch) {
                        html.append("&nbsp;|&nbsp;");
                    }
                    String style = null;
                    if (types.size() == 1) {
                        style = "display: none";
                    }
                    html.append(this.app.getElementtypesAsHtmlSelect("gridont_" + this.getCode() + "_newtype", "", types, style));
                    String javascriptFunction = "createRelation";
                    if (this.isSubelement()) {
                        javascriptFunction = "createSubelement";
                    }
                    if (!this.getParent().isNew()) {
                        html.append("<img onclick=\"" + js + "." + javascriptFunction + "(" + parentid + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + attgroup + "','" + js + "','edit','" + this.getRelationcode() + "')\" src=\"" + img + "buttons/ele_add.gif\"/> ");
                    } else {
                        html.append("<img onclick=\"" + js + "." + javascriptFunction + "(" + parentid + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + attgroup + "','" + js + "','edit','" + this.getRelationcode() + "', true)\" src=\"" + img + "buttons/ele_add.gif\"/> ");
                    }
                }
            }
        }
        return html.toString();
    }

    private String getHTMLeditSubelement(long parentid, String js) {
        String img = this.app.getResourceUrl();
        StringBuffer html = new StringBuffer();
        CmsElement et = this.app.getDefaultElement(this.getElementtypes().iterator().next());
        html.append("<input type=\"hidden\" name=\"" + this.getCode() + "_subelement\" value=\"yes\"> ");
        html.append("<table>");
        int counter = 0;
        for (CmsElementSummary e : this.elements) {
            CmsElement ele = e.getId() < 0L ? this.getFullElement(counter + 1) : this.getFullElement(e.getId());
            if (e == null) continue;
            if (counter % 2 == 0) {
                html.append("<tr>");
            } else {
                html.append("<tr style=\"background: #ddd\">");
            }
            html.append("<td valign=\"top\">");
            html.append(this.getHTMLeditButtons(parentid, e.getId(), js));
            html.append("</td>");
            html.append("<td><table>");
            for (CmsAttribute att : ele.getDataAttributes()) {
                if (att.isHidden()) continue;
                String labelclass = "grid_ele_label";
                if (att.isRequired()) {
                    labelclass = labelclass + "_required";
                }
                if (att.isOfType(14)) {
                    if (att.isReadonly()) {
                        html.append("<tr><td class=\"" + labelclass + "\" valign=\"top\">").append(att.getLabel()).append("</td><td>").append(((RelationAttribute)att).getHTMLview(js)).append("</td></tr>");
                        continue;
                    }
                    html.append("<tr><td class=\"" + labelclass + "\" valign=\"top\">").append(att.getLabel()).append("</td><td>").append(((RelationAttribute)att).getHTMLedit(this.getCode() + "." + e.getId() + "." + att.getCode(), this.getParent().getId(), js)).append("</td></tr>");
                    continue;
                }
                if (att.isReadonly()) {
                    html.append("<tr><td class=\"" + labelclass + "\" valign=\"top\">").append(att.getLabel()).append("</td><td>").append(att.getHTMLview(js)).append("</td></tr>");
                    continue;
                }
                html.append("<tr><td class=\"" + labelclass + "\" valign=\"top\">").append(att.getLabel()).append("</td><td>").append(att.getHTMLedit(this.getCode() + "." + e.getId() + "." + att.getCode(), js)).append("</td></tr>");
            }
            html.append("</table></td>");
            html.append("</tr>");
            ++counter;
        }
        html.append("</table>");
        return html.toString();
    }

    private String getHTMLeditButtons(long parentId, long relId, String js) {
        StringBuffer buttons = new StringBuffer();
        String img = this.app.getResourceUrl();
        if (!(this.isSingle() || this.isSizeOne() || this.hasAutosort())) {
            buttons.append("<img src=\"" + img + "buttons/move_up.gif\" onclick=\"" + js + ".moveRelation(" + parentId + "," + this.getParent().getId() + ",'" + this.getCode() + "'," + relId + ",'up')\"");
            buttons.append(">");
            buttons.append("<img src=\"" + img + "buttons/move_down.gif\" onclick=\"" + js + ".moveRelation(" + parentId + "," + this.getParent().getId() + ",'" + this.getCode() + "'," + relId + ",'down')\"");
            buttons.append(">");
        }
        buttons.append("<img src=\"" + img + "buttons/ele_delete.gif\" onclick=\"" + js + ".deleteRelation(" + parentId + "," + this.getParent().getId() + ",'" + this.getCode() + "'," + relId + ",'" + this.getAttributegroup() + "')\">");
        return buttons.toString();
    }

    public String getHtmlRelationSearch(String term, CmsUser user, String idmain, String js, String attgroup) {
        CmsSqlSearch s = new CmsSqlSearch(this.app, user);
        s.addWhereFreetext(term);
        s.addSelectMeta();
        s.setElementtypes(this.getElementtypes());
        if (this.size() > 0) {
            s.addWhere("e.idElement NOT IN " + Util.toSqlString(this.getElementIds()));
        }
        s.setSort("el.title");
        if (this.sqlcondition != null) {
            s.addElementJoin(this.getElementtype(), "ele");
            s.addWhere(this.sqlcondition);
        }
        s.setLimit(this.getApplication().getProperty("web.relsearch.maxcount", null));
        List<DataRecord> recs = s.search().getResult();
        String inputid = "gridont_" + this.getCode() + "_search";
        if (idmain == null) {
            idmain = Long.toString(this.getParent().getId());
        }
        String img = this.app.getResourceUrl();
        StringBuilder html = new StringBuilder();
        html.append("Suche: <input type=\"text\" size=\"15\" id=\"" + inputid + "\" value=\"" + term + "\">");
        html.append("<img onclick=\"" + js + ".searchRelation(" + idmain + "," + this.getParent().getId() + ",'" + this.getCode() + "','" + attgroup + "','" + inputid + "','" + js + "')\" src=\"" + img + "buttons/search.gif\"/> ");
        html.append("<form id=\"gridelement_" + this.getCode() + "_searchform\">");
        html.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        for (DataRecord rec : recs) {
            String id = "grid_" + this.getCode() + "_" + rec.getString("meta_id");
            html.append("<tr>");
            html.append("<td>");
            html.append("<input style=\"margin-right: 5px; float: left\" type=\"checkbox\" name=\"" + id + "\" id=\"" + id + "\">");
            html.append("</td>");
            html.append("<td>");
            html.append("<img src=\"" + this.getApplication().getProperty("web.resourceurl", "") + "icons/" + rec.getString("meta_elementtype") + ".gif\"/>");
            html.append("</td>");
            html.append("<td>");
            html.append("<div style=\"cursor:pointer\" onclick=\"jQuery('#" + id + "').attr('checked', !jQuery('#" + id + "').attr('checked'))\">");
            html.append(rec.getString("meta_title")).append("</div>");
            html.append("</td>");
            html.append("</tr>");
        }
        html.append("</table>");
        html.append("</form>");
        return html.toString();
    }

    public String getCountRelationSearch(String term, CmsUser user) {
        List<DataRecord> recs;
        CmsSqlSearch s = new CmsSqlSearch(this.app, user);
        s.addWhereFreetext(term);
        s.addSelectMeta();
        s.setElementtypes(this.getElementtypes());
        if (this.size() > 0) {
            s.addWhere("e.idElement NOT IN " + Util.toSqlString(this.getElementIds()));
        }
        if (this.sqlcondition != null) {
            s.addElementJoin(this.getElementtype(), "ele");
            s.addWhere(this.sqlcondition);
        }
        if ((recs = s.search().getResult()).size() == 1) {
            return recs.get(0).getString("meta_id");
        }
        return "";
    }

    public void addElementtype(String type) {
        this.elementtypes.add(type);
    }

    public Set<String> getElementtypes() {
        return this.elementtypes;
    }

    public String getElementtype() {
        return this.elementtypes.iterator().next();
    }

    public int getIncludeType() {
        return this.includetype;
    }

    public boolean isSingle() {
        return this.single;
    }

    public String getInverseField() {
        return this.inversefield;
    }

    public boolean isSizeOne() {
        return this.maxsize == 1;
    }

    public boolean allowMore() {
        if (this.isSingle()) {
            for (CmsElementSummary e : this.elements) {
                if (e.isTrash()) continue;
                return false;
            }
            return true;
        }
        return this.maxsize == 0 || this.maxsize > this.size();
    }

    public String getRelationcode() {
        return this.relationcode;
    }

    public String getTableName() {
        return this.table;
    }

    public RelationAttribute setDirection(int dir) {
        this.direction = dir;
        return this;
    }

    public RelationAttribute setDeleteRemoved(boolean set) {
        this.doDeleteRemoved = set;
        return this;
    }

    public RelationAttribute setRemoveRemoved(boolean set) {
        this.doRemoveRemoved = set;
        return this;
    }

    public RelationAttribute setAllowSearch(boolean set) {
        this.allowSearch = set;
        return this;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean hasAutosort() {
        return this.autosort != null;
    }

    public String getAutosort() {
        return this.autosort;
    }

    public boolean deleteRemoved() {
        return this.doDeleteRemoved;
    }

    public boolean removeRemoved() {
        return this.doRemoveRemoved;
    }

    @Override
    public boolean checkValue(String value) {
        return true;
    }

    @Override
    public boolean hasValue() {
        return !this.elements.isEmpty();
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.fullelements.clear();
        this.deletedelements.clear();
    }

    public void clearTemporaryElements() {
        this.temporaryElements.clear();
    }

    public int size() {
        int count = 0;
        for (CmsElementSummary e : this.elements) {
            if (e.isTrash()) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void setElementAttribute(long id, String attcode, String attvalue) {
        CmsElement e = this.getFullElement(id);
        if (e != null) {
            e.setAttributeValue(attcode, attvalue);
        }
    }

    public List<CmsElementSummary> getElements() {
        return this.getElements(true);
    }

    public List<CmsElementSummary> getElements(boolean all) {
        if (all) {
            return this.elements;
        }
        ArrayList<CmsElementSummary> recs = new ArrayList<CmsElementSummary>();
        for (CmsElementSummary ee : this.elements) {
            if (ee.isTrash()) continue;
            recs.add(ee);
        }
        return recs;
    }

    public CmsElementSummary getElementSummary(long id) {
        for (CmsElementSummary e : this.getElements()) {
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    public int getElementIndex(long id) {
        CmsElementSummary e = this.getElementSummary(id);
        if (e == null) {
            return -1;
        }
        return this.elements.indexOf(e);
    }

    public List<Long> getElementIds() {
        return this.getElementIds(true);
    }

    public List<Long> getElementIds(boolean all) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (CmsElementSummary e : this.getElements()) {
            if (!all && e.isTrash()) continue;
            result.add(e.getId());
        }
        return result;
    }

    public long getFirstElementId() {
        for (CmsElementSummary e : this.getElements()) {
            if (e.isTrash()) continue;
            return e.getId();
        }
        return -1L;
    }

    public String getFirstElementTitle() {
        for (CmsElementSummary e : this.getElements()) {
            if (e.isTrash()) continue;
            return e.getTitle();
        }
        return "";
    }

    public CmsElementSummary getFirstElement() {
        for (CmsElementSummary e : this.getElements()) {
            if (e.isTrash()) continue;
            return e;
        }
        return null;
    }

    public CmsElementSummary getLastElement() {
        for (int ii = this.size() - 1; ii >= 0; --ii) {
            CmsElementSummary e = this.getElementByIndex(ii);
            if (e.isTrash()) continue;
            return e;
        }
        for (CmsElementSummary cmsElementSummary : this.getElements()) {
        }
        return null;
    }

    public CmsElementSummary getElementByIndex(int idx) {
        if (idx < 0 || idx >= this.elements.size()) {
            throw new IllegalArgumentException("Illegal index for element of attribute '" + this.getIdentifier() + "'");
        }
        return this.getElements().get(idx);
    }

    public CmsElementSummary getElement(long id) {
        int idx = this.getElementIndex(id);
        if (idx >= 0) {
            return this.getElementByIndex(idx);
        }
        return null;
    }

    public CmsElement getFullElement(long id) {
        CmsElement fullEle = this.fullelements.get(id);
        if (fullEle == null && (fullEle = this.parent.getApplication().loadElement(id, this.parent.getCurrentUser())) != null) {
            this.fullelements.put(id, fullEle);
        }
        return fullEle;
    }

    public Collection<CmsElement> getFullElements() {
        return this.fullelements.values();
    }

    public void add(long elementid) {
        CmsElementSummary elesum = this.app.getDatastorage().loadElementSummary(elementid, this.getParent().getCurrentUser());
        if (elesum != null) {
            if (this.isSubelement()) {
                this.addFullElement(elesum.getElement());
            } else {
                this.add(elesum);
            }
        }
    }

    public boolean add(CmsElementSummary e) {
        if (e == null) {
            return false;
        }
        if (this.isSingle()) {
            this.clear();
        }
        if (!this.allowMore()) {
            return false;
        }
        if (e.getId() < 0L || !this.contains(e.getId())) {
            this.elements.add(e);
            if (this.deletedelements.contains(e.getId())) {
                this.deletedelements.remove(e.getId());
            }
        } else {
            this.elements.set(this.getElementIndex(e.getId()), e);
        }
        return true;
    }

    public void add(List<CmsElementSummary> elements) {
        for (CmsElementSummary e : elements) {
            this.add(e);
        }
    }

    public void addTemporarily(List<CmsElementSummary> elements) {
        for (CmsElementSummary e : elements) {
            this.temporaryElements.add(e.getId());
        }
    }

    public void add(CmsElement e) {
        if (e != null) {
            if (this.isSubelement()) {
                this.addFullElement(e);
            } else {
                this.add(new CmsElementSummary(this.parent, e));
            }
        }
    }

    public void addFullElement(CmsElement e) {
        if (e != null && (e.getId() < 0L || !this.contains(e.getId())) && this.add(new CmsElementSummary(this.parent, e))) {
            if (e.getId() < 0L) {
                this.fullelements.put(Long.valueOf(this.size()), e);
            } else {
                this.fullelements.put(e.getId(), e);
            }
        }
    }

    public void set(CmsElement e) {
        this.clear();
        this.add(e);
    }

    public void set(long id) {
        this.clear();
        if (id >= 0L) {
            this.add(id);
        }
    }

    public void set(CmsElementSummary e) {
        this.clear();
        this.add(e);
    }

    public void addNew(String elementtype) {
        if (this.isSubelement()) {
            this.addFullElement(this.app.createElement(elementtype, this.parent.getCurrentUser()));
        } else {
            this.add(new CmsElementSummary(this.parent, elementtype, "No title"));
        }
    }

    public CmsElementSummary addNew(String elementtype, String title) {
        if (this.isSubelement()) {
            CmsElement ele = this.app.createElement(elementtype, this.parent.getCurrentUser());
            this.addFullElement(ele);
            return null;
        }
        CmsElementSummary ele = new CmsElementSummary(this.parent, elementtype, title);
        this.add(ele);
        return ele;
    }

    public void delete(int index) {
        if (index >= 0 && index < this.size()) {
            CmsElementSummary e = this.getElementByIndex(index);
            this.elements.remove(e);
            this.fullelements.remove(e.getId());
            this.deletedelements.add(e.getId());
            if (!e.isNew()) {
                if (this.deleteRemoved()) {
                    CmsElement.moveToTrash(this.app, e.getId(), this.parent.getCurrentUser());
                } else if (this.removeRemoved()) {
                    CmsElement.remove(this.app, e.getId(), this.getParent().getCurrentUser());
                }
            }
        }
    }

    public void delete(long relid) {
        CmsElementSummary e = this.getElementSummary(relid);
        if (e == null) {
            return;
        }
        this.elements.remove(e);
        this.fullelements.remove(e.getId());
        this.deletedelements.add(e.getId());
    }

    public void setDeleted(long relId) {
        CmsElementSummary e = this.getElementSummary(relId);
        if (e == null) {
            return;
        }
        e.setTrash(true);
    }

    public void remove(long relid) {
        CmsElementSummary e = this.getElementSummary(relid);
        if (e == null) {
            return;
        }
        this.elements.remove(e);
        this.fullelements.remove(e.getId());
    }

    public void deleteAll() {
        List<Long> ids = this.getElementIds();
        for (long id : ids) {
            this.delete(id);
        }
    }

    public boolean contains(long id) {
        for (CmsElementSummary e : this.elements) {
            if (e.getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String txt) {
        for (CmsElementSummary e : this.elements) {
            if (!e.getTitle().equals(txt)) continue;
            return true;
        }
        return false;
    }

    public void move(long id, String direction) {
        this.getApplication().getLogger().log(Level.INFO, "Moving relation " + id + " of element " + this.parent.getId() + " " + direction);
        int idx = this.getElementIndex(id);
        if (idx < 0) {
            return;
        }
        int dir = 1;
        if ("up".equalsIgnoreCase(direction)) {
            dir = -1;
        } else if ("down".equalsIgnoreCase(direction)) {
            dir = 1;
        } else {
            return;
        }
        if (dir == -1 && idx == 0) {
            return;
        }
        if (dir == 1 && idx == this.elements.size() - 1) {
            return;
        }
        boolean done = false;
        int newidx = idx;
        while (!done) {
            CmsElementSummary ele;
            if ((newidx += dir) == 0) {
                ele = this.elements.remove(idx);
                this.elements.add(newidx, ele);
                done = true;
                continue;
            }
            if (newidx >= this.elements.size()) {
                ele = this.elements.remove(idx);
                this.elements.add(ele);
                done = true;
                continue;
            }
            if (this.elements.get(newidx).isTrash()) continue;
            ele = this.elements.remove(idx);
            this.elements.add(newidx, ele);
            done = true;
        }
    }

    public ArrayList<Long> getTemporaryElementIds() {
        return this.temporaryElements;
    }

    public void applyTemporaryIds(HashMap<Long, Long> idMapping) {
        ArrayList<Long> toBeRemoved = new ArrayList<Long>();
        for (long id : this.temporaryElements) {
            Long newId = idMapping.get(id);
            if (newId != null) {
                this.add(newId);
                continue;
            }
            toBeRemoved.add(id);
        }
        for (long id : toBeRemoved) {
            this.remove(id);
            this.temporaryElements.remove(id);
        }
    }
}

