/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class TextAttribute
extends CmsAttribute {
    protected int size = 250;
    private String value;
    private boolean password;

    public TextAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        if (xml.getAttribute("size") != null) {
            this.size = xml.getAttribute("size").getIntValue();
        }
        this.password = this.checkXmlBoolean(xml, "password");
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        this.value = ((TextAttribute)att).value;
    }

    @Override
    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    @Override
    public String getDatabaseValue() {
        return Util.toSqlString((String)this.value);
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.value = rs.getString(this.parent.getElementcode() + this.code);
    }

    @Override
    public boolean checkValue(String value) {
        return true;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !"".equals(this.value);
    }

    @Override
    public void clear() {
        this.value = null;
    }

    public boolean isPassword() {
        return this.password;
    }

    @Override
    protected String getHTMLview(String js) {
        if (this.isPassword()) {
            return "***";
        }
        if (this.hasLink()) {
            return "<a target=\"_new\" href=\"" + this.getLink() + "\">" + this.getValue() + "</a>";
        }
        return this.getValue();
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuilder html = new StringBuilder();
        html.append("<input id=\"cms_").append(name).append("\" name=\"").append(name).append("\" ");
        html.append("type=\"").append(this.isPassword() ? "password" : "text").append("\" size=\"45\" ");
        html.append("value=\"").append(this.getValue()).append("\" />");
        return html.toString();
    }

    @Override
    public int getType() {
        return 12;
    }

    public int getSize() {
        return this.size;
    }
}

