/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class UploadAttribute
extends CmsAttribute {
    protected int maxcount;
    protected List<UploadItem> items;
    protected List<UploadItem> itemsDeleted;
    protected List<UploadItem> itemsToBeRemoved;
    protected String extensions = null;
    protected String extensionDesc = null;

    public UploadAttribute(CmsApplication app, CmsElement parent, Element xml) throws DataConversionException {
        super(app, parent, xml);
        if (xml.getAttribute("maxcount") != null) {
            this.maxcount = xml.getAttribute("maxcount").getIntValue();
        }
        if (xml.getAttribute("extensions") != null) {
            this.extensions = xml.getAttributeValue("extensions").split(";")[0];
            this.extensionDesc = xml.getAttributeValue("extensions").split(";")[1];
        }
        this.items = new ArrayList<UploadItem>();
        this.itemsDeleted = new ArrayList<UploadItem>();
        this.itemsToBeRemoved = new ArrayList<UploadItem>();
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getExtensionDescription() {
        return this.extensionDesc;
    }

    @Override
    public void copyFrom(CmsAttribute att) {
        try {
            List<UploadItem> items = ((UploadAttribute)att).getAllUploadItems();
            this.clear();
            for (UploadItem item : items) {
                File f = new File(this.app.getTempfileLocation(), item.getName());
                this.app.getFileAccess().copy(item.getFile(), f);
                UploadItem itemCopy = new UploadItem(this.app, f.getParentFile(), f.getName(), "", f.length(), new Date(), 2);
                itemCopy.setAttributecode(this.getCode());
                itemCopy.setDeleted(item.isDeleted());
                this.addUpload(itemCopy);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (UploadItem item : this.items) {
            if (!first) {
                result.append(", ");
            }
            result.append("<a href=\"").append(item.getUrl(this.app.getServletUrl() + "element")).append("\">").append(item.getName()).append("</a>");
            first = false;
        }
        return result.toString();
    }

    @Override
    public void setValue(String value) {
        File f = new File(value);
        if (f.isFile()) {
            this.addUpload(f);
        } else {
            String[] split;
            for (String filename : split = value.split(",")) {
                f = new File(filename);
                if (!f.isFile()) continue;
                this.addUpload(f);
            }
        }
    }

    @Override
    public void setValue(DataRecord rs, boolean loadfull) {
        this.clear();
        ArrayList<UploadItem> uploadItems = this.app.getDatastorage().getUploadItems(this.parent.getId(), this.getCode(), true);
        for (UploadItem item : uploadItems) {
            if (item.isDeleted()) {
                this.itemsDeleted.add(item);
                continue;
            }
            this.items.add(item);
        }
    }

    public void setValue(Element jdom, ZipFile zip) {
        if (jdom == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List items = jdom.getChildren("uploaditem");
        sb.append(items.size() + " UploadItems found, added: ");
        List<UploadItem> itemsOrigs = this.getAllUploadItems();
        ArrayList<UploadItem> itemsOrigInSource = new ArrayList<UploadItem>();
        for (Element element : items) {
            try {
                String xmlName = element.getAttributeValue("name", "");
                String xmlFilename = element.getAttributeValue("filename", "");
                String xmlMd5 = element.getAttributeValue("md5", "");
                long xmlFilesize = Util.parseLong((String)element.getAttributeValue("filesize", "-1"), (long)-1L);
                long xmlId = Util.parseLong((String)element.getAttributeValue("id", "-1"), (long)-1L);
                boolean foundInOrig = false;
                UploadItem itemToBeReplaced = null;
                for (UploadItem itemOrig : itemsOrigs) {
                    boolean sameSize;
                    String eleName = itemOrig.getName();
                    String eleFilename = itemOrig.getFilename();
                    String eleMd5 = "xxx";
                    long eleFilesize = itemOrig.getFilesize();
                    long eleId = itemOrig.getId();
                    boolean sameName = xmlName.equals(eleName);
                    boolean sameFilename = xmlFilename.equals(eleFilename);
                    boolean bl = sameSize = eleFilesize > itemOrig.getFilesize() - 10L && eleFilesize < itemOrig.getFilesize() + 10L;
                    if (!sameName || !sameSize) continue;
                    foundInOrig = true;
                    itemToBeReplaced = itemOrig;
                    itemsOrigInSource.add(itemOrig);
                    break;
                }
                if (foundInOrig) continue;
                if (xmlName == null || "".equals(xmlName)) {
                    xmlName = "no-name";
                }
                File f = new File(this.app.getTempfileLocation(), xmlName);
                String filenameWithoutExt = Util.getFileNameWithoutExtension((File)f);
                String filenameExt = Util.getFileExtension((File)f);
                int counter = 1;
                while (f.exists()) {
                    String filenamePlus = filenameWithoutExt + counter + "." + filenameExt;
                    ++counter;
                    f = new File(this.app.getTempfileLocation(), filenamePlus);
                }
                if (zip != null) {
                    ZipEntry entry = zip.getEntry(xmlFilename);
                    if (entry == null) {
                        entry = zip.getEntry(xmlName);
                    }
                    if (entry != null) {
                        InputStream inputStream = zip.getInputStream(entry);
                        FileOutputStream fos = new FileOutputStream(f);
                        Util.copy((InputStream)inputStream, (OutputStream)fos);
                        Util.closeStream((Closeable)inputStream);
                        Util.closeStream((Closeable)fos);
                    } else {
                        this.app.getLogger().severe("cannot find upload in ZIP: " + xmlFilename);
                    }
                }
                UploadItem newItem = this.addUpload(f);
                if (xmlId >= 0L && !this.app.getDatastorage().hasUpload(xmlId)) {
                    if (newItem.getId() < xmlId) {
                        this.app.getDatastorage().setSequenceValue("idfileupload", xmlId + 1L);
                    }
                    newItem.setId(xmlId);
                }
                sb.append(f.getName()).append(", ");
            }
            catch (IOException ex) {
                Logger.getLogger(UploadAttribute.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        sb.append("deleted: ");
        for (UploadItem uploadItem : itemsOrigs) {
            if (itemsOrigInSource.contains(uploadItem)) continue;
            uploadItem.setDeleted(true);
            sb.append(uploadItem.getName()).append(", ");
        }
    }

    @Override
    public boolean checkValue(String value) {
        return true;
    }

    @Override
    public boolean hasValue() {
        return !this.items.isEmpty();
    }

    @Override
    public void clear() {
        for (UploadItem item : this.items) {
            item.setDeleted(true);
        }
        this.itemsDeleted.addAll(this.items);
        this.items.clear();
    }

    public void clearWithoutDelete() {
        this.itemsDeleted.clear();
        this.items.clear();
    }

    @Override
    public String getDatabaseValue() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        result.append("(");
        for (UploadItem item : this.getAllUploadItems()) {
            if (!first) {
                result.append(",");
            }
            result.append(item.getId());
            first = false;
        }
        if (first) {
            result.append("-1");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public int getType() {
        return 15;
    }

    public boolean isSingle() {
        return this.maxcount == 1;
    }

    @Override
    protected String getHTMLedit(String name, String js) {
        StringBuilder html = new StringBuilder();
        String img = this.app.getResourceUrl();
        html.append("<input type=\"hidden\" meta_id=\"cms_").append(name).append("\" name=\"").append(name).append("\" />");
        for (UploadItem item : this.items) {
            html.append("[").append(item.getId()).append("] ");
            html.append("<a href=\"").append(item.getUrl(this.app.getServletUrl() + "element")).append("\">").append(item.getName()).append("</a>");
            html.append("&nbsp;<img src=\"").append(img + "buttons/ele_trash.gif\" onclick=\"" + js + ".deleteUpload(").append(this.parent.getId()).append(",'").append(this.getCode()).append("',").append(item.getId()).append(")\">");
            html.append("<br>");
        }
        if (this.maxcount <= 0 || this.items.size() < this.maxcount) {
            html.append("<input type=\"file\" meta_id=\"cms_").append(name).append("\" name=\"").append(name).append(".1\" />");
        }
        if (this.maxcount <= 0 || this.items.size() < this.maxcount - 1) {
            html.append("&nbsp;&nbsp;<img onclick=\"" + js + ".addUpload2(").append(this.parent.getId()).append(",'").append(this.getCode()).append("',2,'").append(this.app.getServletUrl()).append("','" + js + "')\" src=\"").append(img).append("buttons/ele_add.gif\"><br/>");
        }
        html.append("<div id=\"gridont_" + this.parent.getId() + "_" + this.getCode() + "_newfiles\"></div>");
        html.append("&nbsp;&nbsp;Zwischenspeichern:&nbsp; <img onclick=\"" + js + ".addUpload(").append(this.parent.getId()).append(",'").append(this.getCode()).append("',2,'").append(this.app.getServletUrl()).append("','").append(this.getAttributegroup()).append("','" + js + "')\" src=\"").append(img).append("buttons/apply.gif\"><br/>");
        return html.toString();
    }

    @Override
    public String toHTMLedit(String style, String js) {
        StringBuilder html = new StringBuilder();
        html.append("<tr style=\"").append(style).append("\"><td class=\"grid_ele_label\" valign=\"top\">");
        html.append(this.getLabel());
        html.append("</td><td id=\"gridcms_dlg_element_").append(this.parent.getId()).append("_").append(this.getCode()).append("\" class=\"grid_ele_value\" valign=\"top\">");
        html.append(this.getHTMLedit(this.getCode(), js));
        html.append("</td></tr>");
        return html.toString();
    }

    @Override
    public Element toJDOMElement() {
        Element e = new Element(this.code);
        for (UploadItem item : this.getAllUploadItems()) {
            e.addContent((Content)item.toJDOMElement());
        }
        return e;
    }

    public String getFilenames() {
        return this.getFilenames(",");
    }

    public String getFilenames(String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (UploadItem item : this.getAllUploadItems()) {
            if (!first) {
                sb.append(separator);
            }
            sb.append(item.getName());
            first = false;
        }
        return sb.toString();
    }

    public ArrayList<String> getFilenamesAsArrayList() {
        ArrayList<String> names = new ArrayList<String>();
        for (UploadItem item : this.getAllUploadItems()) {
            names.add(item.getName());
        }
        return names;
    }

    public boolean hasUploads() {
        return this.items.size() > 0;
    }

    public void addUpload(String id, HashMap<Long, UploadItem> uploads) {
        try {
            UploadItem item = uploads.get(Long.parseLong(id));
            item.setReference(this.parent.getId(), this.parent.getElementcode());
            if (item.isDeleted()) {
                this.itemsDeleted.add(item);
            } else {
                this.items.add(item);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UploadAttribute.class.getName()).log(Level.SEVERE, "Cannot add upload: " + ex.getMessage(), ex);
        }
    }

    public void addUpload(UploadItem item) {
        try {
            if (!this.isVirtual()) {
                item.setReference(this.parent.getId(), this.parent.getElementcode());
            }
            if (this.isSingle() && !item.isDeleted()) {
                this.items.clear();
            }
            UploadItem foundItem = null;
            for (UploadItem it : this.items) {
                if (it.getId() != item.getId()) continue;
                foundItem = it;
            }
            if (foundItem != null) {
                if (item.isDeleted()) {
                    this.itemsDeleted.add(item);
                    this.items.remove(foundItem);
                }
            } else if (item.isDeleted()) {
                this.itemsDeleted.add(item);
            } else {
                this.items.add(item);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UploadAttribute.class.getName()).log(Level.SEVERE, "Cannot add upload: " + ex.getMessage(), ex);
        }
    }

    public UploadItem addUpload(File f) {
        if (f == null) {
            return null;
        }
        String mimetype = "";
        UploadItem item = new UploadItem(this.app, f.getParentFile(), f.getName(), mimetype, f.length(), new Date(), 2);
        item.setAttributecode(this.code);
        this.addUpload(item);
        return item;
    }

    public UploadItem addUpload(String filename, ZipFile zip) {
        UploadItem item = null;
        try {
            ZipEntry entry;
            File f = new File(this.app.getTempfileLocation(), filename);
            if (zip != null && (entry = zip.getEntry(f.getName())) != null) {
                InputStream inputStream = zip.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(f);
                Util.copy((InputStream)inputStream, (OutputStream)fos);
                Util.closeStream((Closeable)inputStream);
                Util.closeStream((Closeable)fos);
            }
            return this.addUpload(f);
        }
        catch (IOException iOException) {
            return item;
        }
    }

    public UploadItem getUploadItemById(long id) {
        for (UploadItem item : this.items) {
            if (item.getId() != id) continue;
            return item;
        }
        return null;
    }

    public List<UploadItem> getUploadItems() {
        return this.items;
    }

    public List<UploadItem> getAllUploadItems() {
        ArrayList<UploadItem> allitems = new ArrayList<UploadItem>();
        allitems.addAll(this.items);
        allitems.addAll(this.itemsDeleted);
        return allitems;
    }

    public ArrayList<UploadItem> getImageUploadItems() {
        return this.getImageUploadItems(-1L);
    }

    public ArrayList<UploadItem> getImageUploadItems(long detail) {
        ArrayList<UploadItem> imageitems = new ArrayList<UploadItem>();
        for (UploadItem item : this.items) {
            if (!item.isImage() || detail >= 0L && item.getUploadDetail() != detail) continue;
            imageitems.add(item);
        }
        return imageitems;
    }

    public UploadItem getUploadItem(int index) {
        if (this.items.size() <= index) {
            return null;
        }
        return this.items.get(index);
    }

    public UploadItem getFirstUploadItem() {
        if (this.size() > 0) {
            return this.getUploadItem(0);
        }
        return null;
    }

    public String getFirstUploadItemName() {
        if (this.size() > 0) {
            return this.getFirstUploadItem().getName();
        }
        return "";
    }

    public File getFirstUploadItemFile() {
        if (this.size() > 0) {
            return this.getFirstUploadItem().getFile();
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    public void deleteUpload(long id) {
        UploadItem item = this.getUploadItemById(id);
        if (item != null) {
            this.deleteUpload(item);
        }
    }

    public void deleteUpload(UploadItem item) {
        UploadItem item2;
        item.setDeleted(true);
        boolean success = this.items.remove(item);
        if (!success && (item2 = this.getUploadItemById(item.getId())) != null) {
            this.items.remove(item2);
        }
        this.itemsDeleted.add(item);
    }

    public void removeDeletedItems() {
        this.itemsToBeRemoved.addAll(this.itemsDeleted);
        this.itemsDeleted.clear();
    }

    public void clearItemsToBeRemoved() {
        this.itemsToBeRemoved.clear();
    }

    public void purge() {
        this.itemsToBeRemoved.addAll(this.itemsDeleted);
        this.itemsDeleted.clear();
    }

    public List<UploadItem> getRemovedUploadItems() {
        return this.itemsToBeRemoved;
    }
}

