/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.content;

import at.grid.cms.element.CmsElementPermission;
import at.grid.cms.element.CmsUser;
import at.grid.util.Util;
import java.util.List;

public class CmsPermission {
    public static final int ALL = 1;
    public static final int AUTHENTICATED = 2;
    public static final int OWNER = 3;
    public static final int CREATOR = 4;
    public static final int NONE = 5;
    public static final int VIEW = 1;
    public static final int EDIT = 2;
    public static final int MANAGE = 3;

    public static String getWhereClause(CmsUser u, String tbl) {
        if (u == null) {
            return "(1=0)";
        }
        if (u.isSuperadmin()) {
            return "(1=1)";
        }
        int accesslevel = 1;
        if (u.isAuthenticated()) {
            accesslevel = 2;
        }
        List<Long> groupids = u.getGroupIds();
        String groups = Util.toSqlString(groupids);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(" ((").append(tbl).append(".idworkflowstatus = 4 OR ").append(tbl).append(".idworkflowstatus IS NULL) AND (");
        sb.append(" ").append(tbl).append(".idreadaccess <= ").append(accesslevel);
        if (!groupids.isEmpty()) {
            sb.append(" OR (").append(tbl).append(".idreadaccess = 3 AND ").append(tbl).append(".metaowner IN ").append(Util.toSqlString(u.getGroupIds())).append(")");
        }
        sb.append(")) OR (");
        sb.append("").append(tbl).append(".idwriteaccess <= ").append(accesslevel);
        if (!groupids.isEmpty()) {
            sb.append(" OR (").append(tbl).append(".idwriteaccess = 3 AND ").append(tbl).append(".metaowner IN ").append(Util.toSqlString(u.getGroupIds())).append(")");
        }
        sb.append(") OR (").append(tbl).append(".metacreator = ").append(u.getId()).append(") ");
        sb.append(")");
        return sb.toString();
    }

    public static boolean check(CmsElementPermission e, CmsUser u, int action) {
        if (u.isSuperadmin()) {
            return true;
        }
        if (action == 1) {
            if (e.getCreatorId() == u.getId()) {
                return true;
            }
            if (e.getReadAccess() == 3L && u.isGuest(e.getOwnerId())) {
                return true;
            }
            if (e.getReadAccess() == 2L && u.isAuthenticated()) {
                return true;
            }
            return e.getReadAccess() == 1L;
        }
        if (action == 2) {
            if (e.getId() == u.getId()) {
                return true;
            }
            if (e.getCreatorId() == u.getId()) {
                return true;
            }
            if (e.getWriteAccess() == 3L && u.isAuthor(e.getOwnerId())) {
                return true;
            }
            if (e.getWriteAccess() == 2L && u.isAuthenticated()) {
                return true;
            }
            return e.getWriteAccess() == 1L;
        }
        if (action == 3) {
            return e.getWriteAccess() == 3L && u.isAdmin(e.getOwnerId());
        }
        return false;
    }
}

